/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Number of lambda functions and sum of the invocations of all lambda functions for each hour for a given organization.")
@JsonPropertyOrder(value={"func_count", "hour", "invocations_sum"})
public class UsageLambdaHour {
    public static final String JSON_PROPERTY_FUNC_COUNT = "func_count";
    private Long funcCount;
    public static final String JSON_PROPERTY_HOUR = "hour";
    private OffsetDateTime hour;
    public static final String JSON_PROPERTY_INVOCATIONS_SUM = "invocations_sum";
    private Long invocationsSum;

    public UsageLambdaHour funcCount(Long funcCount) {
        this.funcCount = funcCount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Contains the number of different functions for each region and AWS account.")
    @JsonProperty(value="func_count")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getFuncCount() {
        return this.funcCount;
    }

    public void setFuncCount(Long funcCount) {
        this.funcCount = funcCount;
    }

    public UsageLambdaHour hour(OffsetDateTime hour) {
        this.hour = hour;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The hour for the usage.")
    @JsonProperty(value="hour")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getHour() {
        return this.hour;
    }

    public void setHour(OffsetDateTime hour) {
        this.hour = hour;
    }

    public UsageLambdaHour invocationsSum(Long invocationsSum) {
        this.invocationsSum = invocationsSum;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Contains the sum of invocations of all functions.")
    @JsonProperty(value="invocations_sum")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getInvocationsSum() {
        return this.invocationsSum;
    }

    public void setInvocationsSum(Long invocationsSum) {
        this.invocationsSum = invocationsSum;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UsageLambdaHour usageLambdaHour = (UsageLambdaHour)o;
        return Objects.equals(this.funcCount, usageLambdaHour.funcCount) && Objects.equals(this.hour, usageLambdaHour.hour) && Objects.equals(this.invocationsSum, usageLambdaHour.invocationsSum);
    }

    public int hashCode() {
        return Objects.hash(this.funcCount, this.hour, this.invocationsSum);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UsageLambdaHour {\n");
        sb.append("    funcCount: ").append(this.toIndentedString(this.funcCount)).append("\n");
        sb.append("    hour: ").append(this.toIndentedString(this.hour)).append("\n");
        sb.append("    invocationsSum: ").append(this.toIndentedString(this.invocationsSum)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

