/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.model;

import com.datadog.api.v1.client.model.CheckStatusWidgetDefinitionType;
import com.datadog.api.v1.client.model.WidgetGrouping;
import com.datadog.api.v1.client.model.WidgetTextAlign;
import com.datadog.api.v1.client.model.WidgetTime;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Check status shows the current status or number of results for any check performed.")
@JsonPropertyOrder(value={"check", "group", "group_by", "grouping", "tags", "time", "title", "title_align", "title_size", "type"})
public class CheckStatusWidgetDefinition {
    public static final String JSON_PROPERTY_CHECK = "check";
    private String check;
    public static final String JSON_PROPERTY_GROUP = "group";
    private String group;
    public static final String JSON_PROPERTY_GROUP_BY = "group_by";
    private List<String> groupBy = null;
    public static final String JSON_PROPERTY_GROUPING = "grouping";
    private WidgetGrouping grouping;
    public static final String JSON_PROPERTY_TAGS = "tags";
    private List<String> tags = null;
    public static final String JSON_PROPERTY_TIME = "time";
    private WidgetTime time;
    public static final String JSON_PROPERTY_TITLE = "title";
    private String title;
    public static final String JSON_PROPERTY_TITLE_ALIGN = "title_align";
    private WidgetTextAlign titleAlign;
    public static final String JSON_PROPERTY_TITLE_SIZE = "title_size";
    private String titleSize;
    public static final String JSON_PROPERTY_TYPE = "type";
    private CheckStatusWidgetDefinitionType type = CheckStatusWidgetDefinitionType.CHECK_STATUS;

    public CheckStatusWidgetDefinition check(String check) {
        this.check = check;
        return this;
    }

    @ApiModelProperty(example="", required=true, value="Name of the check to use in the widget.")
    @JsonProperty(value="check")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getCheck() {
        return this.check;
    }

    public void setCheck(String check) {
        this.check = check;
    }

    public CheckStatusWidgetDefinition group(String group) {
        this.group = group;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Group reporting a single check.")
    @JsonProperty(value="group")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public CheckStatusWidgetDefinition groupBy(List<String> groupBy) {
        this.groupBy = groupBy;
        return this;
    }

    public CheckStatusWidgetDefinition addGroupByItem(String groupByItem) {
        if (this.groupBy == null) {
            this.groupBy = new ArrayList<String>();
        }
        this.groupBy.add(groupByItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="List of tag prefixes to group by in the case of a cluster check.")
    @JsonProperty(value="group_by")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getGroupBy() {
        return this.groupBy;
    }

    public void setGroupBy(List<String> groupBy) {
        this.groupBy = groupBy;
    }

    public CheckStatusWidgetDefinition grouping(WidgetGrouping grouping) {
        this.grouping = grouping;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="grouping")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public WidgetGrouping getGrouping() {
        return this.grouping;
    }

    public void setGrouping(WidgetGrouping grouping) {
        this.grouping = grouping;
    }

    public CheckStatusWidgetDefinition tags(List<String> tags) {
        this.tags = tags;
        return this;
    }

    public CheckStatusWidgetDefinition addTagsItem(String tagsItem) {
        if (this.tags == null) {
            this.tags = new ArrayList<String>();
        }
        this.tags.add(tagsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="List of tags used to filter the groups reporting a cluster check.")
    @JsonProperty(value="tags")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getTags() {
        return this.tags;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    public CheckStatusWidgetDefinition time(WidgetTime time) {
        this.time = time;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="time")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public WidgetTime getTime() {
        return this.time;
    }

    public void setTime(WidgetTime time) {
        this.time = time;
    }

    public CheckStatusWidgetDefinition title(String title) {
        this.title = title;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Title of the widget.")
    @JsonProperty(value="title")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public CheckStatusWidgetDefinition titleAlign(WidgetTextAlign titleAlign) {
        this.titleAlign = titleAlign;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="title_align")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public WidgetTextAlign getTitleAlign() {
        return this.titleAlign;
    }

    public void setTitleAlign(WidgetTextAlign titleAlign) {
        this.titleAlign = titleAlign;
    }

    public CheckStatusWidgetDefinition titleSize(String titleSize) {
        this.titleSize = titleSize;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Size of the title.")
    @JsonProperty(value="title_size")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTitleSize() {
        return this.titleSize;
    }

    public void setTitleSize(String titleSize) {
        this.titleSize = titleSize;
    }

    public CheckStatusWidgetDefinition type(CheckStatusWidgetDefinitionType type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public CheckStatusWidgetDefinitionType getType() {
        return this.type;
    }

    public void setType(CheckStatusWidgetDefinitionType type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CheckStatusWidgetDefinition checkStatusWidgetDefinition = (CheckStatusWidgetDefinition)o;
        return Objects.equals(this.check, checkStatusWidgetDefinition.check) && Objects.equals(this.group, checkStatusWidgetDefinition.group) && Objects.equals(this.groupBy, checkStatusWidgetDefinition.groupBy) && Objects.equals((Object)this.grouping, (Object)checkStatusWidgetDefinition.grouping) && Objects.equals(this.tags, checkStatusWidgetDefinition.tags) && Objects.equals(this.time, checkStatusWidgetDefinition.time) && Objects.equals(this.title, checkStatusWidgetDefinition.title) && Objects.equals((Object)this.titleAlign, (Object)checkStatusWidgetDefinition.titleAlign) && Objects.equals(this.titleSize, checkStatusWidgetDefinition.titleSize) && Objects.equals((Object)this.type, (Object)checkStatusWidgetDefinition.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.check, this.group, this.groupBy, this.grouping, this.tags, this.time, this.title, this.titleAlign, this.titleSize, this.type});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CheckStatusWidgetDefinition {\n");
        sb.append("    check: ").append(this.toIndentedString(this.check)).append("\n");
        sb.append("    group: ").append(this.toIndentedString(this.group)).append("\n");
        sb.append("    groupBy: ").append(this.toIndentedString(this.groupBy)).append("\n");
        sb.append("    grouping: ").append(this.toIndentedString((Object)this.grouping)).append("\n");
        sb.append("    tags: ").append(this.toIndentedString(this.tags)).append("\n");
        sb.append("    time: ").append(this.toIndentedString(this.time)).append("\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    titleAlign: ").append(this.toIndentedString((Object)this.titleAlign)).append("\n");
        sb.append("    titleSize: ").append(this.toIndentedString(this.titleSize)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

