/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v2.client.model;

import com.datadog.api.v2.client.model.PermissionAttributes;
import com.datadog.api.v2.client.model.PermissionsType;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Permission object.")
@JsonPropertyOrder(value={"attributes", "id", "type"})
public class Permission {
    public static final String JSON_PROPERTY_ATTRIBUTES = "attributes";
    private PermissionAttributes attributes;
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_TYPE = "type";
    private PermissionsType type = PermissionsType.PERMISSIONS;

    public Permission attributes(PermissionAttributes attributes) {
        this.attributes = attributes;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="attributes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public PermissionAttributes getAttributes() {
        return this.attributes;
    }

    public void setAttributes(PermissionAttributes attributes) {
        this.attributes = attributes;
    }

    public Permission id(String id) {
        this.id = id;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ID of the permission.")
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Permission type(PermissionsType type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public PermissionsType getType() {
        return this.type;
    }

    public void setType(PermissionsType type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Permission permission = (Permission)o;
        return Objects.equals(this.attributes, permission.attributes) && Objects.equals(this.id, permission.id) && Objects.equals((Object)this.type, (Object)permission.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.attributes, this.id, this.type});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Permission {\n");
        sb.append("    attributes: ").append(this.toIndentedString(this.attributes)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

