/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v2.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="JSON object containing all log attributes and their associated values.")
@JsonPropertyOrder(value={"attributes", "host", "message", "service", "status", "tags", "timestamp"})
public class LogAttributes {
    public static final String JSON_PROPERTY_ATTRIBUTES = "attributes";
    private Map<String, Object> attributes = null;
    public static final String JSON_PROPERTY_HOST = "host";
    private String host;
    public static final String JSON_PROPERTY_MESSAGE = "message";
    private String message;
    public static final String JSON_PROPERTY_SERVICE = "service";
    private String service;
    public static final String JSON_PROPERTY_STATUS = "status";
    private String status;
    public static final String JSON_PROPERTY_TAGS = "tags";
    private List<Object> tags = null;
    public static final String JSON_PROPERTY_TIMESTAMP = "timestamp";
    private OffsetDateTime timestamp;

    public LogAttributes attributes(Map<String, Object> attributes) {
        this.attributes = attributes;
        return this;
    }

    public LogAttributes putAttributesItem(String key, Object attributesItem) {
        if (this.attributes == null) {
            this.attributes = new HashMap<String, Object>();
        }
        this.attributes.put(key, attributesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="{\"customAttribute\":123,\"duration\":2345}", value="JSON object of attributes from your log.")
    @JsonProperty(value="attributes")
    @JsonInclude(content=JsonInclude.Include.ALWAYS, value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<String, Object> attributes) {
        this.attributes = attributes;
    }

    public LogAttributes host(String host) {
        this.host = host;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="i-0123", value="Name of the machine from where the logs are being sent.")
    @JsonProperty(value="host")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public LogAttributes message(String message) {
        this.message = message;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Host connected to remote", value="The message [reserved attribute](https://docs.datadoghq.com/logs/log_collection/#reserved-attributes) of your log. By default, Datadog ingests the value of the message attribute as the body of the log entry. That value is then highlighted and displayed in the Logstream, where it is indexed for full text search.")
    @JsonProperty(value="message")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public LogAttributes service(String service) {
        this.service = service;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="agent", value="The name of the application or service generating the log events. It is used to switch from Logs to APM, so make sure you define the same value when you use both products.")
    @JsonProperty(value="service")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getService() {
        return this.service;
    }

    public void setService(String service) {
        this.service = service;
    }

    public LogAttributes status(String status) {
        this.status = status;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="INFO", value="Status of the message associated with your log.")
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public LogAttributes tags(List<Object> tags) {
        this.tags = tags;
        return this;
    }

    public LogAttributes addTagsItem(Object tagsItem) {
        if (this.tags == null) {
            this.tags = new ArrayList<Object>();
        }
        this.tags.add(tagsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="[\"team:A\"]", value="Array of tags associated with your log.")
    @JsonProperty(value="tags")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<Object> getTags() {
        return this.tags;
    }

    public void setTags(List<Object> tags) {
        this.tags = tags;
    }

    public LogAttributes timestamp(OffsetDateTime timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="2019-01-02T09:42:36.320Z", value="Timestamp of your log.")
    @JsonProperty(value="timestamp")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(OffsetDateTime timestamp) {
        this.timestamp = timestamp;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LogAttributes logAttributes = (LogAttributes)o;
        return Objects.equals(this.attributes, logAttributes.attributes) && Objects.equals(this.host, logAttributes.host) && Objects.equals(this.message, logAttributes.message) && Objects.equals(this.service, logAttributes.service) && Objects.equals(this.status, logAttributes.status) && Objects.equals(this.tags, logAttributes.tags) && Objects.equals(this.timestamp, logAttributes.timestamp);
    }

    public int hashCode() {
        return Objects.hash(this.attributes, this.host, this.message, this.service, this.status, this.tags, this.timestamp);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LogAttributes {\n");
        sb.append("    attributes: ").append(this.toIndentedString(this.attributes)).append("\n");
        sb.append("    host: ").append(this.toIndentedString(this.host)).append("\n");
        sb.append("    message: ").append(this.toIndentedString(this.message)).append("\n");
        sb.append("    service: ").append(this.toIndentedString(this.service)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("    tags: ").append(this.toIndentedString(this.tags)).append("\n");
        sb.append("    timestamp: ").append(this.toIndentedString(this.timestamp)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

