/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.model;

import com.datadog.api.v1.client.model.MetricsQueryResponseSeries;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Response Object that includes your query and the list of metrics retrieved.")
@JsonPropertyOrder(value={"error", "from_date", "group_by", "message", "query", "res_type", "series", "status", "to_date"})
public class MetricsQueryResponse {
    public static final String JSON_PROPERTY_ERROR = "error";
    private String error;
    public static final String JSON_PROPERTY_FROM_DATE = "from_date";
    private Long fromDate;
    public static final String JSON_PROPERTY_GROUP_BY = "group_by";
    private List<String> groupBy = null;
    public static final String JSON_PROPERTY_MESSAGE = "message";
    private String message;
    public static final String JSON_PROPERTY_QUERY = "query";
    private String query;
    public static final String JSON_PROPERTY_RES_TYPE = "res_type";
    private String resType;
    public static final String JSON_PROPERTY_SERIES = "series";
    private List<MetricsQueryResponseSeries> series = null;
    public static final String JSON_PROPERTY_STATUS = "status";
    private String status;
    public static final String JSON_PROPERTY_TO_DATE = "to_date";
    private Long toDate;

    @Nullable
    @ApiModelProperty(value="Message indicating the errors if status is not `ok`.")
    @JsonProperty(value="error")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getError() {
        return this.error;
    }

    @Nullable
    @ApiModelProperty(value="Start of requested time window, milliseconds since Unix epoch.")
    @JsonProperty(value="from_date")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getFromDate() {
        return this.fromDate;
    }

    @Nullable
    @ApiModelProperty(value="List of tag keys on which to group.")
    @JsonProperty(value="group_by")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getGroupBy() {
        return this.groupBy;
    }

    @Nullable
    @ApiModelProperty(value="Message indicating `success` if status is `ok`.")
    @JsonProperty(value="message")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMessage() {
        return this.message;
    }

    @Nullable
    @ApiModelProperty(value="Query string")
    @JsonProperty(value="query")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getQuery() {
        return this.query;
    }

    @Nullable
    @ApiModelProperty(example="time_series", value="Type of response.")
    @JsonProperty(value="res_type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getResType() {
        return this.resType;
    }

    @Nullable
    @ApiModelProperty(value="List of timeseries queried.")
    @JsonProperty(value="series")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<MetricsQueryResponseSeries> getSeries() {
        return this.series;
    }

    @Nullable
    @ApiModelProperty(example="ok", value="Status of the query.")
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getStatus() {
        return this.status;
    }

    @Nullable
    @ApiModelProperty(value="End of requested time window, milliseconds since Unix epoch.")
    @JsonProperty(value="to_date")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getToDate() {
        return this.toDate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MetricsQueryResponse metricsQueryResponse = (MetricsQueryResponse)o;
        return Objects.equals(this.error, metricsQueryResponse.error) && Objects.equals(this.fromDate, metricsQueryResponse.fromDate) && Objects.equals(this.groupBy, metricsQueryResponse.groupBy) && Objects.equals(this.message, metricsQueryResponse.message) && Objects.equals(this.query, metricsQueryResponse.query) && Objects.equals(this.resType, metricsQueryResponse.resType) && Objects.equals(this.series, metricsQueryResponse.series) && Objects.equals(this.status, metricsQueryResponse.status) && Objects.equals(this.toDate, metricsQueryResponse.toDate);
    }

    public int hashCode() {
        return Objects.hash(this.error, this.fromDate, this.groupBy, this.message, this.query, this.resType, this.series, this.status, this.toDate);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MetricsQueryResponse {\n");
        sb.append("    error: ").append(this.toIndentedString(this.error)).append("\n");
        sb.append("    fromDate: ").append(this.toIndentedString(this.fromDate)).append("\n");
        sb.append("    groupBy: ").append(this.toIndentedString(this.groupBy)).append("\n");
        sb.append("    message: ").append(this.toIndentedString(this.message)).append("\n");
        sb.append("    query: ").append(this.toIndentedString(this.query)).append("\n");
        sb.append("    resType: ").append(this.toIndentedString(this.resType)).append("\n");
        sb.append("    series: ").append(this.toIndentedString(this.series)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("    toDate: ").append(this.toIndentedString(this.toDate)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

