/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Number of Synthetics API tests run for each hour for a given organization.")
@JsonPropertyOrder(value={"check_calls_count", "hour"})
public class UsageSyntheticsAPIHour {
    public static final String JSON_PROPERTY_CHECK_CALLS_COUNT = "check_calls_count";
    private Long checkCallsCount;
    public static final String JSON_PROPERTY_HOUR = "hour";
    private OffsetDateTime hour;

    public UsageSyntheticsAPIHour checkCallsCount(Long checkCallsCount) {
        this.checkCallsCount = checkCallsCount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Contains the number of Synthetics API tests run.")
    @JsonProperty(value="check_calls_count")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getCheckCallsCount() {
        return this.checkCallsCount;
    }

    public void setCheckCallsCount(Long checkCallsCount) {
        this.checkCallsCount = checkCallsCount;
    }

    public UsageSyntheticsAPIHour hour(OffsetDateTime hour) {
        this.hour = hour;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The hour for the usage.")
    @JsonProperty(value="hour")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getHour() {
        return this.hour;
    }

    public void setHour(OffsetDateTime hour) {
        this.hour = hour;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UsageSyntheticsAPIHour usageSyntheticsAPIHour = (UsageSyntheticsAPIHour)o;
        return Objects.equals(this.checkCallsCount, usageSyntheticsAPIHour.checkCallsCount) && Objects.equals(this.hour, usageSyntheticsAPIHour.hour);
    }

    public int hashCode() {
        return Objects.hash(this.checkCallsCount, this.hour);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UsageSyntheticsAPIHour {\n");
        sb.append("    checkCallsCount: ").append(this.toIndentedString(this.checkCallsCount)).append("\n");
        sb.append("    hour: ").append(this.toIndentedString(this.hour)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

