/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;
import org.openapitools.jackson.nullable.JsonNullable;

@ApiModel(description="Alerting time window options.")
@JsonPropertyOrder(value={"recovery_window", "trigger_window"})
public class MonitorThresholdWindowOptions {
    public static final String JSON_PROPERTY_RECOVERY_WINDOW = "recovery_window";
    private JsonNullable<String> recoveryWindow = JsonNullable.undefined();
    public static final String JSON_PROPERTY_TRIGGER_WINDOW = "trigger_window";
    private JsonNullable<String> triggerWindow = JsonNullable.undefined();

    public MonitorThresholdWindowOptions recoveryWindow(String recoveryWindow) {
        this.recoveryWindow = JsonNullable.of((Object)recoveryWindow);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Describes how long an anomalous metric must be normal before the alert recovers.")
    @JsonIgnore
    public String getRecoveryWindow() {
        return (String)this.recoveryWindow.orElse(null);
    }

    @JsonProperty(value="recovery_window")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getRecoveryWindow_JsonNullable() {
        return this.recoveryWindow;
    }

    @JsonProperty(value="recovery_window")
    public void setRecoveryWindow_JsonNullable(JsonNullable<String> recoveryWindow) {
        this.recoveryWindow = recoveryWindow;
    }

    public void setRecoveryWindow(String recoveryWindow) {
        this.recoveryWindow = JsonNullable.of((Object)recoveryWindow);
    }

    public MonitorThresholdWindowOptions triggerWindow(String triggerWindow) {
        this.triggerWindow = JsonNullable.of((Object)triggerWindow);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Describes how long a metric must be anomalous before an alert triggers.")
    @JsonIgnore
    public String getTriggerWindow() {
        return (String)this.triggerWindow.orElse(null);
    }

    @JsonProperty(value="trigger_window")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getTriggerWindow_JsonNullable() {
        return this.triggerWindow;
    }

    @JsonProperty(value="trigger_window")
    public void setTriggerWindow_JsonNullable(JsonNullable<String> triggerWindow) {
        this.triggerWindow = triggerWindow;
    }

    public void setTriggerWindow(String triggerWindow) {
        this.triggerWindow = JsonNullable.of((Object)triggerWindow);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MonitorThresholdWindowOptions monitorThresholdWindowOptions = (MonitorThresholdWindowOptions)o;
        return Objects.equals(this.recoveryWindow, monitorThresholdWindowOptions.recoveryWindow) && Objects.equals(this.triggerWindow, monitorThresholdWindowOptions.triggerWindow);
    }

    public int hashCode() {
        return Objects.hash(this.recoveryWindow, this.triggerWindow);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MonitorThresholdWindowOptions {\n");
        sb.append("    recoveryWindow: ").append(this.toIndentedString(this.recoveryWindow)).append("\n");
        sb.append("    triggerWindow: ").append(this.toIndentedString(this.triggerWindow)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

