/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.spark.xml.util;

import com.databricks.spark.xml.XmlOptions$;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import javax.xml.namespace.QName;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.ws.commons.schema.XmlSchema;
import org.apache.ws.commons.schema.XmlSchemaAll;
import org.apache.ws.commons.schema.XmlSchemaAllMember;
import org.apache.ws.commons.schema.XmlSchemaAny;
import org.apache.ws.commons.schema.XmlSchemaAttribute;
import org.apache.ws.commons.schema.XmlSchemaAttributeOrGroupRef;
import org.apache.ws.commons.schema.XmlSchemaChoice;
import org.apache.ws.commons.schema.XmlSchemaChoiceMember;
import org.apache.ws.commons.schema.XmlSchemaCollection;
import org.apache.ws.commons.schema.XmlSchemaComplexContent;
import org.apache.ws.commons.schema.XmlSchemaComplexContentExtension;
import org.apache.ws.commons.schema.XmlSchemaComplexType;
import org.apache.ws.commons.schema.XmlSchemaContent;
import org.apache.ws.commons.schema.XmlSchemaContentModel;
import org.apache.ws.commons.schema.XmlSchemaElement;
import org.apache.ws.commons.schema.XmlSchemaFacet;
import org.apache.ws.commons.schema.XmlSchemaFractionDigitsFacet;
import org.apache.ws.commons.schema.XmlSchemaParticle;
import org.apache.ws.commons.schema.XmlSchemaSequence;
import org.apache.ws.commons.schema.XmlSchemaSequenceMember;
import org.apache.ws.commons.schema.XmlSchemaSimpleContent;
import org.apache.ws.commons.schema.XmlSchemaSimpleContentExtension;
import org.apache.ws.commons.schema.XmlSchemaSimpleType;
import org.apache.ws.commons.schema.XmlSchemaSimpleTypeContent;
import org.apache.ws.commons.schema.XmlSchemaSimpleTypeRestriction;
import org.apache.ws.commons.schema.XmlSchemaTotalDigitsFacet;
import org.apache.ws.commons.schema.XmlSchemaType;
import org.apache.ws.commons.schema.XmlSchemaUse;
import org.apache.ws.commons.schema.constants.Constants;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.jdk.CollectionConverters$;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

public final class XSDToSchema$ {
    public static XSDToSchema$ MODULE$;

    static {
        new XSDToSchema$();
    }

    public StructType read(File xsdFile) {
        XmlSchemaCollection xmlSchemaCollection = new XmlSchemaCollection();
        xmlSchemaCollection.setBaseUri(xsdFile.getParent());
        XmlSchema xmlSchema = xmlSchemaCollection.read((Reader)new InputStreamReader((InputStream)new FileInputStream(xsdFile), StandardCharsets.UTF_8));
        return this.getStructType(xmlSchema);
    }

    public StructType read(Path xsdFile) {
        return this.read(xsdFile.toFile());
    }

    public StructType read(String xsdString) {
        XmlSchema xmlSchema = new XmlSchemaCollection().read((Reader)new StringReader(xsdString));
        return this.getStructType(xmlSchema);
    }

    private StructField getStructField(XmlSchema xmlSchema, XmlSchemaType schemaType) {
        StructField structField;
        XmlSchemaType xmlSchemaType = schemaType;
        if (xmlSchemaType instanceof XmlSchemaSimpleType) {
            StringType$ stringType$;
            XmlSchemaSimpleType xmlSchemaSimpleType = (XmlSchemaSimpleType)xmlSchemaType;
            XmlSchemaSimpleTypeContent xmlSchemaSimpleTypeContent = xmlSchemaSimpleType.getContent();
            if (xmlSchemaSimpleTypeContent instanceof XmlSchemaSimpleTypeRestriction) {
                Object object;
                QName typeName;
                XmlSchemaSimpleTypeRestriction xmlSchemaSimpleTypeRestriction = (XmlSchemaSimpleTypeRestriction)xmlSchemaSimpleTypeContent;
                QName qName = xmlSchemaSimpleType.getQName();
                QName qName2 = qName == null ? xmlSchemaSimpleTypeRestriction.getBaseTypeName() : qName;
                QName qName3 = qName2;
                QName qName4 = typeName = (QName)((MapLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(xmlSchema.getSchemaTypes()).asScala()).get((Object)qName3).map((Function1 & Serializable & scala.Serializable)s -> ((XmlSchemaSimpleTypeRestriction)((XmlSchemaSimpleType)s).getContent()).getBaseTypeName()).getOrElse((Function0 & Serializable & scala.Serializable)() -> qName3);
                QName qName5 = Constants.XSD_BOOLEAN;
                QName qName6 = qName4;
                if (!(qName5 != null ? !((Object)qName5).equals(qName6) : qName6 != null)) {
                    object = BooleanType$.MODULE$;
                } else {
                    QName qName7 = Constants.XSD_DECIMAL;
                    QName qName8 = qName4;
                    if (!(qName7 != null ? !((Object)qName7).equals(qName8) : qName8 != null)) {
                        Buffer facets = (Buffer)CollectionConverters$.MODULE$.asScalaBufferConverter(xmlSchemaSimpleTypeRestriction.getFacets()).asScala();
                        int fracDigits = BoxesRunTime.unboxToInt((Object)facets.collectFirst((PartialFunction)new scala.Serializable(){
                            public static final long serialVersionUID = 0L;

                            public final <A1 extends XmlSchemaFacet, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                                Object object;
                                A1 A1 = x1;
                                if (A1 instanceof XmlSchemaFractionDigitsFacet) {
                                    XmlSchemaFractionDigitsFacet xmlSchemaFractionDigitsFacet = (XmlSchemaFractionDigitsFacet)A1;
                                    object = BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(xmlSchemaFractionDigitsFacet.getValue().toString())).toInt());
                                } else {
                                    object = function1.apply(x1);
                                }
                                return (B1)object;
                            }

                            public final boolean isDefinedAt(XmlSchemaFacet x1) {
                                XmlSchemaFacet xmlSchemaFacet = x1;
                                boolean bl = xmlSchemaFacet instanceof XmlSchemaFractionDigitsFacet;
                                return bl;
                            }
                        }).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 18));
                        int totalDigits = BoxesRunTime.unboxToInt((Object)facets.collectFirst((PartialFunction)new scala.Serializable(){
                            public static final long serialVersionUID = 0L;

                            public final <A1 extends XmlSchemaFacet, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                                Object object;
                                A1 A1 = x2;
                                if (A1 instanceof XmlSchemaTotalDigitsFacet) {
                                    XmlSchemaTotalDigitsFacet xmlSchemaTotalDigitsFacet = (XmlSchemaTotalDigitsFacet)A1;
                                    object = BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(xmlSchemaTotalDigitsFacet.getValue().toString())).toInt());
                                } else {
                                    object = function1.apply(x2);
                                }
                                return (B1)object;
                            }

                            public final boolean isDefinedAt(XmlSchemaFacet x2) {
                                XmlSchemaFacet xmlSchemaFacet = x2;
                                boolean bl = xmlSchemaFacet instanceof XmlSchemaTotalDigitsFacet;
                                return bl;
                            }
                        }).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 38));
                        object = new DecimalType(totalDigits, package$.MODULE$.min(totalDigits, fracDigits));
                    } else {
                        QName qName9 = Constants.XSD_UNSIGNEDLONG;
                        QName qName10 = qName4;
                        if (!(qName9 != null ? !((Object)qName9).equals(qName10) : qName10 != null)) {
                            object = new DecimalType(38, 0);
                        } else {
                            QName qName11 = Constants.XSD_DOUBLE;
                            QName qName12 = qName4;
                            if (!(qName11 != null ? !((Object)qName11).equals(qName12) : qName12 != null)) {
                                object = DoubleType$.MODULE$;
                            } else {
                                QName qName13 = Constants.XSD_FLOAT;
                                QName qName14 = qName4;
                                if (!(qName13 != null ? !((Object)qName13).equals(qName14) : qName14 != null)) {
                                    object = FloatType$.MODULE$;
                                } else {
                                    QName qName15 = Constants.XSD_BYTE;
                                    QName qName16 = qName4;
                                    if (!(qName15 != null ? !((Object)qName15).equals(qName16) : qName16 != null)) {
                                        object = ByteType$.MODULE$;
                                    } else {
                                        boolean bl;
                                        QName qName17 = Constants.XSD_SHORT;
                                        QName qName18 = qName4;
                                        if (!(qName17 != null ? !((Object)qName17).equals(qName18) : qName18 != null)) {
                                            bl = true;
                                        } else {
                                            QName qName19 = Constants.XSD_UNSIGNEDBYTE;
                                            QName qName20 = qName4;
                                            bl = !(qName19 != null ? !((Object)qName19).equals(qName20) : qName20 != null);
                                        }
                                        if (bl) {
                                            object = ShortType$.MODULE$;
                                        } else {
                                            boolean bl2;
                                            QName qName21 = Constants.XSD_INTEGER;
                                            QName qName22 = qName4;
                                            if (!(qName21 != null ? !((Object)qName21).equals(qName22) : qName22 != null)) {
                                                bl2 = true;
                                            } else {
                                                QName qName23 = Constants.XSD_NEGATIVEINTEGER;
                                                QName qName24 = qName4;
                                                if (!(qName23 != null ? !((Object)qName23).equals(qName24) : qName24 != null)) {
                                                    bl2 = true;
                                                } else {
                                                    QName qName25 = Constants.XSD_NONNEGATIVEINTEGER;
                                                    QName qName26 = qName4;
                                                    if (!(qName25 != null ? !((Object)qName25).equals(qName26) : qName26 != null)) {
                                                        bl2 = true;
                                                    } else {
                                                        QName qName27 = Constants.XSD_NONPOSITIVEINTEGER;
                                                        QName qName28 = qName4;
                                                        if (!(qName27 != null ? !((Object)qName27).equals(qName28) : qName28 != null)) {
                                                            bl2 = true;
                                                        } else {
                                                            QName qName29 = Constants.XSD_POSITIVEINTEGER;
                                                            QName qName30 = qName4;
                                                            if (!(qName29 != null ? !((Object)qName29).equals(qName30) : qName30 != null)) {
                                                                bl2 = true;
                                                            } else {
                                                                QName qName31 = Constants.XSD_UNSIGNEDSHORT;
                                                                QName qName32 = qName4;
                                                                bl2 = !(qName31 != null ? !((Object)qName31).equals(qName32) : qName32 != null);
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                            if (bl2) {
                                                object = IntegerType$.MODULE$;
                                            } else {
                                                boolean bl3;
                                                QName qName33 = Constants.XSD_LONG;
                                                QName qName34 = qName4;
                                                if (!(qName33 != null ? !((Object)qName33).equals(qName34) : qName34 != null)) {
                                                    bl3 = true;
                                                } else {
                                                    QName qName35 = Constants.XSD_UNSIGNEDINT;
                                                    QName qName36 = qName4;
                                                    bl3 = !(qName35 != null ? !((Object)qName35).equals(qName36) : qName36 != null);
                                                }
                                                if (bl3) {
                                                    object = LongType$.MODULE$;
                                                } else {
                                                    QName qName37 = Constants.XSD_DATE;
                                                    QName qName38 = qName4;
                                                    if (!(qName37 != null ? !((Object)qName37).equals(qName38) : qName38 != null)) {
                                                        object = DateType$.MODULE$;
                                                    } else {
                                                        QName qName39 = Constants.XSD_DATETIME;
                                                        QName qName40 = qName4;
                                                        object = !(qName39 != null ? !((Object)qName39).equals(qName40) : qName40 != null) ? TimestampType$.MODULE$ : StringType$.MODULE$;
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
                stringType$ = object;
            } else {
                stringType$ = StringType$.MODULE$;
            }
            StringType$ schemaType2 = stringType$;
            structField = new StructField("baseName", (DataType)schemaType2, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
        } else if (xmlSchemaType instanceof XmlSchemaComplexType) {
            StructField structField2;
            XmlSchemaComplexType xmlSchemaComplexType = (XmlSchemaComplexType)xmlSchemaType;
            XmlSchemaContentModel xmlSchemaContentModel = xmlSchemaComplexType.getContentModel();
            if (xmlSchemaContentModel instanceof XmlSchemaSimpleContent) {
                XmlSchemaSimpleContent xmlSchemaSimpleContent = (XmlSchemaSimpleContent)xmlSchemaContentModel;
                XmlSchemaContent xmlSchemaContent = xmlSchemaSimpleContent.getContent();
                if (!(xmlSchemaContent instanceof XmlSchemaSimpleContentExtension)) {
                    throw new IllegalArgumentException(new StringBuilder(21).append("Unsupported content: ").append(xmlSchemaContent).toString());
                }
                XmlSchemaSimpleContentExtension xmlSchemaSimpleContentExtension = (XmlSchemaSimpleContentExtension)xmlSchemaContent;
                StructField baseStructField = this.getStructField(xmlSchema, xmlSchema.getParent().getTypeByQName(xmlSchemaSimpleContentExtension.getBaseTypeName()));
                StructField value = new StructField("_VALUE", baseStructField.dataType(), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
                Seq attributes = ((SeqLike)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(xmlSchemaSimpleContentExtension.getAttributes()).asScala()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    XmlSchemaAttributeOrGroupRef xmlSchemaAttributeOrGroupRef = x0$1;
                    if (!(xmlSchemaAttributeOrGroupRef instanceof XmlSchemaAttribute)) {
                        throw new MatchError((Object)xmlSchemaAttributeOrGroupRef);
                    }
                    XmlSchemaAttribute xmlSchemaAttribute = (XmlSchemaAttribute)xmlSchemaAttributeOrGroupRef;
                    StructField baseStructField = MODULE$.getStructField(xmlSchema, xmlSchema.getParent().getTypeByQName(xmlSchemaAttribute.getSchemaTypeName()));
                    XmlSchemaUse xmlSchemaUse = xmlSchemaAttribute.getUse();
                    XmlSchemaUse xmlSchemaUse2 = XmlSchemaUse.REQUIRED;
                    StructField structField = new StructField(new StringBuilder(1).append("_").append(xmlSchemaAttribute.getName()).toString(), baseStructField.dataType(), xmlSchemaUse == null ? xmlSchemaUse2 != null : !xmlSchemaUse.equals(xmlSchemaUse2), StructField$.MODULE$.apply$default$4());
                    return structField;
                }, Buffer$.MODULE$.canBuildFrom())).toSeq();
                StructField structField3 = value;
                StructField structField4 = new StructField(xmlSchemaComplexType.getName(), (DataType)StructType$.MODULE$.apply((Seq)attributes.$plus$colon((Object)structField3, Seq$.MODULE$.canBuildFrom())), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
                structField2 = structField4;
            } else if (xmlSchemaContentModel instanceof XmlSchemaComplexContent) {
                StructField[] structFieldArray;
                XmlSchemaComplexContentExtension xmlSchemaComplexContentExtension;
                XmlSchemaComplexContent xmlSchemaComplexContent = (XmlSchemaComplexContent)xmlSchemaContentModel;
                XmlSchemaContent complexContent = xmlSchemaComplexContent.getContent();
                XmlSchemaContent xmlSchemaContent = complexContent;
                if (xmlSchemaContent instanceof XmlSchemaComplexContentExtension) {
                    xmlSchemaComplexContentExtension = (XmlSchemaComplexContentExtension)xmlSchemaContent;
                    StructField baseStructField = this.getStructField(xmlSchema, xmlSchema.getParent().getTypeByQName(xmlSchemaComplexContentExtension.getBaseTypeName()));
                    DataType dataType = baseStructField.dataType();
                    if (!(dataType instanceof StructType)) {
                        throw new IllegalArgumentException(new StringBuilder(43).append("Non-StructType in ComplexContentExtension: ").append(dataType).toString());
                    }
                    StructType structType = (StructType)dataType;
                    structFieldArray = structType.fields();
                } else {
                    throw new IllegalArgumentException(new StringBuilder(21).append("Unsupported content: ").append(xmlSchemaContent).toString());
                }
                StructField[] baseFields = structFieldArray;
                Seq<StructField> extendedFields = this.getStructFieldsFromParticle(xmlSchemaComplexContentExtension.getParticle(), xmlSchema);
                StructField structField5 = new StructField(schemaType.getQName().getLocalPart(), (DataType)new StructType((StructField[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])baseFields)).$plus$plus(extendedFields, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class)))), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
                structField2 = structField5;
            } else if (xmlSchemaContentModel == null) {
                Seq<StructField> childFields = this.getStructFieldsFromParticle(xmlSchemaComplexType.getParticle(), xmlSchema);
                Seq attributes = ((SeqLike)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(xmlSchemaComplexType.getAttributes()).asScala()).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                    XmlSchemaAttributeOrGroupRef xmlSchemaAttributeOrGroupRef = x0$2;
                    if (!(xmlSchemaAttributeOrGroupRef instanceof XmlSchemaAttribute)) {
                        throw new MatchError((Object)xmlSchemaAttributeOrGroupRef);
                    }
                    XmlSchemaAttribute xmlSchemaAttribute = (XmlSchemaAttribute)xmlSchemaAttributeOrGroupRef;
                    QName qName = xmlSchemaAttribute.getSchemaTypeName();
                    Object object = qName == null ? StringType$.MODULE$ : MODULE$.getStructField(xmlSchema, xmlSchema.getParent().getTypeByQName(qName)).dataType();
                    StringType$ attributeType = object;
                    XmlSchemaUse xmlSchemaUse = xmlSchemaAttribute.getUse();
                    XmlSchemaUse xmlSchemaUse2 = XmlSchemaUse.REQUIRED;
                    StructField structField = new StructField(new StringBuilder(1).append("_").append(xmlSchemaAttribute.getName()).toString(), (DataType)attributeType, xmlSchemaUse == null ? xmlSchemaUse2 != null : !xmlSchemaUse.equals(xmlSchemaUse2), StructField$.MODULE$.apply$default$4());
                    return structField;
                }, Buffer$.MODULE$.canBuildFrom())).toSeq();
                structField2 = new StructField(xmlSchemaComplexType.getName(), (DataType)StructType$.MODULE$.apply((Seq)childFields.$plus$plus((GenTraversableOnce)attributes, Seq$.MODULE$.canBuildFrom())), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
            } else {
                throw new IllegalArgumentException(new StringBuilder(27).append("Unsupported content model: ").append(xmlSchemaContentModel).toString());
            }
            structField = structField2;
        } else {
            throw new IllegalArgumentException(new StringBuilder(33).append("Unsupported schema element type: ").append(xmlSchemaType).toString());
        }
        return structField;
    }

    private StructType getStructType(XmlSchema xmlSchema) {
        return StructType$.MODULE$.apply((Seq)((scala.collection.mutable.MapLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(xmlSchema.getElements()).asScala()).toSeq().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            XmlSchemaElement schemaElement = (XmlSchemaElement)tuple2._2();
            XmlSchemaType schemaType = schemaElement.getSchemaType();
            StructField rootType = MODULE$.getStructField(xmlSchema, schemaType);
            StructField structField = new StructField(schemaElement.getName(), rootType.dataType(), schemaElement.getMinOccurs() == 0L, StructField$.MODULE$.apply$default$4());
            return structField;
        }, Seq$.MODULE$.canBuildFrom()));
    }

    private Seq<StructField> getStructFieldsFromParticle(XmlSchemaParticle particle, XmlSchema xmlSchema) {
        Seq seq;
        XmlSchemaParticle xmlSchemaParticle = particle;
        if (xmlSchemaParticle instanceof XmlSchemaAll) {
            XmlSchemaAll xmlSchemaAll = (XmlSchemaAll)xmlSchemaParticle;
            seq = ((SeqLike)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(xmlSchemaAll.getItems()).asScala()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                XmlSchemaAllMember xmlSchemaAllMember = x0$1;
                if (!(xmlSchemaAllMember instanceof XmlSchemaElement)) {
                    throw new MatchError((Object)xmlSchemaAllMember);
                }
                XmlSchemaElement xmlSchemaElement = (XmlSchemaElement)xmlSchemaAllMember;
                StructField baseStructField = MODULE$.getStructField(xmlSchema, xmlSchemaElement.getSchemaType());
                boolean nullable = xmlSchemaElement.getMinOccurs() == 0L;
                StructField structField = xmlSchemaElement.getMaxOccurs() == 1L ? new StructField(xmlSchemaElement.getName(), baseStructField.dataType(), nullable, StructField$.MODULE$.apply$default$4()) : new StructField(xmlSchemaElement.getName(), (DataType)ArrayType$.MODULE$.apply(baseStructField.dataType()), nullable, StructField$.MODULE$.apply$default$4());
                return structField;
            }, Buffer$.MODULE$.canBuildFrom())).toSeq();
        } else if (xmlSchemaParticle instanceof XmlSchemaChoice) {
            XmlSchemaChoice xmlSchemaChoice = (XmlSchemaChoice)xmlSchemaParticle;
            seq = ((SeqLike)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(xmlSchemaChoice.getItems()).asScala()).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                StructField structField;
                XmlSchemaChoiceMember xmlSchemaChoiceMember = x0$2;
                if (xmlSchemaChoiceMember instanceof XmlSchemaElement) {
                    XmlSchemaElement xmlSchemaElement = (XmlSchemaElement)xmlSchemaChoiceMember;
                    StructField baseStructField = MODULE$.getStructField(xmlSchema, xmlSchemaElement.getSchemaType());
                    structField = xmlSchemaElement.getMaxOccurs() == 1L ? new StructField(xmlSchemaElement.getName(), baseStructField.dataType(), true, StructField$.MODULE$.apply$default$4()) : new StructField(xmlSchemaElement.getName(), (DataType)ArrayType$.MODULE$.apply(baseStructField.dataType()), true, StructField$.MODULE$.apply$default$4());
                } else if (xmlSchemaChoiceMember instanceof XmlSchemaAny) {
                    XmlSchemaAny xmlSchemaAny = (XmlSchemaAny)xmlSchemaChoiceMember;
                    StringType$ dataType = xmlSchemaAny.getMaxOccurs() > 1L ? ArrayType$.MODULE$.apply((DataType)StringType$.MODULE$) : StringType$.MODULE$;
                    structField = new StructField(XmlOptions$.MODULE$.DEFAULT_WILDCARD_COL_NAME(), (DataType)dataType, true, StructField$.MODULE$.apply$default$4());
                } else {
                    throw new MatchError((Object)xmlSchemaChoiceMember);
                }
                return structField;
            }, Buffer$.MODULE$.canBuildFrom())).toSeq();
        } else if (xmlSchemaParticle instanceof XmlSchemaSequence) {
            XmlSchemaSequence xmlSchemaSequence = (XmlSchemaSequence)xmlSchemaParticle;
            seq = ((SeqLike)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(xmlSchemaSequence.getItems()).asScala()).flatMap((Function1 & Serializable & scala.Serializable)x$2 -> {
                Seq seq;
                XmlSchemaSequenceMember xmlSchemaSequenceMember = x$2;
                if (xmlSchemaSequenceMember instanceof XmlSchemaChoice) {
                    XmlSchemaChoice xmlSchemaChoice = (XmlSchemaChoice)xmlSchemaSequenceMember;
                    seq = (Seq)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(xmlSchemaChoice.getItems()).asScala()).map((Function1 & Serializable & scala.Serializable)e -> {
                        XmlSchemaElement xme = (XmlSchemaElement)e;
                        DataType baseType = MODULE$.getStructField(xmlSchema, xme.getSchemaType()).dataType();
                        DataType dataType = xme.getMaxOccurs() > 1L ? ArrayType$.MODULE$.apply(baseType) : baseType;
                        return new StructField(xme.getName(), dataType, true, StructField$.MODULE$.apply$default$4());
                    }, Buffer$.MODULE$.canBuildFrom());
                } else if (xmlSchemaSequenceMember instanceof XmlSchemaElement) {
                    XmlSchemaElement xmlSchemaElement = (XmlSchemaElement)xmlSchemaSequenceMember;
                    QName refQName = xmlSchemaElement.getRef().getTargetQName();
                    DataType baseType = refQName != null ? MODULE$.getStructField(xmlSchema, xmlSchema.getParent().getElementByQName(refQName).getSchemaType()).dataType() : MODULE$.getStructField(xmlSchema, xmlSchemaElement.getSchemaType()).dataType();
                    DataType dataType = xmlSchemaElement.getMaxOccurs() > 1L ? ArrayType$.MODULE$.apply(baseType) : baseType;
                    boolean nullable = xmlSchemaElement.getMinOccurs() == 0L;
                    String structFieldName = (String)Option$.MODULE$.apply((Object)refQName).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.getLocalPart()).getOrElse((Function0 & Serializable & scala.Serializable)() -> xmlSchemaElement.getName());
                    seq = (Seq)new .colon.colon((Object)new StructField(structFieldName, dataType, nullable, StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$);
                } else if (xmlSchemaSequenceMember instanceof XmlSchemaAny) {
                    XmlSchemaAny xmlSchemaAny = (XmlSchemaAny)xmlSchemaSequenceMember;
                    StringType$ dataType = xmlSchemaAny.getMaxOccurs() > 1L ? ArrayType$.MODULE$.apply((DataType)StringType$.MODULE$) : StringType$.MODULE$;
                    boolean nullable = xmlSchemaAny.getMinOccurs() == 0L;
                    seq = (Seq)new .colon.colon((Object)new StructField(XmlOptions$.MODULE$.DEFAULT_WILDCARD_COL_NAME(), (DataType)dataType, nullable, StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$);
                } else {
                    throw new IllegalArgumentException(new StringBuilder(18).append("Unsupported item: ").append(xmlSchemaSequenceMember).toString());
                }
                return seq;
            }, Buffer$.MODULE$.canBuildFrom())).toSeq();
        } else if (xmlSchemaParticle == null) {
            seq = (Seq)Nil$.MODULE$;
        } else {
            throw new IllegalArgumentException(new StringBuilder(22).append("Unsupported particle: ").append(xmlSchemaParticle).toString());
        }
        return seq;
    }

    private XSDToSchema$() {
        MODULE$ = this;
    }
}

