/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.jdbc.model.telemetry.latency;

import com.databricks.internal.fasterxml.jackson.annotation.JsonProperty;
import com.databricks.internal.sdk.support.ToStringer;

public class ResultLatency {
    @JsonProperty(value="result_set_ready_latency_millis")
    private Long resultSetReadyLatencyMillis;
    @JsonProperty(value="result_set_consumption_latency_millis")
    private Long resultSetConsumptionLatencyMillis = null;
    private Long startTimeOfResultSetIterationNano;

    public Long getResultSetReadyLatencyMillis() {
        return this.resultSetReadyLatencyMillis;
    }

    public Long getResultSetConsumptionLatencyMillis() {
        return this.resultSetConsumptionLatencyMillis;
    }

    public ResultLatency setResultSetReadyLatencyMillis(Long resultSetReadyLatencyMillis) {
        this.resultSetReadyLatencyMillis = resultSetReadyLatencyMillis;
        return this;
    }

    public ResultLatency setResultSetConsumptionLatencyMillis(Long resultSetConsumptionLatencyMillis) {
        this.resultSetConsumptionLatencyMillis = resultSetConsumptionLatencyMillis;
        return this;
    }

    public void markResultSetConsumption(boolean hasNext) {
        if (this.startTimeOfResultSetIterationNano == null) {
            this.startTimeOfResultSetIterationNano = System.nanoTime();
        }
        if (!hasNext) {
            this.resultSetConsumptionLatencyMillis = (System.nanoTime() - this.startTimeOfResultSetIterationNano) / 1000000L;
        }
    }

    public String toString() {
        return new ToStringer(ResultLatency.class).add("resultSetReadyLatencyMillis", this.resultSetReadyLatencyMillis).add("resultSetConsumptionLatencyMillis", this.resultSetConsumptionLatencyMillis).toString();
    }
}

