/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.jdbc.auth;

import com.databricks.internal.sdk.core.CredentialsProvider;
import com.databricks.internal.sdk.core.DatabricksConfig;
import com.databricks.internal.sdk.core.HeaderFactory;
import com.databricks.internal.sdk.core.http.HttpClient;
import com.databricks.internal.sdk.core.oauth.AuthParameterPosition;
import com.databricks.internal.sdk.core.oauth.CachedTokenSource;
import com.databricks.internal.sdk.core.oauth.Token;
import com.databricks.internal.sdk.core.oauth.TokenEndpointClient;
import com.databricks.internal.sdk.core.oauth.TokenSource;
import com.databricks.jdbc.api.internal.IDatabricksConnectionContext;
import com.databricks.jdbc.common.util.DatabricksAuthUtil;
import com.databricks.jdbc.exception.DatabricksDriverException;
import com.databricks.jdbc.exception.DatabricksParsingException;
import com.databricks.jdbc.log.JdbcLogger;
import com.databricks.jdbc.log.JdbcLoggerFactory;
import com.databricks.jdbc.model.telemetry.enums.DatabricksDriverErrorCode;
import java.lang.invoke.CallSite;
import java.time.Duration;
import java.time.Instant;
import java.util.HashMap;

public class OAuthRefreshCredentialsProvider
implements TokenSource,
CredentialsProvider {
    private static final JdbcLogger LOGGER = JdbcLoggerFactory.getLogger(OAuthRefreshCredentialsProvider.class);
    private HttpClient hc;
    private final String tokenEndpoint;
    private final String clientId;
    private final String clientSecret;
    private final Token token;
    private CachedTokenSource cachedTokenSource;

    public OAuthRefreshCredentialsProvider(IDatabricksConnectionContext context, DatabricksConfig databricksConfig) {
        this.tokenEndpoint = DatabricksAuthUtil.getTokenEndpoint(databricksConfig, context);
        try {
            this.clientId = context.getClientId();
        }
        catch (DatabricksParsingException e) {
            String exceptionMessage = "Failed to parse client id";
            LOGGER.error(exceptionMessage);
            throw new DatabricksDriverException(exceptionMessage, (Throwable)e, DatabricksDriverErrorCode.AUTH_ERROR);
        }
        this.clientSecret = context.getClientSecret();
        this.token = new Token("", "", context.getOAuthRefreshToken(), Instant.now().minus(Duration.ofMinutes(1L)));
    }

    @Override
    public String authType() {
        return "oauth-refresh";
    }

    @Override
    public HeaderFactory configure(DatabricksConfig databricksConfig) {
        if (this.hc == null) {
            this.hc = databricksConfig.getHttpClient();
        }
        if (this.cachedTokenSource == null) {
            TokenSource refreshLogic = this::refreshToken;
            this.cachedTokenSource = new CachedTokenSource.Builder(refreshLogic).build();
        }
        return () -> {
            HashMap<String, CallSite> headers = new HashMap<String, CallSite>();
            Token token = this.getToken();
            headers.put("Authorization", (CallSite)((Object)(token.getTokenType() + " " + token.getAccessToken())));
            return headers;
        };
    }

    @Override
    public Token getToken() {
        if (this.cachedTokenSource == null) {
            throw new DatabricksDriverException("CachedTokenSource not initialized. Call configure() first.", DatabricksDriverErrorCode.AUTH_ERROR);
        }
        return this.cachedTokenSource.getToken();
    }

    private Token refreshToken() {
        LOGGER.debug("Refreshing OAuth token");
        if (this.token == null) {
            String exceptionMessage = "oauth2: token is not set";
            LOGGER.error(exceptionMessage);
            throw new DatabricksDriverException(exceptionMessage, DatabricksDriverErrorCode.AUTH_ERROR);
        }
        String refreshToken = this.token.getRefreshToken();
        if (refreshToken == null) {
            String exceptionMessage = "oauth2: token expired and refresh token is not set";
            LOGGER.error(exceptionMessage);
            throw new DatabricksDriverException(exceptionMessage, DatabricksDriverErrorCode.AUTH_ERROR);
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("grant_type", "refresh_token");
        params.put("refresh_token", refreshToken);
        HashMap<String, String> headers = new HashMap<String, String>();
        Token newToken = TokenEndpointClient.retrieveToken(this.hc, this.clientId, this.clientSecret, this.tokenEndpoint, params, headers, AuthParameterPosition.BODY);
        LOGGER.debug("Successfully refreshed OAuth token");
        return newToken;
    }
}

