/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.jts.noding;

import com.databricks.internal.jts.geom.Coordinate;
import com.databricks.internal.jts.geom.LineSegment;
import com.databricks.internal.jts.noding.BasicSegmentString;
import com.databricks.internal.jts.noding.Noder;
import com.databricks.internal.jts.noding.SegmentString;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

public class BoundarySegmentNoder
implements Noder {
    private List<SegmentString> segList;

    @Override
    public void computeNodes(Collection segStrings) {
        HashSet<Segment> segSet = new HashSet<Segment>();
        BoundarySegmentNoder.addSegments(segStrings, segSet);
        this.segList = BoundarySegmentNoder.extractSegments(segSet);
    }

    private static void addSegments(Collection<SegmentString> segStrings, HashSet<Segment> segSet) {
        for (SegmentString ss : segStrings) {
            BoundarySegmentNoder.addSegments(ss, segSet);
        }
    }

    private static void addSegments(SegmentString segString, HashSet<Segment> segSet) {
        for (int i = 0; i < segString.size() - 1; ++i) {
            Coordinate p1;
            Coordinate p0 = segString.getCoordinate(i);
            Segment seg = new Segment(p0, p1 = segString.getCoordinate(i + 1), segString, i);
            if (segSet.contains(seg)) {
                segSet.remove(seg);
                continue;
            }
            segSet.add(seg);
        }
    }

    private static List<SegmentString> extractSegments(HashSet<Segment> segSet) {
        ArrayList<SegmentString> segList = new ArrayList<SegmentString>();
        for (Segment seg : segSet) {
            SegmentString ss = seg.getSegmentString();
            int i = seg.getIndex();
            Coordinate p0 = ss.getCoordinate(i);
            Coordinate p1 = ss.getCoordinate(i + 1);
            BasicSegmentString segStr = new BasicSegmentString(new Coordinate[]{p0, p1}, ss.getData());
            segList.add(segStr);
        }
        return segList;
    }

    @Override
    public Collection getNodedSubstrings() {
        return this.segList;
    }

    static class Segment
    extends LineSegment {
        private SegmentString segStr;
        private int index;

        public Segment(Coordinate p0, Coordinate p1, SegmentString segStr, int index) {
            super(p0, p1);
            this.segStr = segStr;
            this.index = index;
            this.normalize();
        }

        public SegmentString getSegmentString() {
            return this.segStr;
        }

        public int getIndex() {
            return this.index;
        }
    }
}

