/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.bouncycastle.cms.bc;

import com.databricks.internal.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.databricks.internal.bouncycastle.cms.CMSException;
import com.databricks.internal.bouncycastle.cms.RecipientOperator;
import com.databricks.internal.bouncycastle.cms.bc.BcKEKRecipient;
import com.databricks.internal.bouncycastle.cms.bc.EnvelopedDataHelper;
import com.databricks.internal.bouncycastle.crypto.BufferedBlockCipher;
import com.databricks.internal.bouncycastle.crypto.StreamCipher;
import com.databricks.internal.bouncycastle.crypto.io.CipherInputStream;
import com.databricks.internal.bouncycastle.crypto.params.KeyParameter;
import com.databricks.internal.bouncycastle.operator.InputDecryptor;
import com.databricks.internal.bouncycastle.operator.bc.BcSymmetricKeyUnwrapper;
import java.io.InputStream;

public class BcKEKEnvelopedRecipient
extends BcKEKRecipient {
    public BcKEKEnvelopedRecipient(BcSymmetricKeyUnwrapper bcSymmetricKeyUnwrapper) {
        super(bcSymmetricKeyUnwrapper);
    }

    @Override
    public RecipientOperator getRecipientOperator(AlgorithmIdentifier algorithmIdentifier, final AlgorithmIdentifier algorithmIdentifier2, byte[] byArray) throws CMSException {
        KeyParameter keyParameter = (KeyParameter)this.extractSecretKey(algorithmIdentifier, algorithmIdentifier2, byArray);
        final Object object = EnvelopedDataHelper.createContentCipher(false, keyParameter, algorithmIdentifier2);
        return new RecipientOperator(new InputDecryptor(){

            @Override
            public AlgorithmIdentifier getAlgorithmIdentifier() {
                return algorithmIdentifier2;
            }

            @Override
            public InputStream getInputStream(InputStream inputStream) {
                if (object instanceof BufferedBlockCipher) {
                    return new CipherInputStream(inputStream, (BufferedBlockCipher)object);
                }
                return new CipherInputStream(inputStream, (StreamCipher)object);
            }
        });
    }
}

