/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.apache.thrift.partial;

import com.databricks.internal.apache.thrift.TEnum;
import com.databricks.internal.apache.thrift.partial.Validate;
import com.databricks.internal.slf4j.Logger;
import com.databricks.internal.slf4j.LoggerFactory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public class EnumCache {
    private static final Logger LOG = LoggerFactory.getLogger(EnumCache.class);
    private Map<Class<? extends TEnum>, Map<Integer, TEnum>> classMap = new HashMap<Class<? extends TEnum>, Map<Integer, TEnum>>();

    public TEnum get(Class<? extends TEnum> enumClass, int value) {
        Validate.checkNotNull(enumClass, "enumClass");
        Map<Integer, TEnum> valueMap = this.classMap.get(enumClass);
        if (valueMap == null && (valueMap = this.addClass(enumClass)) == null) {
            return null;
        }
        return valueMap.get(value);
    }

    private Map<Integer, TEnum> addClass(Class<? extends TEnum> enumClass) {
        try {
            Method valuesMethod = enumClass.getMethod("values", new Class[0]);
            TEnum[] enumValues = (TEnum[])valuesMethod.invoke(null, new Object[0]);
            HashMap<Integer, TEnum> valueMap = new HashMap<Integer, TEnum>();
            for (TEnum enumValue : enumValues) {
                valueMap.put(enumValue.getValue(), enumValue);
            }
            this.classMap.put(enumClass, valueMap);
            return valueMap;
        }
        catch (NoSuchMethodException e) {
            LOG.error("enum class does not have values() method", e);
            return null;
        }
        catch (IllegalAccessException e) {
            LOG.error("Enum.values() method should be public!", e);
            return null;
        }
        catch (InvocationTargetException e) {
            LOG.error("Enum.values() threw exception", e);
            return null;
        }
    }
}

