/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.jdbc.telemetry.latency;

import com.databricks.internal.google.common.annotations.VisibleForTesting;
import com.databricks.internal.sdk.service.sql.Format;
import com.databricks.jdbc.api.internal.IDatabricksStatementInternal;
import com.databricks.jdbc.common.util.DatabricksThreadContextHolder;
import com.databricks.jdbc.dbclient.impl.common.StatementId;
import com.databricks.jdbc.log.JdbcLogger;
import com.databricks.jdbc.log.JdbcLoggerFactory;
import com.databricks.jdbc.model.client.thrift.generated.TSparkRowSetType;
import com.databricks.jdbc.model.telemetry.StatementTelemetryDetails;
import com.databricks.jdbc.model.telemetry.enums.ExecutionResultFormat;
import com.databricks.jdbc.model.telemetry.latency.OperationType;
import com.databricks.jdbc.telemetry.TelemetryHelper;
import java.util.concurrent.ConcurrentHashMap;

public class TelemetryCollector {
    private static final JdbcLogger LOGGER = JdbcLoggerFactory.getLogger(TelemetryCollector.class);
    private static final TelemetryCollector INSTANCE = new TelemetryCollector();
    private final ConcurrentHashMap<String, StatementTelemetryDetails> statementTrackers = new ConcurrentHashMap();

    private TelemetryCollector() {
    }

    public static TelemetryCollector getInstance() {
        return INSTANCE;
    }

    public void recordChunkDownloadLatency(String statementId, long chunkIndex, long latencyMillis) {
        if (statementId == null) {
            LOGGER.trace("Statement ID is null, skipping chunk latency recording");
            return;
        }
        this.statementTrackers.computeIfAbsent(statementId, k -> new StatementTelemetryDetails(statementId)).recordChunkDownloadLatency(chunkIndex, latencyMillis);
    }

    public void recordTotalChunks(StatementId statementId, long totalChunks) {
        String statementIdString = TelemetryHelper.getStatementIdString(statementId);
        if (statementIdString == null) {
            LOGGER.trace("Statement ID is null, skipping total chunk telemetry recording");
            return;
        }
        this.statementTrackers.computeIfAbsent(statementIdString, k -> new StatementTelemetryDetails(statementIdString)).getChunkDetails().setTotalChunksPresent(totalChunks);
    }

    public void recordOperationLatency(long latencyMillis, String methodName) {
        String statementId = DatabricksThreadContextHolder.getStatementId();
        OperationType operationType = TelemetryHelper.mapMethodToOperationType(methodName);
        if (this.isTelemetryCollected(statementId) && this.isCloseOperation(operationType)) {
            this.statementTrackers.get(statementId).recordOperationLatency(latencyMillis, operationType);
            this.exportTelemetryDetailsAndClear(statementId);
            return;
        }
        TelemetryHelper.exportTelemetryLog(new StatementTelemetryDetails(statementId).recordOperationLatency(latencyMillis, operationType));
    }

    public void recordResultSetIteration(String statementId, Long totalChunks, boolean hasNext) {
        if (statementId == null) {
            return;
        }
        this.statementTrackers.computeIfAbsent(statementId, k -> new StatementTelemetryDetails(statementId)).recordResultSetIteration(totalChunks, hasNext);
    }

    public StatementTelemetryDetails getOrCreateTelemetryDetails(String statementId) {
        if (statementId == null) {
            return null;
        }
        return this.statementTrackers.computeIfAbsent(statementId, k -> new StatementTelemetryDetails(statementId));
    }

    public void exportAllPendingTelemetryDetails() {
        LOGGER.trace(" {} pending telemetry details for telemetry export", this.statementTrackers.size());
        this.statementTrackers.forEach((statementId, statementTelemetryDetails) -> TelemetryHelper.exportTelemetryLog(statementTelemetryDetails));
        this.statementTrackers.clear();
    }

    public void recordGetOperationStatus(String statementId, long latencyMillis) {
        this.statementTrackers.computeIfAbsent(statementId, k -> new StatementTelemetryDetails(statementId)).recordGetOperationStatusLatency(latencyMillis);
    }

    @VisibleForTesting
    void recordChunkIteration(String statementId, Long totalChunks) {
        if (statementId == null) {
            return;
        }
        this.statementTrackers.computeIfAbsent(statementId, k -> new StatementTelemetryDetails(statementId)).recordChunkIteration(totalChunks);
    }

    @VisibleForTesting
    boolean isCloseOperation(OperationType operationType) {
        return operationType == OperationType.CLOSE_STATEMENT || operationType == OperationType.CANCEL_STATEMENT || operationType == OperationType.DELETE_SESSION;
    }

    boolean isTelemetryCollected(String statementId) {
        return statementId != null && this.statementTrackers.containsKey(statementId);
    }

    private void exportTelemetryDetailsAndClear(String statementId) {
        StatementTelemetryDetails statementTelemetryDetails = this.statementTrackers.remove(statementId);
        TelemetryHelper.exportTelemetryLog(statementTelemetryDetails);
    }

    public void setResultFormat(IDatabricksStatementInternal statement, TSparkRowSetType executionResultFormat) {
        if (statement == null || statement.getStatementId() == null) {
            return;
        }
        this.setExecutionFormat(statement.getStatementId().toSQLExecStatementId(), this.getResultFormat(executionResultFormat));
    }

    public void setResultFormat(StatementId statementId, Format executionResultFormat) {
        if (statementId == null) {
            return;
        }
        this.setExecutionFormat(statementId.toSQLExecStatementId(), this.getResultFormat(executionResultFormat));
    }

    private void setExecutionFormat(String statementId, ExecutionResultFormat executionResultFormat) {
        this.statementTrackers.computeIfAbsent(statementId, k -> new StatementTelemetryDetails(statementId)).setExecutionResultFormat(executionResultFormat);
    }

    private ExecutionResultFormat getResultFormat(TSparkRowSetType resultFormat) {
        switch (resultFormat) {
            case ARROW_BASED_SET: {
                return ExecutionResultFormat.INLINE_ARROW;
            }
            case URL_BASED_SET: {
                return ExecutionResultFormat.EXTERNAL_LINKS;
            }
            case COLUMN_BASED_SET: {
                return ExecutionResultFormat.COLUMNAR_INLINE;
            }
        }
        return ExecutionResultFormat.FORMAT_UNSPECIFIED;
    }

    private ExecutionResultFormat getResultFormat(Format resultFormat) {
        switch (resultFormat) {
            case ARROW_STREAM: {
                return ExecutionResultFormat.EXTERNAL_LINKS;
            }
            case JSON_ARRAY: {
                return ExecutionResultFormat.INLINE_JSON;
            }
        }
        return ExecutionResultFormat.FORMAT_UNSPECIFIED;
    }
}

