/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.jdbc.model.telemetry;

import com.databricks.jdbc.model.telemetry.enums.ExecutionResultFormat;
import com.databricks.jdbc.model.telemetry.latency.ChunkDetails;
import com.databricks.jdbc.model.telemetry.latency.OperationDetail;
import com.databricks.jdbc.model.telemetry.latency.OperationType;
import com.databricks.jdbc.model.telemetry.latency.ResultLatency;

public class StatementTelemetryDetails {
    private boolean isInternalCall = false;
    private final ChunkDetails chunkDetails;
    private final ResultLatency resultLatency = new ResultLatency().setResultSetReadyLatencyMillis(null).setResultSetConsumptionLatencyMillis(null);
    private final OperationDetail operationDetail;
    private Long operationLatencyMillis = null;
    private final String statementId;
    ExecutionResultFormat executionResultFormat;

    public StatementTelemetryDetails(String statementId) {
        this.chunkDetails = new ChunkDetails();
        this.operationDetail = new OperationDetail(this.isInternalCall);
        this.statementId = statementId;
    }

    public String getStatementId() {
        return this.statementId;
    }

    public boolean isInternalCall() {
        return this.isInternalCall;
    }

    public ResultLatency getResultLatency() {
        return this.resultLatency;
    }

    public OperationDetail getOperationDetail() {
        return this.operationDetail;
    }

    public ChunkDetails getChunkDetails() {
        return this.chunkDetails;
    }

    public StatementTelemetryDetails setOperationLatencyMillis(Long operationLatencyMillis) {
        this.operationLatencyMillis = operationLatencyMillis;
        return this;
    }

    public StatementTelemetryDetails setInternalCall(boolean isInternalCall) {
        this.isInternalCall = isInternalCall;
        return this;
    }

    public void recordChunkDownloadLatency(long chunkIndex, long latencyMillis) {
        Long currentSum;
        Long currentSlowest;
        if (chunkIndex == 0L) {
            this.chunkDetails.setInitialChunkLatencyMillis(latencyMillis);
        }
        if ((currentSlowest = this.chunkDetails.getSlowestChunkLatencyMillis()) == null || latencyMillis > currentSlowest) {
            this.chunkDetails.setSlowestChunkLatencyMillis(latencyMillis);
        }
        if ((currentSum = this.chunkDetails.getSumChunksDownloadTimeMillis()) == null) {
            currentSum = 0L;
        }
        this.chunkDetails.setSumChunksDownloadTimeMillis(currentSum + latencyMillis);
    }

    public void recordChunkIteration(Long totalChunks) {
        Long currentIterated = this.chunkDetails.getTotalChunksIterated();
        if (currentIterated == null) {
            currentIterated = 0L;
            this.chunkDetails.setTotalChunksPresent(totalChunks);
        }
        this.chunkDetails.setTotalChunksIterated(currentIterated + 1L);
    }

    public void recordResultSetIteration(Long totalChunks, boolean hasNext) {
        this.chunkDetails.setTotalChunksPresent(totalChunks);
        this.resultLatency.markResultSetConsumption(hasNext);
    }

    public StatementTelemetryDetails recordOperationLatency(long latencyMillis, OperationType operationType) {
        this.operationDetail.setOperationType(operationType);
        this.operationLatencyMillis = latencyMillis;
        return this;
    }

    public void recordGetOperationStatusLatency(long latencyMillis) {
        this.operationDetail.addOperationStatusLatencyMillis(latencyMillis);
    }

    public Long getOperationLatencyMillis() {
        return this.operationLatencyMillis;
    }

    public StatementTelemetryDetails setExecutionResultFormat(ExecutionResultFormat executionResultFormat) {
        this.executionResultFormat = executionResultFormat;
        return this;
    }

    public ExecutionResultFormat getExecutionResultFormat() {
        return this.executionResultFormat;
    }
}

