/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.jdbc.log;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public class Slf4jFormatter
extends Formatter {
    private static final String DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private static final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    @Override
    public String format(LogRecord record) {
        String timestamp = dateFormat.format(new Date(record.getMillis()));
        String level = record.getLevel().getLocalizedName();
        String className = record.getSourceClassName();
        String methodName = record.getSourceMethodName();
        String message = this.formatMessage(record);
        return String.format("%s %s %s#%s - %s%n", timestamp, level, className, methodName, message);
    }

    static {
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
    }
}

