/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.jdbc.log;

import com.databricks.jdbc.log.JdbcLogger;
import com.databricks.jdbc.log.JulLogger;
import com.databricks.jdbc.log.Slf4jLogger;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;

public class JdbcLoggerFactory {
    public static final String LOGGER_IMPL_PROPERTY = "com.databricks.jdbc.loggerImpl";
    private static volatile LoggerImpl loggerImpl;
    private static final Map<String, LoggerImpl> LOGGER_IMPL_MAP;

    private JdbcLoggerFactory() {
        throw new AssertionError((Object)"JdbcLoggerFactory is not instantiable.");
    }

    public static JdbcLogger getLogger(Class<?> clazz) {
        JdbcLoggerFactory.resolveLoggerImpl();
        switch (loggerImpl.ordinal()) {
            case 1: {
                return new JulLogger(clazz.getName());
            }
        }
        return new Slf4jLogger(clazz);
    }

    public static JdbcLogger getLogger(String name) {
        JdbcLoggerFactory.resolveLoggerImpl();
        switch (loggerImpl.ordinal()) {
            case 1: {
                return new JulLogger(name);
            }
        }
        return new Slf4jLogger(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void resolveLoggerImpl() {
        if (loggerImpl != null) return;
        Class<JdbcLoggerFactory> clazz = JdbcLoggerFactory.class;
        synchronized (JdbcLoggerFactory.class) {
            if (loggerImpl != null) return;
            String logger = System.getProperty(LOGGER_IMPL_PROPERTY);
            loggerImpl = LoggerImpl.fromString(logger).orElse(LoggerImpl.JDKLOGGER);
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    static {
        LOGGER_IMPL_MAP = new ConcurrentHashMap<String, LoggerImpl>();
        for (LoggerImpl impl : LoggerImpl.values()) {
            LOGGER_IMPL_MAP.put(impl.getLoggerImplClassName().toLowerCase(), impl);
        }
    }

    static enum LoggerImpl {
        SLF4JLOGGER("SLF4JLOGGER"),
        JDKLOGGER("JDKLOGGER");

        private final String loggerImplClassName;

        private LoggerImpl(String loggerClass) {
            this.loggerImplClassName = loggerClass;
        }

        public String getLoggerImplClassName() {
            return this.loggerImplClassName;
        }

        public static Optional<LoggerImpl> fromString(String loggerImplClassName) {
            return Optional.ofNullable(loggerImplClassName).map(String::toLowerCase).map(LOGGER_IMPL_MAP::get);
        }
    }
}

