/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.jdbc.dbclient.impl.sqlexec;

import com.databricks.jdbc.api.impl.DatabricksResultSet;
import com.databricks.jdbc.api.internal.IDatabricksConnectionContext;
import com.databricks.jdbc.api.internal.IDatabricksSession;
import com.databricks.jdbc.dbclient.IDatabricksMetadataClient;
import com.databricks.jdbc.dbclient.impl.common.MetadataResultSetBuilder;
import com.databricks.jdbc.dbclient.impl.sqlexec.ResultConstants;
import com.databricks.jdbc.log.JdbcLogger;
import com.databricks.jdbc.log.JdbcLoggerFactory;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class DatabricksEmptyMetadataClient
implements IDatabricksMetadataClient {
    private static final JdbcLogger LOGGER = JdbcLoggerFactory.getLogger(DatabricksEmptyMetadataClient.class);
    private final MetadataResultSetBuilder metadataResultSetBuilder;

    public DatabricksEmptyMetadataClient(IDatabricksConnectionContext ctx) {
        this.metadataResultSetBuilder = new MetadataResultSetBuilder(ctx);
    }

    @Override
    public DatabricksResultSet listTypeInfo(IDatabricksSession session) throws SQLException {
        LOGGER.debug("public ResultSet getTypeInfo()");
        return ResultConstants.TYPE_INFO_RESULT;
    }

    @Override
    public DatabricksResultSet listCatalogs(IDatabricksSession session) throws SQLException {
        LOGGER.warn("Empty metadata implementation for listCatalogs.");
        return this.metadataResultSetBuilder.getCatalogsResult((List<List<Object>>)null);
    }

    @Override
    public DatabricksResultSet listSchemas(IDatabricksSession session, String catalog, String schemaNamePattern) throws SQLException {
        LOGGER.warn("Empty metadata implementation for listSchemas.");
        return this.metadataResultSetBuilder.getSchemasResult(null);
    }

    @Override
    public DatabricksResultSet listTables(IDatabricksSession session, String catalog, String schemaNamePattern, String tableNamePattern, String[] tableTypes) throws SQLException {
        LOGGER.warn("Empty metadata implementation for listTables.");
        return this.metadataResultSetBuilder.getTablesResult(catalog, tableTypes, new ArrayList<List<Object>>());
    }

    @Override
    public DatabricksResultSet listTableTypes(IDatabricksSession session) {
        LOGGER.debug("public ResultSet listTableTypes()");
        return this.metadataResultSetBuilder.getTableTypesResult();
    }

    @Override
    public DatabricksResultSet listColumns(IDatabricksSession session, String catalog, String schemaNamePattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        LOGGER.warn("Empty metadata implementation for listColumns.");
        return this.metadataResultSetBuilder.getColumnsResult((List<List<Object>>)null);
    }

    @Override
    public DatabricksResultSet listFunctions(IDatabricksSession session, String catalog, String schemaNamePattern, String functionNamePattern) throws SQLException {
        LOGGER.warn("Empty metadata implementation for listFunctions.");
        return this.metadataResultSetBuilder.getFunctionsResult("", null);
    }

    @Override
    public DatabricksResultSet listPrimaryKeys(IDatabricksSession session, String catalog, String schema, String table) throws SQLException {
        LOGGER.warn("Empty metadata implementation for listPrimaryKeys.");
        return this.metadataResultSetBuilder.getPrimaryKeysResult((List<List<Object>>)null);
    }

    @Override
    public DatabricksResultSet listImportedKeys(IDatabricksSession session, String catalog, String schema, String table) throws SQLException {
        return this.metadataResultSetBuilder.getImportedKeys(null);
    }

    @Override
    public DatabricksResultSet listExportedKeys(IDatabricksSession session, String catalog, String schema, String table) throws SQLException {
        return this.metadataResultSetBuilder.getExportedKeys(null);
    }

    @Override
    public DatabricksResultSet listCrossReferences(IDatabricksSession session, String parentCatalog, String parentSchema, String parentTable, String foreignCatalog, String foreignSchema, String foreignTable) throws SQLException {
        return this.metadataResultSetBuilder.getCrossRefsResult(null);
    }
}

