/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.jdbc.common.util;

import com.databricks.internal.sdk.core.utils.Cloud;
import com.databricks.jdbc.api.impl.DatabricksConnectionContext;
import com.databricks.jdbc.api.impl.DatabricksConnectionContextFactory;
import com.databricks.jdbc.common.AuthFlow;
import com.databricks.jdbc.common.AuthMech;
import com.databricks.jdbc.common.DatabricksJdbcUrlParams;
import com.databricks.jdbc.common.LogLevel;
import com.databricks.jdbc.exception.DatabricksParsingException;
import java.sql.DriverPropertyInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Properties;

public class DatabricksDriverPropertyUtil {
    private static final List<DatabricksJdbcUrlParams> OPTIONAL_PROPERTIES = Arrays.asList(DatabricksJdbcUrlParams.SSL, DatabricksJdbcUrlParams.LOG_LEVEL, DatabricksJdbcUrlParams.USE_PROXY, DatabricksJdbcUrlParams.USE_THRIFT_CLIENT, DatabricksJdbcUrlParams.ENABLE_ARROW, DatabricksJdbcUrlParams.DIRECT_RESULT, DatabricksJdbcUrlParams.COMPRESSION_FLAG, DatabricksJdbcUrlParams.LZ4_COMPRESSION_FLAG, DatabricksJdbcUrlParams.USER_AGENT_ENTRY, DatabricksJdbcUrlParams.ENABLE_SQL_EXEC_HYBRID_RESULTS, DatabricksJdbcUrlParams.ENABLE_SQL_EXEC_DIRECT_RESULTS, DatabricksJdbcUrlParams.ENABLE_COMPLEX_DATATYPE_SUPPORT, DatabricksJdbcUrlParams.ROWS_FETCHED_PER_BLOCK, DatabricksJdbcUrlParams.DEFAULT_STRING_COLUMN_LENGTH, DatabricksJdbcUrlParams.SOCKET_TIMEOUT, DatabricksJdbcUrlParams.ENABLE_TOKEN_CACHE, DatabricksJdbcUrlParams.ENABLE_SQL_VALIDATION_FOR_IS_VALID);

    public static List<DriverPropertyInfo> getMissingProperties(String url, Properties info) throws DatabricksParsingException {
        DatabricksConnectionContext connectionContext;
        if (url == null) {
            url = "";
        }
        if ((connectionContext = (DatabricksConnectionContext)DatabricksConnectionContextFactory.createWithoutError(url, info)) == null) {
            DriverPropertyInfo hostProperty = new DriverPropertyInfo("host", null);
            hostProperty.required = true;
            hostProperty.description = "JDBC URL must be in the form: <protocol>://<host or domain>:<port>/<path>";
            return Collections.singletonList(hostProperty);
        }
        if (!connectionContext.isPropertyPresent(DatabricksJdbcUrlParams.HTTP_PATH)) {
            return Collections.singletonList(DatabricksJdbcUrlParams.getUrlParamInfo(DatabricksJdbcUrlParams.HTTP_PATH, true));
        }
        if (!connectionContext.isPropertyPresent(DatabricksJdbcUrlParams.AUTH_MECH)) {
            return Collections.singletonList(DatabricksJdbcUrlParams.getUrlParamInfo(DatabricksJdbcUrlParams.AUTH_MECH, true));
        }
        return DatabricksDriverPropertyUtil.buildMissingPropertiesList(connectionContext);
    }

    public static List<DriverPropertyInfo> buildMissingPropertiesList(DatabricksConnectionContext connectionContext) throws DatabricksParsingException {
        AuthMech authMech;
        ArrayList<DriverPropertyInfo> missingPropertyInfos = new ArrayList<DriverPropertyInfo>();
        for (DatabricksJdbcUrlParams param : DatabricksJdbcUrlParams.values()) {
            if (!param.isRequired()) continue;
            DatabricksDriverPropertyUtil.addMissingProperty(missingPropertyInfos, connectionContext, param, true);
        }
        for (DatabricksJdbcUrlParams param : OPTIONAL_PROPERTIES) {
            DatabricksDriverPropertyUtil.addMissingProperty(missingPropertyInfos, connectionContext, param, false);
        }
        if (connectionContext.isPropertyPresent(DatabricksJdbcUrlParams.LOG_LEVEL) && connectionContext.getLogLevel() != LogLevel.OFF) {
            DatabricksDriverPropertyUtil.addMissingProperty(missingPropertyInfos, connectionContext, DatabricksJdbcUrlParams.LOG_PATH, false);
            DatabricksDriverPropertyUtil.addMissingProperty(missingPropertyInfos, connectionContext, DatabricksJdbcUrlParams.LOG_FILE_SIZE, false);
            DatabricksDriverPropertyUtil.addMissingProperty(missingPropertyInfos, connectionContext, DatabricksJdbcUrlParams.LOG_FILE_COUNT, false);
        }
        if (connectionContext.isPropertyPresent(DatabricksJdbcUrlParams.SSL)) {
            DatabricksDriverPropertyUtil.addMissingProperty(missingPropertyInfos, connectionContext, DatabricksJdbcUrlParams.SSL_TRUST_STORE, false);
            if (connectionContext.getSSLTrustStore() != null && !connectionContext.getSSLTrustStore().isEmpty()) {
                DatabricksDriverPropertyUtil.addMissingProperty(missingPropertyInfos, connectionContext, DatabricksJdbcUrlParams.SSL_TRUST_STORE_TYPE, false);
            }
            DatabricksDriverPropertyUtil.addMissingProperty(missingPropertyInfos, connectionContext, DatabricksJdbcUrlParams.USE_SYSTEM_TRUST_STORE, false);
            DatabricksDriverPropertyUtil.addMissingProperty(missingPropertyInfos, connectionContext, DatabricksJdbcUrlParams.ALLOW_SELF_SIGNED_CERTS, false);
            DatabricksDriverPropertyUtil.addMissingProperty(missingPropertyInfos, connectionContext, DatabricksJdbcUrlParams.CHECK_CERTIFICATE_REVOCATION, false);
            if (connectionContext.checkCertificateRevocation()) {
                DatabricksDriverPropertyUtil.addMissingProperty(missingPropertyInfos, connectionContext, DatabricksJdbcUrlParams.ACCEPT_UNDETERMINED_CERTIFICATE_REVOCATION, false);
            } else if (!connectionContext.isPropertyPresent(DatabricksJdbcUrlParams.CHECK_CERTIFICATE_REVOCATION)) {
                DatabricksDriverPropertyUtil.addMissingProperty(missingPropertyInfos, connectionContext, DatabricksJdbcUrlParams.ACCEPT_UNDETERMINED_CERTIFICATE_REVOCATION, false);
            }
        }
        if ((authMech = connectionContext.getAuthMech()) == AuthMech.PAT) {
            DatabricksDriverPropertyUtil.addMissingProperty(missingPropertyInfos, connectionContext, DatabricksJdbcUrlParams.PWD, true);
        } else if (authMech == AuthMech.OAUTH) {
            AuthFlow authFlow = connectionContext.getAuthFlow();
            DatabricksDriverPropertyUtil.addMissingProperty(missingPropertyInfos, connectionContext, DatabricksJdbcUrlParams.IDENTITY_FEDERATION_CLIENT_ID, false);
            if (connectionContext.isPropertyPresent(DatabricksJdbcUrlParams.AUTH_FLOW)) {
                switch (authFlow) {
                    case TOKEN_PASSTHROUGH: {
                        if (connectionContext.getOAuthRefreshToken() != null) {
                            DatabricksDriverPropertyUtil.addMissingProperty(missingPropertyInfos, connectionContext, DatabricksJdbcUrlParams.CLIENT_ID, true);
                            DatabricksDriverPropertyUtil.addMissingProperty(missingPropertyInfos, connectionContext, DatabricksJdbcUrlParams.CLIENT_SECRET, true);
                            DatabricksDriverPropertyUtil.handleTokenEndpointAndDiscoveryMode(missingPropertyInfos, connectionContext);
                            break;
                        }
                        DatabricksDriverPropertyUtil.addMissingProperty(missingPropertyInfos, connectionContext, DatabricksJdbcUrlParams.OAUTH_REFRESH_TOKEN, false);
                        DatabricksDriverPropertyUtil.addMissingProperty(missingPropertyInfos, connectionContext, DatabricksJdbcUrlParams.AUTH_ACCESS_TOKEN, true);
                        break;
                    }
                    case CLIENT_CREDENTIALS: {
                        if (connectionContext.getCloud() == Cloud.GCP) {
                            DatabricksDriverPropertyUtil.addMissingProperty(missingPropertyInfos, connectionContext, DatabricksJdbcUrlParams.GOOGLE_SERVICE_ACCOUNT, true);
                            DatabricksDriverPropertyUtil.addMissingProperty(missingPropertyInfos, connectionContext, DatabricksJdbcUrlParams.GOOGLE_CREDENTIALS_FILE, true);
                        } else if (connectionContext.getCloud() == Cloud.AZURE) {
                            DatabricksDriverPropertyUtil.addMissingProperty(missingPropertyInfos, connectionContext, DatabricksJdbcUrlParams.AZURE_TENANT_ID, false);
                        }
                        DatabricksDriverPropertyUtil.addMissingProperty(missingPropertyInfos, connectionContext, DatabricksJdbcUrlParams.CLIENT_SECRET, true);
                        DatabricksDriverPropertyUtil.addMissingProperty(missingPropertyInfos, connectionContext, DatabricksJdbcUrlParams.CLIENT_ID, true);
                        if (connectionContext.isPropertyPresent(DatabricksJdbcUrlParams.USE_JWT_ASSERTION)) {
                            if (!connectionContext.useJWTAssertion()) break;
                            DatabricksDriverPropertyUtil.addMissingProperty(missingPropertyInfos, connectionContext, DatabricksJdbcUrlParams.JWT_KEY_FILE, true);
                            DatabricksDriverPropertyUtil.addMissingProperty(missingPropertyInfos, connectionContext, DatabricksJdbcUrlParams.JWT_ALGORITHM, true);
                            DatabricksDriverPropertyUtil.addMissingProperty(missingPropertyInfos, connectionContext, DatabricksJdbcUrlParams.JWT_PASS_PHRASE, true);
                            DatabricksDriverPropertyUtil.addMissingProperty(missingPropertyInfos, connectionContext, DatabricksJdbcUrlParams.JWT_KID, true);
                            DatabricksDriverPropertyUtil.handleTokenEndpointAndDiscoveryMode(missingPropertyInfos, connectionContext);
                            break;
                        }
                        DatabricksDriverPropertyUtil.addMissingProperty(missingPropertyInfos, connectionContext, DatabricksJdbcUrlParams.USE_JWT_ASSERTION, false);
                        break;
                    }
                    case BROWSER_BASED_AUTHENTICATION: {
                        DatabricksDriverPropertyUtil.addMissingProperty(missingPropertyInfos, connectionContext, DatabricksJdbcUrlParams.CLIENT_ID, false);
                        DatabricksDriverPropertyUtil.addMissingProperty(missingPropertyInfos, connectionContext, DatabricksJdbcUrlParams.CLIENT_SECRET, false);
                        DatabricksDriverPropertyUtil.addMissingProperty(missingPropertyInfos, connectionContext, DatabricksJdbcUrlParams.AUTH_SCOPE, false);
                        DatabricksDriverPropertyUtil.addMissingProperty(missingPropertyInfos, connectionContext, DatabricksJdbcUrlParams.OAUTH_REDIRECT_URL_PORT, false);
                        DatabricksDriverPropertyUtil.addMissingProperty(missingPropertyInfos, connectionContext, DatabricksJdbcUrlParams.ENABLE_TOKEN_CACHE, false);
                        if (!connectionContext.isPropertyPresent(DatabricksJdbcUrlParams.ENABLE_TOKEN_CACHE) || !connectionContext.isTokenCacheEnabled()) break;
                        DatabricksDriverPropertyUtil.addMissingProperty(missingPropertyInfos, connectionContext, DatabricksJdbcUrlParams.TOKEN_CACHE_PASS_PHRASE, true);
                        break;
                    }
                    case AZURE_MANAGED_IDENTITIES: {
                        DatabricksDriverPropertyUtil.addMissingProperty(missingPropertyInfos, connectionContext, DatabricksJdbcUrlParams.AZURE_WORKSPACE_RESOURCE_ID, true);
                    }
                }
            } else {
                missingPropertyInfos.add(DatabricksJdbcUrlParams.getUrlParamInfo(DatabricksJdbcUrlParams.AUTH_FLOW, true));
            }
        }
        if (connectionContext.isPropertyPresent(DatabricksJdbcUrlParams.USE_PROXY) && connectionContext.getUseProxy().booleanValue()) {
            DatabricksDriverPropertyUtil.addMissingProperty(missingPropertyInfos, connectionContext, DatabricksJdbcUrlParams.PROXY_HOST, true);
            DatabricksDriverPropertyUtil.addMissingProperty(missingPropertyInfos, connectionContext, DatabricksJdbcUrlParams.PROXY_PORT, true);
            DatabricksDriverPropertyUtil.addMissingProperty(missingPropertyInfos, connectionContext, DatabricksJdbcUrlParams.PROXY_USER, false);
            DatabricksDriverPropertyUtil.addMissingProperty(missingPropertyInfos, connectionContext, DatabricksJdbcUrlParams.PROXY_PWD, false);
        }
        return missingPropertyInfos;
    }

    private static void handleTokenEndpointAndDiscoveryMode(List<DriverPropertyInfo> missingPropertyInfos, DatabricksConnectionContext connectionContext) {
        if (connectionContext.getTokenEndpoint() == null && connectionContext.isOAuthDiscoveryModeEnabled() && connectionContext.getOAuthDiscoveryURL() == null) {
            DatabricksDriverPropertyUtil.addMissingProperty(missingPropertyInfos, connectionContext, DatabricksJdbcUrlParams.DISCOVERY_URL, true);
        } else {
            DatabricksDriverPropertyUtil.addMissingProperty(missingPropertyInfos, connectionContext, DatabricksJdbcUrlParams.TOKEN_ENDPOINT, false);
            DatabricksDriverPropertyUtil.addMissingProperty(missingPropertyInfos, connectionContext, DatabricksJdbcUrlParams.DISCOVERY_MODE, false);
            DatabricksDriverPropertyUtil.addMissingProperty(missingPropertyInfos, connectionContext, DatabricksJdbcUrlParams.DISCOVERY_URL, false);
        }
    }

    private static void addMissingProperty(List<DriverPropertyInfo> missingPropertyInfos, DatabricksConnectionContext connectionContext, DatabricksJdbcUrlParams param, boolean required) {
        if (!connectionContext.isPropertyPresent(param)) {
            missingPropertyInfos.add(DatabricksJdbcUrlParams.getUrlParamInfo(param, required));
        }
    }
}

