/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.jdbc.api.impl.volume;

import com.databricks.internal.apache.http.entity.InputStreamEntity;
import com.databricks.jdbc.api.IDatabricksVolumeClient;
import com.databricks.jdbc.api.internal.IDatabricksResultSetInternal;
import com.databricks.jdbc.api.internal.IDatabricksStatementInternal;
import com.databricks.jdbc.common.util.StringUtil;
import com.databricks.jdbc.exception.DatabricksSQLFeatureNotSupportedException;
import com.databricks.jdbc.log.JdbcLogger;
import com.databricks.jdbc.log.JdbcLoggerFactory;
import com.databricks.jdbc.model.client.filesystem.VolumePutResult;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

public class DatabricksUCVolumeClient
implements IDatabricksVolumeClient {
    private static final JdbcLogger LOGGER = JdbcLoggerFactory.getLogger(DatabricksUCVolumeClient.class);
    private final Connection connection;
    private static final String UC_VOLUME_COLUMN_NAME = "name";
    private static final String UC_VOLUME_COLUMN_VOLUME_NAME = "volume_name";

    public DatabricksUCVolumeClient(Connection connection) {
        this.connection = connection;
    }

    private static String getVolumePath(String catalog, String schema, String volume) {
        return StringUtil.escapeStringLiteral(String.format("/Volumes/%s/%s/%s/", catalog, schema, volume));
    }

    public static String getObjectFullPath(String catalog, String schema, String volume, String objectPath) {
        return DatabricksUCVolumeClient.getVolumePath(catalog, schema, volume) + StringUtil.escapeStringLiteral(objectPath);
    }

    private static String createListQuery(String catalog, String schema, String volume) {
        return String.format("LIST '%s'", DatabricksUCVolumeClient.getVolumePath(catalog, schema, volume));
    }

    private static String createListQuery(String catalog, String schema, String volume, String folder) {
        return folder.isEmpty() ? DatabricksUCVolumeClient.createListQuery(catalog, schema, volume) : DatabricksUCVolumeClient.createListQuery(catalog, schema, volume + "/" + folder);
    }

    private static String createShowVolumesQuery(String catalog, String schema) {
        return String.format("SHOW VOLUMES IN %s.%s", catalog, schema);
    }

    private static String createGetObjectQuery(String catalog, String schema, String volume, String objectPath, String localPath) {
        return String.format("GET '%s' TO '%s'", DatabricksUCVolumeClient.getObjectFullPath(catalog, schema, volume, objectPath), StringUtil.escapeStringLiteral(localPath));
    }

    private static String createGetObjectQueryForInputStream(String catalog, String schema, String volume, String objectPath) {
        return String.format("GET '%s' TO '__input_stream__'", DatabricksUCVolumeClient.getObjectFullPath(catalog, schema, volume, objectPath));
    }

    private static String createPutObjectQuery(String catalog, String schema, String volume, String objectPath, String localPath, boolean toOverwrite) {
        return String.format("PUT '%s' INTO '%s'%s", StringUtil.escapeStringLiteral(localPath), DatabricksUCVolumeClient.getObjectFullPath(catalog, schema, volume, objectPath), toOverwrite ? " OVERWRITE" : "");
    }

    private static String createPutObjectQueryForInputStream(String catalog, String schema, String volume, String objectPath, boolean toOverwrite) {
        return String.format("PUT '__input_stream__' INTO '%s'%s", DatabricksUCVolumeClient.getObjectFullPath(catalog, schema, volume, objectPath), toOverwrite ? " OVERWRITE" : "");
    }

    private static String createDeleteObjectQuery(String catalog, String schema, String volume, String objectPath) {
        return String.format("REMOVE '%s'", DatabricksUCVolumeClient.getObjectFullPath(catalog, schema, volume, objectPath));
    }

    public boolean prefixExists(String catalog, String schema, String volume, String prefix) throws SQLException {
        return this.prefixExists(catalog, schema, volume, prefix, true);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean prefixExists(String catalog, String schema, String volume, String prefix, boolean caseSensitive) throws SQLException {
        if (prefix.isEmpty()) {
            return false;
        }
        LOGGER.debug(String.format("Entering prefixExists method with parameters: catalog={%s}, schema={%s}, volume={%s}, prefix={%s}, caseSensitive={%s}", catalog, schema, volume, prefix, caseSensitive));
        String folder = StringUtil.getFolderNameFromPath(prefix);
        String basename = StringUtil.getBaseNameFromPath(prefix);
        String listFilesSQLQuery = DatabricksUCVolumeClient.createListQuery(catalog, schema, volume, folder);
        try (Statement statement = this.connection.createStatement();){
            boolean bl;
            block16: {
                ResultSet resultSet = statement.executeQuery(listFilesSQLQuery);
                try {
                    LOGGER.debug("SQL query executed successfully");
                    boolean exists = false;
                    while (resultSet.next()) {
                        String fileName = resultSet.getString(UC_VOLUME_COLUMN_NAME);
                        if (!fileName.regionMatches(!caseSensitive, 0, basename, 0, basename.length())) continue;
                        exists = true;
                        break;
                    }
                    bl = exists;
                    if (resultSet == null) break block16;
                }
                catch (Throwable throwable) {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                resultSet.close();
            }
            return bl;
        }
        catch (SQLException e) {
            LOGGER.error("SQL query execution failed " + String.valueOf(e));
            throw e;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean objectExists(String catalog, String schema, String volume, String objectPath, boolean caseSensitive) throws SQLException {
        if (objectPath.isEmpty()) {
            return false;
        }
        LOGGER.info(String.format("Entering objectExists method with parameters: catalog={%s}, schema={%s}, volume={%s}, objectPath={%s}, caseSensitive={%s}", catalog, schema, volume, objectPath, caseSensitive));
        String folder = StringUtil.getFolderNameFromPath(objectPath);
        String basename = StringUtil.getBaseNameFromPath(objectPath);
        String listFilesSQLQuery = DatabricksUCVolumeClient.createListQuery(catalog, schema, volume, folder);
        try (Statement statement = this.connection.createStatement();){
            boolean bl;
            block16: {
                ResultSet resultSet = statement.executeQuery(listFilesSQLQuery);
                try {
                    LOGGER.info("SQL query executed successfully");
                    boolean exists = false;
                    while (resultSet.next()) {
                        String fileName = resultSet.getString(UC_VOLUME_COLUMN_NAME);
                        if (!fileName.regionMatches(!caseSensitive, 0, basename, 0, basename.length())) continue;
                        exists = true;
                        break;
                    }
                    bl = exists;
                    if (resultSet == null) break block16;
                }
                catch (Throwable throwable) {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                resultSet.close();
            }
            return bl;
        }
        catch (SQLException e) {
            LOGGER.error("SQL query execution failed " + String.valueOf(e));
            throw e;
        }
    }

    public boolean objectExists(String catalog, String schema, String volume, String objectPath) throws SQLException {
        return this.objectExists(catalog, schema, volume, objectPath, true);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean volumeExists(String catalog, String schema, String volumeName, boolean caseSensitive) throws SQLException {
        LOGGER.info(String.format("Entering volumeExists method with parameters: catalog={%s}, schema={%s}, volumeName={%s}, caseSensitive={%s}", catalog, schema, volumeName, caseSensitive));
        if (volumeName.isEmpty()) {
            return false;
        }
        String showVolumesSQLQuery = DatabricksUCVolumeClient.createShowVolumesQuery(catalog, schema);
        try (Statement statement = this.connection.createStatement();){
            boolean bl;
            block16: {
                ResultSet resultSet = statement.executeQuery(showVolumesSQLQuery);
                try {
                    LOGGER.info("SQL query executed successfully");
                    boolean exists = false;
                    while (resultSet.next()) {
                        String volume = resultSet.getString(UC_VOLUME_COLUMN_VOLUME_NAME);
                        if (!volume.regionMatches(!caseSensitive, 0, volumeName, 0, volumeName.length())) continue;
                        exists = true;
                        break;
                    }
                    bl = exists;
                    if (resultSet == null) break block16;
                }
                catch (Throwable throwable) {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                resultSet.close();
            }
            return bl;
        }
        catch (SQLException e) {
            LOGGER.error("SQL query execution failed " + String.valueOf(e));
            throw e;
        }
    }

    public boolean volumeExists(String catalog, String schema, String volumeName) throws SQLException {
        return this.volumeExists(catalog, schema, volumeName, true);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<String> listObjects(String catalog, String schema, String volume, String prefix, boolean caseSensitive) throws SQLException {
        LOGGER.info(String.format("Entering listObjects method with parameters: catalog={%s}, schema={%s}, volume={%s}, prefix={%s}, caseSensitive={%s}", catalog, schema, volume, prefix, caseSensitive));
        String folder = StringUtil.getFolderNameFromPath(prefix);
        String basename = StringUtil.getBaseNameFromPath(prefix);
        String listFilesSQLQuery = DatabricksUCVolumeClient.createListQuery(catalog, schema, volume, folder);
        try (Statement statement = this.connection.createStatement();){
            ArrayList<String> arrayList;
            block15: {
                ResultSet resultSet = statement.executeQuery(listFilesSQLQuery);
                try {
                    LOGGER.info("SQL query executed successfully");
                    ArrayList<String> filenames = new ArrayList<String>();
                    while (resultSet.next()) {
                        String fileName = resultSet.getString(UC_VOLUME_COLUMN_NAME);
                        if (!StringUtil.checkPrefixMatch(basename, fileName, caseSensitive)) continue;
                        filenames.add(fileName);
                    }
                    arrayList = filenames;
                    if (resultSet == null) break block15;
                }
                catch (Throwable throwable) {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                resultSet.close();
            }
            return arrayList;
        }
        catch (SQLException e) {
            LOGGER.error("SQL query execution failed" + String.valueOf(e));
            throw e;
        }
    }

    public List<String> listObjects(String catalog, String schema, String volume, String prefix) throws SQLException {
        return this.listObjects(catalog, schema, volume, prefix, true);
    }

    @Override
    public boolean getObject(String catalog, String schema, String volume, String objectPath, String localPath) throws SQLException {
        LOGGER.debug(String.format("Entering getObject method with parameters: catalog={%s}, schema={%s}, volume={%s}, objectPath={%s}, localPath={%s}", catalog, schema, volume, objectPath, localPath));
        String getObjectQuery = DatabricksUCVolumeClient.createGetObjectQuery(catalog, schema, volume, objectPath, localPath);
        boolean volumeOperationStatus = false;
        try (Statement statement = this.connection.createStatement();
             ResultSet resultSet = statement.executeQuery(getObjectQuery);){
            LOGGER.info("GET query executed successfully");
            if (resultSet.next()) {
                String volumeOperationStatusString = resultSet.getString("operation_status");
                volumeOperationStatus = "SUCCEEDED".equals(volumeOperationStatusString);
            }
        }
        catch (SQLException e) {
            LOGGER.error("GET query execution failed " + String.valueOf(e));
            throw e;
        }
        return volumeOperationStatus;
    }

    /*
     * Loose catch block
     */
    @Override
    public InputStreamEntity getObject(String catalog, String schema, String volume, String objectPath) throws SQLException {
        LOGGER.debug(String.format("Entering getObject method with parameters: catalog={%s}, schema={%s}, volume={%s}, objectPath={%s}", catalog, schema, volume, objectPath));
        String getObjectQuery = DatabricksUCVolumeClient.createGetObjectQueryForInputStream(catalog, schema, volume, objectPath);
        try (Statement statement = this.connection.createStatement();){
            InputStreamEntity inputStreamEntity;
            block19: {
                ResultSet resultSet;
                block17: {
                    InputStreamEntity inputStreamEntity2;
                    block18: {
                        IDatabricksStatementInternal databricksStatement = statement.unwrap(IDatabricksStatementInternal.class);
                        databricksStatement.allowInputStreamForVolumeOperation(true);
                        resultSet = statement.executeQuery(getObjectQuery);
                        LOGGER.info("GET query executed successfully");
                        if (!resultSet.next()) break block17;
                        inputStreamEntity2 = resultSet.unwrap(IDatabricksResultSetInternal.class).getVolumeOperationInputStream();
                        if (resultSet == null) break block18;
                        resultSet.close();
                    }
                    return inputStreamEntity2;
                }
                inputStreamEntity = null;
                if (resultSet == null) break block19;
                {
                    catch (Throwable throwable) {
                        try {
                            if (resultSet != null) {
                                try {
                                    resultSet.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (SQLException e) {
                            LOGGER.error("GET query execution failed " + String.valueOf(e));
                            throw e;
                        }
                    }
                }
                resultSet.close();
            }
            return inputStreamEntity;
        }
    }

    @Override
    public boolean putObject(String catalog, String schema, String volume, String objectPath, String localPath, boolean toOverwrite) throws SQLException {
        LOGGER.debug(String.format("Entering putObject method with parameters: catalog={%s}, schema={%s}, volume={%s}, objectPath={%s}, localPath={%s}, toOverwrite={%s}", catalog, schema, volume, objectPath, localPath, toOverwrite));
        String putObjectQuery = DatabricksUCVolumeClient.createPutObjectQuery(catalog, schema, volume, objectPath, localPath, toOverwrite);
        boolean isOperationSucceeded = false;
        try (Statement statement = this.connection.createStatement();
             ResultSet resultSet = statement.executeQuery(putObjectQuery);){
            LOGGER.info("PUT query executed successfully");
            if (resultSet.next()) {
                String volumeOperationStatusString = resultSet.getString("operation_status");
                isOperationSucceeded = "SUCCEEDED".equals(volumeOperationStatusString);
            }
        }
        catch (SQLException e) {
            LOGGER.error("PUT query execution failed " + String.valueOf(e));
            throw e;
        }
        return isOperationSucceeded;
    }

    @Override
    public boolean putObject(String catalog, String schema, String volume, String objectPath, InputStream inputStream, long contentLength, boolean toOverwrite) throws SQLException {
        LOGGER.debug(String.format("Entering putObject method with parameters: catalog={%s}, schema={%s}, volume={%s}, objectPath={%s}, inputStream={%s}, toOverwrite={%s}", catalog, schema, volume, objectPath, inputStream, toOverwrite));
        String putObjectQueryForInputStream = DatabricksUCVolumeClient.createPutObjectQueryForInputStream(catalog, schema, volume, objectPath, toOverwrite);
        boolean isOperationSucceeded = false;
        try (Statement statement = this.connection.createStatement();){
            IDatabricksStatementInternal databricksStatement = statement.unwrap(IDatabricksStatementInternal.class);
            databricksStatement.allowInputStreamForVolumeOperation(true);
            databricksStatement.setInputStreamForUCVolume(new InputStreamEntity(inputStream, contentLength));
            try (ResultSet resultSet = statement.executeQuery(putObjectQueryForInputStream);){
                LOGGER.info("PUT query executed successfully");
                if (resultSet.next()) {
                    String volumeOperationStatusString = resultSet.getString("operation_status");
                    isOperationSucceeded = "SUCCEEDED".equals(volumeOperationStatusString);
                }
            }
        }
        catch (SQLException e) {
            LOGGER.error("PUT query execution failed " + String.valueOf(e));
            throw e;
        }
        return isOperationSucceeded;
    }

    @Override
    public boolean deleteObject(String catalog, String schema, String volume, String objectPath) throws SQLException {
        LOGGER.debug(String.format("Entering deleteObject method with parameters: catalog={%s}, schema={%s}, volume={%s}, objectPath={%s}", catalog, schema, volume, objectPath));
        String deleteObjectQuery = DatabricksUCVolumeClient.createDeleteObjectQuery(catalog, schema, volume, objectPath);
        boolean isOperationSucceeded = false;
        try (Statement statement = this.connection.createStatement();
             ResultSet resultSet = statement.executeQuery(deleteObjectQuery);){
            LOGGER.info("SQL query executed successfully");
            if (resultSet.next()) {
                String volumeOperationStatusString = resultSet.getString("operation_status");
                isOperationSucceeded = "SUCCEEDED".equals(volumeOperationStatusString);
            }
        }
        catch (SQLException e) {
            LOGGER.error("SQL query execution failed " + String.valueOf(e));
            throw e;
        }
        return isOperationSucceeded;
    }

    @Override
    public List<VolumePutResult> putFiles(String catalog, String schema, String volume, List<String> objectPaths, List<InputStream> inputStreams, List<Long> contentLengths, boolean toOverwrite) throws DatabricksSQLFeatureNotSupportedException {
        throw new DatabricksSQLFeatureNotSupportedException("putFiles(...) is not supported. Please use DBFSVolumeClient instead.");
    }

    @Override
    public List<VolumePutResult> putFiles(String catalog, String schema, String volume, List<String> objectPaths, List<String> localPaths, boolean toOverwrite) throws DatabricksSQLFeatureNotSupportedException {
        throw new DatabricksSQLFeatureNotSupportedException("putFiles(...) is not supported. Please use DBFSVolumeClient instead.");
    }
}

