/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.jdbc.api.impl.converters;

import com.databricks.jdbc.api.impl.converters.ObjectConverter;
import com.databricks.jdbc.exception.DatabricksSQLException;
import com.databricks.jdbc.model.telemetry.enums.DatabricksDriverErrorCode;
import java.math.BigDecimal;
import java.math.BigInteger;

public class BooleanConverter
implements ObjectConverter {
    @Override
    public boolean toBoolean(Object object) throws DatabricksSQLException {
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        if (object instanceof String) {
            return Boolean.parseBoolean((String)object);
        }
        throw new DatabricksSQLException("Unsupported object type for BooleanObjectConverter", DatabricksDriverErrorCode.UNSUPPORTED_OPERATION);
    }

    @Override
    public byte toByte(Object object) throws DatabricksSQLException {
        return (byte)(this.toBoolean(object) ? 1 : 0);
    }

    @Override
    public short toShort(Object object) throws DatabricksSQLException {
        return (short)(this.toBoolean(object) ? 1 : 0);
    }

    @Override
    public int toInt(Object object) throws DatabricksSQLException {
        return this.toBoolean(object) ? 1 : 0;
    }

    @Override
    public long toLong(Object object) throws DatabricksSQLException {
        return this.toBoolean(object) ? 1L : 0L;
    }

    @Override
    public float toFloat(Object object) throws DatabricksSQLException {
        return this.toBoolean(object) ? 1.0f : 0.0f;
    }

    @Override
    public double toDouble(Object object) throws DatabricksSQLException {
        return this.toBoolean(object) ? 1.0 : 0.0;
    }

    @Override
    public BigDecimal toBigDecimal(Object object) throws DatabricksSQLException {
        return BigDecimal.valueOf(this.toBoolean(object) ? 1L : 0L);
    }

    @Override
    public BigInteger toBigInteger(Object object) throws DatabricksSQLException {
        return this.toBoolean(object) ? BigInteger.ONE : BigInteger.ZERO;
    }

    @Override
    public byte[] toByteArray(Object object) throws DatabricksSQLException {
        byte[] byArray;
        if (this.toBoolean(object)) {
            byte[] byArray2 = new byte[1];
            byArray = byArray2;
            byArray2[0] = 1;
        } else {
            byte[] byArray3 = new byte[1];
            byArray = byArray3;
            byArray3[0] = 0;
        }
        return byArray;
    }

    @Override
    public char toChar(Object object) throws DatabricksSQLException {
        return this.toBoolean(object) ? (char)'1' : '0';
    }

    @Override
    public String toString(Object object) throws DatabricksSQLException {
        return String.valueOf(this.toBoolean(object));
    }
}

