/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.jdbc.api.impl;

import com.databricks.internal.google.common.base.MoreObjects;
import com.databricks.internal.google.errorprone.annotations.CanIgnoreReturnValue;
import com.databricks.jdbc.api.impl.SessionInfo;
import com.databricks.jdbc.common.IDatabricksComputeResource;
import com.databricks.jdbc.model.client.thrift.generated.TSessionHandle;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="SessionInfo", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class ImmutableSessionInfo
implements SessionInfo {
    private final String sessionId;
    private final IDatabricksComputeResource computeResource;
    @Nullable
    private final TSessionHandle sessionHandle;

    private ImmutableSessionInfo(String sessionId, IDatabricksComputeResource computeResource, @Nullable TSessionHandle sessionHandle) {
        this.sessionId = sessionId;
        this.computeResource = computeResource;
        this.sessionHandle = sessionHandle;
    }

    @Override
    public String sessionId() {
        return this.sessionId;
    }

    @Override
    public IDatabricksComputeResource computeResource() {
        return this.computeResource;
    }

    @Override
    @Nullable
    public TSessionHandle sessionHandle() {
        return this.sessionHandle;
    }

    public final ImmutableSessionInfo withSessionId(String value) {
        String newValue = Objects.requireNonNull(value, "sessionId");
        if (this.sessionId.equals(newValue)) {
            return this;
        }
        return new ImmutableSessionInfo(newValue, this.computeResource, this.sessionHandle);
    }

    public final ImmutableSessionInfo withComputeResource(IDatabricksComputeResource value) {
        if (this.computeResource == value) {
            return this;
        }
        IDatabricksComputeResource newValue = Objects.requireNonNull(value, "computeResource");
        return new ImmutableSessionInfo(this.sessionId, newValue, this.sessionHandle);
    }

    public final ImmutableSessionInfo withSessionHandle(@Nullable TSessionHandle value) {
        if (this.sessionHandle == value) {
            return this;
        }
        return new ImmutableSessionInfo(this.sessionId, this.computeResource, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSessionInfo && this.equalTo(0, (ImmutableSessionInfo)another);
    }

    private boolean equalTo(int synthetic, ImmutableSessionInfo another) {
        return this.sessionId.equals(another.sessionId) && this.computeResource.equals(another.computeResource) && Objects.equals(this.sessionHandle, another.sessionHandle);
    }

    public int hashCode() {
        int h2 = 5381;
        h2 += (h2 << 5) + this.sessionId.hashCode();
        h2 += (h2 << 5) + this.computeResource.hashCode();
        h2 += (h2 << 5) + Objects.hashCode(this.sessionHandle);
        return h2;
    }

    public String toString() {
        return MoreObjects.toStringHelper("SessionInfo").omitNullValues().add("sessionId", this.sessionId).add("computeResource", this.computeResource).add("sessionHandle", this.sessionHandle).toString();
    }

    public static ImmutableSessionInfo copyOf(SessionInfo instance) {
        if (instance instanceof ImmutableSessionInfo) {
            return (ImmutableSessionInfo)instance;
        }
        return ImmutableSessionInfo.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="SessionInfo", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_SESSION_ID = 1L;
        private static final long INIT_BIT_COMPUTE_RESOURCE = 2L;
        private long initBits = 3L;
        @Nullable
        private String sessionId;
        @Nullable
        private IDatabricksComputeResource computeResource;
        @Nullable
        private TSessionHandle sessionHandle;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(SessionInfo instance) {
            Objects.requireNonNull(instance, "instance");
            this.sessionId(instance.sessionId());
            this.computeResource(instance.computeResource());
            TSessionHandle sessionHandleValue = instance.sessionHandle();
            if (sessionHandleValue != null) {
                this.sessionHandle(sessionHandleValue);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder sessionId(String sessionId) {
            this.sessionId = Objects.requireNonNull(sessionId, "sessionId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder computeResource(IDatabricksComputeResource computeResource) {
            this.computeResource = Objects.requireNonNull(computeResource, "computeResource");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder sessionHandle(@Nullable TSessionHandle sessionHandle) {
            this.sessionHandle = sessionHandle;
            return this;
        }

        public ImmutableSessionInfo build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSessionInfo(this.sessionId, this.computeResource, this.sessionHandle);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("sessionId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("computeResource");
            }
            return "Cannot build SessionInfo, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

