/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.sdk.service.sharing;

import com.databricks.internal.sdk.core.ApiClient;
import com.databricks.internal.sdk.service.sharing.CreateRecipient;
import com.databricks.internal.sdk.service.sharing.DeleteRecipientRequest;
import com.databricks.internal.sdk.service.sharing.GetRecipientRequest;
import com.databricks.internal.sdk.service.sharing.GetRecipientSharePermissionsResponse;
import com.databricks.internal.sdk.service.sharing.ListRecipientsRequest;
import com.databricks.internal.sdk.service.sharing.ListRecipientsResponse;
import com.databricks.internal.sdk.service.sharing.RecipientInfo;
import com.databricks.internal.sdk.service.sharing.RecipientsImpl;
import com.databricks.internal.sdk.service.sharing.RecipientsService;
import com.databricks.internal.sdk.service.sharing.RotateRecipientToken;
import com.databricks.internal.sdk.service.sharing.SharePermissionsRequest;
import com.databricks.internal.sdk.service.sharing.UpdateRecipient;
import com.databricks.internal.sdk.support.Generated;
import com.databricks.internal.sdk.support.Paginator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Generated
public class RecipientsAPI {
    private static final Logger LOG = LoggerFactory.getLogger(RecipientsAPI.class);
    private final RecipientsService impl;

    public RecipientsAPI(ApiClient apiClient) {
        this.impl = new RecipientsImpl(apiClient);
    }

    public RecipientsAPI(RecipientsService mock) {
        this.impl = mock;
    }

    public RecipientInfo create(CreateRecipient request) {
        return this.impl.create(request);
    }

    public void delete(String name) {
        this.delete(new DeleteRecipientRequest().setName(name));
    }

    public void delete(DeleteRecipientRequest request) {
        this.impl.delete(request);
    }

    public RecipientInfo get(String name) {
        return this.get(new GetRecipientRequest().setName(name));
    }

    public RecipientInfo get(GetRecipientRequest request) {
        return this.impl.get(request);
    }

    public Iterable<RecipientInfo> list(ListRecipientsRequest request) {
        if (request.getMaxResults() == null) {
            request.setMaxResults(0L);
        }
        return new Paginator(request, this.impl::list, ListRecipientsResponse::getRecipients, response -> {
            String token = response.getNextPageToken();
            if (token == null || token.isEmpty()) {
                return null;
            }
            return request.setPageToken(token);
        });
    }

    public RecipientInfo rotateToken(RotateRecipientToken request) {
        return this.impl.rotateToken(request);
    }

    public GetRecipientSharePermissionsResponse sharePermissions(String name) {
        return this.sharePermissions(new SharePermissionsRequest().setName(name));
    }

    public GetRecipientSharePermissionsResponse sharePermissions(SharePermissionsRequest request) {
        return this.impl.sharePermissions(request);
    }

    public RecipientInfo update(UpdateRecipient request) {
        return this.impl.update(request);
    }

    public RecipientsService impl() {
        return this.impl;
    }
}

