/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.sdk.service.iam;

import com.databricks.internal.sdk.core.ApiClient;
import com.databricks.internal.sdk.service.iam.CreateUserRequest;
import com.databricks.internal.sdk.service.iam.DeleteUserRequest;
import com.databricks.internal.sdk.service.iam.GetPasswordPermissionLevelsRequest;
import com.databricks.internal.sdk.service.iam.GetPasswordPermissionLevelsResponse;
import com.databricks.internal.sdk.service.iam.GetPasswordPermissionsRequest;
import com.databricks.internal.sdk.service.iam.GetUserRequest;
import com.databricks.internal.sdk.service.iam.ListUsersRequest;
import com.databricks.internal.sdk.service.iam.ListUsersResponse;
import com.databricks.internal.sdk.service.iam.PasswordPermissions;
import com.databricks.internal.sdk.service.iam.PasswordPermissionsRequest;
import com.databricks.internal.sdk.service.iam.PatchUserRequest;
import com.databricks.internal.sdk.service.iam.UpdateUserRequest;
import com.databricks.internal.sdk.service.iam.User;
import com.databricks.internal.sdk.service.iam.UsersV2Impl;
import com.databricks.internal.sdk.service.iam.UsersV2Service;
import com.databricks.internal.sdk.support.Generated;
import com.databricks.internal.sdk.support.Paginator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Generated
public class UsersV2API {
    private static final Logger LOG = LoggerFactory.getLogger(UsersV2API.class);
    private final UsersV2Service impl;

    public UsersV2API(ApiClient apiClient) {
        this.impl = new UsersV2Impl(apiClient);
    }

    public UsersV2API(UsersV2Service mock) {
        this.impl = mock;
    }

    public User create(CreateUserRequest request) {
        return this.impl.create(request);
    }

    public void delete(String id) {
        this.delete(new DeleteUserRequest().setId(id));
    }

    public void delete(DeleteUserRequest request) {
        this.impl.delete(request);
    }

    public User get(String id) {
        return this.get(new GetUserRequest().setId(id));
    }

    public User get(GetUserRequest request) {
        return this.impl.get(request);
    }

    public GetPasswordPermissionLevelsResponse getPermissionLevels(GetPasswordPermissionLevelsRequest request) {
        return this.impl.getPermissionLevels(request);
    }

    public PasswordPermissions getPermissions(GetPasswordPermissionsRequest request) {
        return this.impl.getPermissions(request);
    }

    public Iterable<User> list(ListUsersRequest request) {
        request.setStartIndex(1L);
        if (request.getCount() == null) {
            request.setCount(10000L);
        }
        return new Paginator(request, this.impl::list, ListUsersResponse::getResources, response -> {
            Long offset = request.getStartIndex();
            if (offset == null) {
                offset = 0L;
            }
            offset = offset + (long)response.getResources().size();
            return request.setStartIndex(offset);
        });
    }

    public void patch(PatchUserRequest request) {
        this.impl.patch(request);
    }

    public PasswordPermissions setPermissions(PasswordPermissionsRequest request) {
        return this.impl.setPermissions(request);
    }

    public void update(UpdateUserRequest request) {
        this.impl.update(request);
    }

    public PasswordPermissions updatePermissions(PasswordPermissionsRequest request) {
        return this.impl.updatePermissions(request);
    }

    public UsersV2Service impl() {
        return this.impl;
    }
}

