/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.sdk.service.catalog;

import com.databricks.internal.sdk.core.ApiClient;
import com.databricks.internal.sdk.service.catalog.GetQuotaRequest;
import com.databricks.internal.sdk.service.catalog.GetQuotaResponse;
import com.databricks.internal.sdk.service.catalog.ListQuotasRequest;
import com.databricks.internal.sdk.service.catalog.ListQuotasResponse;
import com.databricks.internal.sdk.service.catalog.QuotaInfo;
import com.databricks.internal.sdk.service.catalog.ResourceQuotasImpl;
import com.databricks.internal.sdk.service.catalog.ResourceQuotasService;
import com.databricks.internal.sdk.support.Generated;
import com.databricks.internal.sdk.support.Paginator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Generated
public class ResourceQuotasAPI {
    private static final Logger LOG = LoggerFactory.getLogger(ResourceQuotasAPI.class);
    private final ResourceQuotasService impl;

    public ResourceQuotasAPI(ApiClient apiClient) {
        this.impl = new ResourceQuotasImpl(apiClient);
    }

    public ResourceQuotasAPI(ResourceQuotasService mock) {
        this.impl = mock;
    }

    public GetQuotaResponse getQuota(String parentSecurableType, String parentFullName, String quotaName) {
        return this.getQuota(new GetQuotaRequest().setParentSecurableType(parentSecurableType).setParentFullName(parentFullName).setQuotaName(quotaName));
    }

    public GetQuotaResponse getQuota(GetQuotaRequest request) {
        return this.impl.getQuota(request);
    }

    public Iterable<QuotaInfo> listQuotas(ListQuotasRequest request) {
        return new Paginator(request, this.impl::listQuotas, ListQuotasResponse::getQuotas, response -> {
            String token = response.getNextPageToken();
            if (token == null || token.isEmpty()) {
                return null;
            }
            return request.setPageToken(token);
        });
    }

    public ResourceQuotasService impl() {
        return this.impl;
    }
}

