/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.sdk.service.catalog;

import com.databricks.internal.sdk.core.ApiClient;
import com.databricks.internal.sdk.core.DatabricksException;
import com.databricks.internal.sdk.core.http.Request;
import com.databricks.internal.sdk.service.catalog.CreateExternalMetadataRequest;
import com.databricks.internal.sdk.service.catalog.DeleteExternalMetadataRequest;
import com.databricks.internal.sdk.service.catalog.ExternalMetadata;
import com.databricks.internal.sdk.service.catalog.ExternalMetadataService;
import com.databricks.internal.sdk.service.catalog.GetExternalMetadataRequest;
import com.databricks.internal.sdk.service.catalog.ListExternalMetadataRequest;
import com.databricks.internal.sdk.service.catalog.ListExternalMetadataResponse;
import com.databricks.internal.sdk.service.catalog.UpdateExternalMetadataRequest;
import com.databricks.internal.sdk.support.Generated;
import java.io.IOException;

@Generated
class ExternalMetadataImpl
implements ExternalMetadataService {
    private final ApiClient apiClient;

    public ExternalMetadataImpl(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    @Override
    public ExternalMetadata createExternalMetadata(CreateExternalMetadataRequest request) {
        String path = "/api/2.0/lineage-tracking/external-metadata";
        try {
            Request req = new Request("POST", path, this.apiClient.serialize(request.getExternalMetadata()));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, ExternalMetadata.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public void deleteExternalMetadata(DeleteExternalMetadataRequest request) {
        String path = String.format("/api/2.0/lineage-tracking/external-metadata/%s", request.getName());
        try {
            Request req = new Request("DELETE", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            this.apiClient.execute(req, Void.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public ExternalMetadata getExternalMetadata(GetExternalMetadataRequest request) {
        String path = String.format("/api/2.0/lineage-tracking/external-metadata/%s", request.getName());
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, ExternalMetadata.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public ListExternalMetadataResponse listExternalMetadata(ListExternalMetadataRequest request) {
        String path = "/api/2.0/lineage-tracking/external-metadata";
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, ListExternalMetadataResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public ExternalMetadata updateExternalMetadata(UpdateExternalMetadataRequest request) {
        String path = String.format("/api/2.0/lineage-tracking/external-metadata/%s", request.getName());
        try {
            Request req = new Request("PATCH", path, this.apiClient.serialize(request.getExternalMetadata()));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, ExternalMetadata.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }
}

