/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.sdk.service.apps;

import com.databricks.internal.sdk.core.ApiClient;
import com.databricks.internal.sdk.core.DatabricksException;
import com.databricks.internal.sdk.core.http.Request;
import com.databricks.internal.sdk.service.apps.AppsSettingsService;
import com.databricks.internal.sdk.service.apps.CreateCustomTemplateRequest;
import com.databricks.internal.sdk.service.apps.CustomTemplate;
import com.databricks.internal.sdk.service.apps.DeleteCustomTemplateRequest;
import com.databricks.internal.sdk.service.apps.GetCustomTemplateRequest;
import com.databricks.internal.sdk.service.apps.ListCustomTemplatesRequest;
import com.databricks.internal.sdk.service.apps.ListCustomTemplatesResponse;
import com.databricks.internal.sdk.service.apps.UpdateCustomTemplateRequest;
import com.databricks.internal.sdk.support.Generated;
import java.io.IOException;

@Generated
class AppsSettingsImpl
implements AppsSettingsService {
    private final ApiClient apiClient;

    public AppsSettingsImpl(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    @Override
    public CustomTemplate createCustomTemplate(CreateCustomTemplateRequest request) {
        String path = "/api/2.0/apps-settings/templates";
        try {
            Request req = new Request("POST", path, this.apiClient.serialize(request.getTemplate()));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, CustomTemplate.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public CustomTemplate deleteCustomTemplate(DeleteCustomTemplateRequest request) {
        String path = String.format("/api/2.0/apps-settings/templates/%s", request.getName());
        try {
            Request req = new Request("DELETE", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, CustomTemplate.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public CustomTemplate getCustomTemplate(GetCustomTemplateRequest request) {
        String path = String.format("/api/2.0/apps-settings/templates/%s", request.getName());
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, CustomTemplate.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public ListCustomTemplatesResponse listCustomTemplates(ListCustomTemplatesRequest request) {
        String path = "/api/2.0/apps-settings/templates";
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, ListCustomTemplatesResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public CustomTemplate updateCustomTemplate(UpdateCustomTemplateRequest request) {
        String path = String.format("/api/2.0/apps-settings/templates/%s", request.getName());
        try {
            Request req = new Request("PUT", path, this.apiClient.serialize(request.getTemplate()));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, CustomTemplate.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }
}

