/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.bouncycastle.pqc.jcajce.provider.bike;

import com.databricks.internal.bouncycastle.crypto.AsymmetricCipherKeyPair;
import com.databricks.internal.bouncycastle.crypto.CryptoServicesRegistrar;
import com.databricks.internal.bouncycastle.pqc.crypto.bike.BIKEKeyGenerationParameters;
import com.databricks.internal.bouncycastle.pqc.crypto.bike.BIKEKeyPairGenerator;
import com.databricks.internal.bouncycastle.pqc.crypto.bike.BIKEParameters;
import com.databricks.internal.bouncycastle.pqc.crypto.bike.BIKEPrivateKeyParameters;
import com.databricks.internal.bouncycastle.pqc.crypto.bike.BIKEPublicKeyParameters;
import com.databricks.internal.bouncycastle.pqc.jcajce.provider.bike.BCBIKEPrivateKey;
import com.databricks.internal.bouncycastle.pqc.jcajce.provider.bike.BCBIKEPublicKey;
import com.databricks.internal.bouncycastle.pqc.jcajce.provider.util.SpecUtil;
import com.databricks.internal.bouncycastle.pqc.jcajce.spec.BIKEParameterSpec;
import com.databricks.internal.bouncycastle.util.Strings;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.util.HashMap;
import java.util.Map;

public class BIKEKeyPairGeneratorSpi
extends KeyPairGenerator {
    private static Map parameters = new HashMap();
    BIKEKeyGenerationParameters param;
    BIKEKeyPairGenerator engine = new BIKEKeyPairGenerator();
    SecureRandom random = CryptoServicesRegistrar.getSecureRandom();
    boolean initialised = false;

    public BIKEKeyPairGeneratorSpi() {
        super("BIKE");
    }

    @Override
    public void initialize(int n, SecureRandom secureRandom) {
        throw new IllegalArgumentException("use AlgorithmParameterSpec");
    }

    @Override
    public void initialize(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        String string = BIKEKeyPairGeneratorSpi.getNameFromParams(algorithmParameterSpec);
        if (string == null) {
            throw new InvalidAlgorithmParameterException("invalid ParameterSpec: " + algorithmParameterSpec);
        }
        this.param = new BIKEKeyGenerationParameters(secureRandom, (BIKEParameters)parameters.get(string));
        this.engine.init(this.param);
        this.initialised = true;
    }

    private static String getNameFromParams(AlgorithmParameterSpec algorithmParameterSpec) {
        if (algorithmParameterSpec instanceof BIKEParameterSpec) {
            BIKEParameterSpec bIKEParameterSpec = (BIKEParameterSpec)algorithmParameterSpec;
            return bIKEParameterSpec.getName();
        }
        return Strings.toLowerCase(SpecUtil.getNameFrom(algorithmParameterSpec));
    }

    @Override
    public KeyPair generateKeyPair() {
        if (!this.initialised) {
            this.param = new BIKEKeyGenerationParameters(this.random, BIKEParameters.bike128);
            this.engine.init(this.param);
            this.initialised = true;
        }
        AsymmetricCipherKeyPair asymmetricCipherKeyPair = this.engine.generateKeyPair();
        BIKEPublicKeyParameters bIKEPublicKeyParameters = (BIKEPublicKeyParameters)asymmetricCipherKeyPair.getPublic();
        BIKEPrivateKeyParameters bIKEPrivateKeyParameters = (BIKEPrivateKeyParameters)asymmetricCipherKeyPair.getPrivate();
        return new KeyPair(new BCBIKEPublicKey(bIKEPublicKeyParameters), new BCBIKEPrivateKey(bIKEPrivateKeyParameters));
    }

    static {
        parameters.put("bike128", BIKEParameters.bike128);
        parameters.put("bike192", BIKEParameters.bike192);
        parameters.put("bike256", BIKEParameters.bike256);
        parameters.put(BIKEParameterSpec.bike128.getName(), BIKEParameters.bike128);
        parameters.put(BIKEParameterSpec.bike192.getName(), BIKEParameters.bike192);
        parameters.put(BIKEParameterSpec.bike256.getName(), BIKEParameters.bike256);
    }
}

