/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.bouncycastle.operator.jcajce;

import com.databricks.internal.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.databricks.internal.bouncycastle.jcajce.util.DefaultJcaJceHelper;
import com.databricks.internal.bouncycastle.jcajce.util.NamedJcaJceHelper;
import com.databricks.internal.bouncycastle.jcajce.util.ProviderJcaJceHelper;
import com.databricks.internal.bouncycastle.operator.GenericKey;
import com.databricks.internal.bouncycastle.operator.OperatorException;
import com.databricks.internal.bouncycastle.operator.SymmetricKeyUnwrapper;
import com.databricks.internal.bouncycastle.operator.jcajce.JceGenericKey;
import com.databricks.internal.bouncycastle.operator.jcajce.OperatorHelper;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;

public class JceSymmetricKeyUnwrapper
extends SymmetricKeyUnwrapper {
    private OperatorHelper helper = new OperatorHelper(new DefaultJcaJceHelper());
    private SecretKey secretKey;

    public JceSymmetricKeyUnwrapper(AlgorithmIdentifier algorithmIdentifier, SecretKey secretKey) {
        super(algorithmIdentifier);
        this.secretKey = secretKey;
    }

    public JceSymmetricKeyUnwrapper setProvider(Provider provider) {
        this.helper = new OperatorHelper(new ProviderJcaJceHelper(provider));
        return this;
    }

    public JceSymmetricKeyUnwrapper setProvider(String string) {
        this.helper = new OperatorHelper(new NamedJcaJceHelper(string));
        return this;
    }

    @Override
    public GenericKey generateUnwrappedKey(AlgorithmIdentifier algorithmIdentifier, byte[] byArray) throws OperatorException {
        try {
            Cipher cipher = this.helper.createSymmetricWrapper(this.getAlgorithmIdentifier().getAlgorithm());
            cipher.init(4, this.secretKey);
            return new JceGenericKey(algorithmIdentifier, cipher.unwrap(byArray, this.helper.getKeyAlgorithmName(algorithmIdentifier.getAlgorithm()), 3));
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new OperatorException("key invalid in message.", invalidKeyException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new OperatorException("can't find algorithm.", noSuchAlgorithmException);
        }
    }
}

