/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.bouncycastle.jcajce;

import com.databricks.internal.bouncycastle.crypto.PBEParametersGenerator;
import com.databricks.internal.bouncycastle.jcajce.PBKDFKey;

public class PKCS12Key
implements PBKDFKey {
    private final char[] password;
    private final boolean useWrongZeroLengthConversion;

    public PKCS12Key(char[] cArray) {
        this(cArray, false);
    }

    public PKCS12Key(char[] cArray, boolean bl) {
        if (cArray == null) {
            cArray = new char[]{};
        }
        this.password = new char[cArray.length];
        this.useWrongZeroLengthConversion = bl;
        System.arraycopy(cArray, 0, this.password, 0, cArray.length);
    }

    public char[] getPassword() {
        return this.password;
    }

    @Override
    public String getAlgorithm() {
        return "PKCS12";
    }

    @Override
    public String getFormat() {
        return "PKCS12";
    }

    @Override
    public byte[] getEncoded() {
        if (this.useWrongZeroLengthConversion && this.password.length == 0) {
            return new byte[2];
        }
        return PBEParametersGenerator.PKCS12PasswordToBytes(this.password);
    }
}

