/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.apache.arrow.vector.complex.impl;

import com.databricks.internal.apache.arrow.util.Preconditions;
import com.databricks.internal.apache.arrow.vector.complex.ListVector;
import com.databricks.internal.apache.arrow.vector.complex.MapVector;
import com.databricks.internal.apache.arrow.vector.complex.NonNullableStructVector;
import com.databricks.internal.apache.arrow.vector.complex.StateTool;
import com.databricks.internal.apache.arrow.vector.complex.StructVector;
import com.databricks.internal.apache.arrow.vector.complex.impl.AbstractFieldWriter;
import com.databricks.internal.apache.arrow.vector.complex.impl.NullableStructWriter;
import com.databricks.internal.apache.arrow.vector.complex.impl.NullableStructWriterFactory;
import com.databricks.internal.apache.arrow.vector.complex.impl.UnionListWriter;
import com.databricks.internal.apache.arrow.vector.complex.impl.UnionMapWriter;
import com.databricks.internal.apache.arrow.vector.complex.writer.BaseWriter;
import com.databricks.internal.apache.arrow.vector.types.pojo.Field;

public class ComplexWriterImpl
extends AbstractFieldWriter
implements BaseWriter.ComplexWriter {
    private NullableStructWriter structRoot;
    private UnionListWriter listRoot;
    private UnionMapWriter mapRoot;
    private final NonNullableStructVector container;
    Mode mode = Mode.INIT;
    private final String name;
    private final boolean unionEnabled;
    private final NullableStructWriterFactory nullableStructWriterFactory;

    public ComplexWriterImpl(String name, NonNullableStructVector container, boolean unionEnabled, boolean caseSensitive) {
        this.name = name;
        this.container = container;
        this.unionEnabled = unionEnabled;
        this.nullableStructWriterFactory = caseSensitive ? NullableStructWriterFactory.getNullableCaseSensitiveStructWriterFactoryInstance() : NullableStructWriterFactory.getNullableStructWriterFactoryInstance();
    }

    public ComplexWriterImpl(String name, NonNullableStructVector container, boolean unionEnabled) {
        this(name, container, unionEnabled, false);
    }

    public ComplexWriterImpl(String name, NonNullableStructVector container) {
        this(name, container, false);
    }

    @Override
    public Field getField() {
        return this.container.getField();
    }

    @Override
    public int getValueCapacity() {
        return this.container.getValueCapacity();
    }

    private void check(Mode ... modes) {
        StateTool.check((Enum)this.mode, (Enum[])modes);
    }

    @Override
    public void reset() {
        this.setPosition(0);
    }

    @Override
    public void close() throws Exception {
        this.clear();
        this.structRoot.close();
        if (this.listRoot != null) {
            this.listRoot.close();
        }
    }

    @Override
    public void clear() {
        switch (this.mode.ordinal()) {
            case 1: {
                this.structRoot.clear();
                break;
            }
            case 2: {
                this.listRoot.clear();
                break;
            }
            case 3: {
                this.mapRoot.clear();
                break;
            }
        }
    }

    @Override
    public void setValueCount(int count) {
        switch (this.mode.ordinal()) {
            case 1: {
                this.structRoot.setValueCount(count);
                break;
            }
            case 2: {
                this.listRoot.setValueCount(count);
                break;
            }
            case 3: {
                this.mapRoot.setValueCount(count);
                break;
            }
        }
    }

    @Override
    public void setPosition(int index) {
        super.setPosition(index);
        switch (this.mode.ordinal()) {
            case 1: {
                this.structRoot.setPosition(index);
                break;
            }
            case 2: {
                this.listRoot.setPosition(index);
                break;
            }
            case 3: {
                this.mapRoot.setPosition(index);
                break;
            }
        }
    }

    public BaseWriter.StructWriter directStruct() {
        Preconditions.checkArgument(this.name == null);
        switch (this.mode.ordinal()) {
            case 0: {
                this.structRoot = this.nullableStructWriterFactory.build((StructVector)this.container);
                this.structRoot.setPosition(this.idx());
                this.mode = Mode.STRUCT;
                break;
            }
            case 1: {
                break;
            }
            default: {
                this.check(Mode.INIT, Mode.STRUCT);
            }
        }
        return this.structRoot;
    }

    @Override
    public BaseWriter.StructWriter rootAsStruct() {
        switch (this.mode.ordinal()) {
            case 0: {
                StructVector struct = this.container.addOrGetStruct(this.name);
                this.structRoot = this.nullableStructWriterFactory.build(struct);
                this.structRoot.setPosition(this.idx());
                this.mode = Mode.STRUCT;
                break;
            }
            case 1: {
                break;
            }
            default: {
                this.check(Mode.INIT, Mode.STRUCT);
            }
        }
        return this.structRoot;
    }

    @Override
    public void allocate() {
        if (this.structRoot != null) {
            this.structRoot.allocate();
        } else if (this.listRoot != null) {
            this.listRoot.allocate();
        }
    }

    @Override
    public BaseWriter.ListWriter rootAsList() {
        switch (this.mode.ordinal()) {
            case 0: {
                int vectorCount = this.container.size();
                ListVector listVector = this.container.addOrGetList(this.name);
                if (this.container.size() > vectorCount) {
                    listVector.allocateNew();
                }
                this.listRoot = new UnionListWriter(listVector, this.nullableStructWriterFactory);
                this.listRoot.setPosition(this.idx());
                this.mode = Mode.LIST;
                break;
            }
            case 2: {
                break;
            }
            default: {
                this.check(Mode.INIT, Mode.STRUCT);
            }
        }
        return this.listRoot;
    }

    @Override
    public BaseWriter.MapWriter rootAsMap(boolean keysSorted) {
        switch (this.mode.ordinal()) {
            case 0: {
                int vectorCount = this.container.size();
                MapVector mapVector = this.container.addOrGetMap(this.name, keysSorted);
                if (this.container.size() > vectorCount) {
                    mapVector.allocateNew();
                }
                this.mapRoot = new UnionMapWriter(mapVector);
                this.mapRoot.setPosition(this.idx());
                this.mode = Mode.MAP;
                break;
            }
            case 3: {
                break;
            }
            default: {
                this.check(Mode.INIT, Mode.STRUCT);
            }
        }
        return this.mapRoot;
    }

    private static enum Mode {
        INIT,
        STRUCT,
        LIST,
        MAP;

    }
}

