/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.sqlengine.dsiext.dataengine;

import com.databricks.client.dsi.dataengine.utilities.ExecutionContext;
import com.databricks.client.dsi.dataengine.utilities.ExecutionContexts;
import com.databricks.client.dsi.dataengine.utilities.ExecutionResults;
import com.databricks.client.dsi.dataengine.utilities.ParameterInputValue;
import com.databricks.client.sqlengine.dsiext.dataengine.AbstractExecutionContext;
import com.databricks.client.sqlengine.exceptions.SQLEngineExceptionFactory;
import com.databricks.client.sqlengine.executor.IStatementExecutor;
import com.databricks.client.sqlengine.executor.etree.ETCancelState;
import com.databricks.client.support.IWarningListener;
import com.databricks.client.support.exceptions.ErrorException;
import java.util.List;
import java.util.Map;

class SingleExecutionContext
extends AbstractExecutionContext {
    private final List<IStatementExecutor> m_executors;
    private ErrorException m_reportedError;

    public SingleExecutionContext(List<IStatementExecutor> list, ExecutionContexts executionContexts, Map<Integer, ParameterInputValue[]> map, ETCancelState eTCancelState) {
        super(executionContexts, map, eTCancelState);
        assert (executionContexts.getCount() == 1);
        this.m_executors = list;
    }

    @Override
    public long getCurrentParameterSet() {
        return 1L;
    }

    @Override
    public void postError(long l, ErrorException errorException) {
        assert (l == 1L);
        if (this.m_reportedError == null) {
            this.m_reportedError = errorException;
        } else {
            this.m_reportedError.addSuppressed(errorException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExecutionResults execute(IWarningListener iWarningListener) throws ErrorException {
        ExecutionResults executionResults = new ExecutionResults();
        for (IStatementExecutor iterator : this.m_executors) {
            iterator.registerWarningListener(iWarningListener);
            iterator.startBatch();
        }
        try {
            Object object;
            this.notifyStartingParameterSet(1L);
            try {
                object = this.m_contexts.contextIterator().next();
                for (IStatementExecutor iStatementExecutor : this.m_executors) {
                    if (this.isCanceled()) {
                        throw SQLEngineExceptionFactory.operationCanceledException();
                    }
                    executionResults.addExecutionResult(this.executeOne(iStatementExecutor, (ExecutionContext)object, 1L));
                }
            }
            catch (ErrorException errorException) {
                this.postError(1L, errorException);
            }
            finally {
                if (this.m_reportedError != null) {
                    this.notifyParameterSetFailed(1L);
                }
                this.notifyFinishedParameterSet(1L);
            }
            if (this.m_reportedError != null) {
                throw this.m_reportedError;
            }
            for (IStatementExecutor iStatementExecutor : this.m_executors) {
                iStatementExecutor.endBatch();
            }
            if (this.m_reportedError != null) {
                throw this.m_reportedError;
            }
            object = executionResults;
            return object;
        }
        finally {
            for (IStatementExecutor iStatementExecutor : this.m_executors) {
                iStatementExecutor.close();
            }
        }
    }
}

