/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.sqlengine.aeprocessor.aemanipulator;

import com.databricks.client.sqlengine.aeprocessor.aetree.AEDefaultVisitor;
import com.databricks.client.sqlengine.aeprocessor.aetree.AENodeList;
import com.databricks.client.sqlengine.aeprocessor.aetree.IAENode;
import com.databricks.client.sqlengine.aeprocessor.aetree.bool.AEAnd;
import com.databricks.client.sqlengine.aeprocessor.aetree.bool.AEBooleanExpr;
import com.databricks.client.sqlengine.aeprocessor.aetree.bool.AEBooleanTrue;
import com.databricks.client.sqlengine.aeprocessor.aetree.bool.AEComparison;
import com.databricks.client.sqlengine.aeprocessor.aetree.bool.AEExistsPredicate;
import com.databricks.client.sqlengine.aeprocessor.aetree.bool.AEInPredicate;
import com.databricks.client.sqlengine.aeprocessor.aetree.bool.AELikePredicate;
import com.databricks.client.sqlengine.aeprocessor.aetree.bool.AENot;
import com.databricks.client.sqlengine.aeprocessor.aetree.bool.AENullPredicate;
import com.databricks.client.sqlengine.aeprocessor.aetree.bool.AEOr;
import com.databricks.client.sqlengine.aeprocessor.aetree.bool.AEQuantifiedComparison;
import com.databricks.client.sqlengine.aeprocessor.aetree.bool.AEValueAsBooleanExpr;
import com.databricks.client.sqlengine.aeprocessor.aetree.relation.AEAggregate;
import com.databricks.client.sqlengine.aeprocessor.aetree.relation.AEBinaryRelationalExpr;
import com.databricks.client.sqlengine.aeprocessor.aetree.relation.AECommonTableExpr;
import com.databricks.client.sqlengine.aeprocessor.aetree.relation.AECommonTableExprScope;
import com.databricks.client.sqlengine.aeprocessor.aetree.relation.AECrossJoin;
import com.databricks.client.sqlengine.aeprocessor.aetree.relation.AEDistinct;
import com.databricks.client.sqlengine.aeprocessor.aetree.relation.AEDummyTable;
import com.databricks.client.sqlengine.aeprocessor.aetree.relation.AEExcept;
import com.databricks.client.sqlengine.aeprocessor.aetree.relation.AEJoin;
import com.databricks.client.sqlengine.aeprocessor.aetree.relation.AENamedRelationalExpr;
import com.databricks.client.sqlengine.aeprocessor.aetree.relation.AEProcedure;
import com.databricks.client.sqlengine.aeprocessor.aetree.relation.AEProject;
import com.databricks.client.sqlengine.aeprocessor.aetree.relation.AERelationalExpr;
import com.databricks.client.sqlengine.aeprocessor.aetree.relation.AESelect;
import com.databricks.client.sqlengine.aeprocessor.aetree.relation.AESort;
import com.databricks.client.sqlengine.aeprocessor.aetree.relation.AESubQuery;
import com.databricks.client.sqlengine.aeprocessor.aetree.relation.AETable;
import com.databricks.client.sqlengine.aeprocessor.aetree.relation.AETableConstructor;
import com.databricks.client.sqlengine.aeprocessor.aetree.relation.AETop;
import com.databricks.client.sqlengine.aeprocessor.aetree.relation.AEUnaryRelationalExpr;
import com.databricks.client.sqlengine.aeprocessor.aetree.relation.AEUnion;
import com.databricks.client.sqlengine.aeprocessor.aetree.relation.AEWithClause;
import com.databricks.client.sqlengine.aeprocessor.aetree.statement.AECreateTable;
import com.databricks.client.sqlengine.aeprocessor.aetree.statement.AEDelete;
import com.databricks.client.sqlengine.aeprocessor.aetree.statement.AEDropTable;
import com.databricks.client.sqlengine.aeprocessor.aetree.statement.AEInsert;
import com.databricks.client.sqlengine.aeprocessor.aetree.statement.AEInsertDefaults;
import com.databricks.client.sqlengine.aeprocessor.aetree.statement.AEProcedureCall;
import com.databricks.client.sqlengine.aeprocessor.aetree.statement.AEQuery;
import com.databricks.client.sqlengine.aeprocessor.aetree.statement.AESetClause;
import com.databricks.client.sqlengine.aeprocessor.aetree.statement.AESetClauseList;
import com.databricks.client.sqlengine.aeprocessor.aetree.statement.AEStatements;
import com.databricks.client.sqlengine.aeprocessor.aetree.statement.AEUpdate;
import com.databricks.client.sqlengine.aeprocessor.aetree.value.AEAdd;
import com.databricks.client.sqlengine.aeprocessor.aetree.value.AEBinaryValueExpr;
import com.databricks.client.sqlengine.aeprocessor.aetree.value.AEBooleanValueExpr;
import com.databricks.client.sqlengine.aeprocessor.aetree.value.AECastFn;
import com.databricks.client.sqlengine.aeprocessor.aetree.value.AEColumnReference;
import com.databricks.client.sqlengine.aeprocessor.aetree.value.AEConcat;
import com.databricks.client.sqlengine.aeprocessor.aetree.value.AECountStarAggrFn;
import com.databricks.client.sqlengine.aeprocessor.aetree.value.AECustomScalarFn;
import com.databricks.client.sqlengine.aeprocessor.aetree.value.AEDefault;
import com.databricks.client.sqlengine.aeprocessor.aetree.value.AEDefaultParameter;
import com.databricks.client.sqlengine.aeprocessor.aetree.value.AEDivide;
import com.databricks.client.sqlengine.aeprocessor.aetree.value.AEGeneralAggrFn;
import com.databricks.client.sqlengine.aeprocessor.aetree.value.AELiteral;
import com.databricks.client.sqlengine.aeprocessor.aetree.value.AEMultiply;
import com.databricks.client.sqlengine.aeprocessor.aetree.value.AENegate;
import com.databricks.client.sqlengine.aeprocessor.aetree.value.AENull;
import com.databricks.client.sqlengine.aeprocessor.aetree.value.AEParameter;
import com.databricks.client.sqlengine.aeprocessor.aetree.value.AEProxyColumn;
import com.databricks.client.sqlengine.aeprocessor.aetree.value.AERename;
import com.databricks.client.sqlengine.aeprocessor.aetree.value.AEScalarFn;
import com.databricks.client.sqlengine.aeprocessor.aetree.value.AESearchedCase;
import com.databricks.client.sqlengine.aeprocessor.aetree.value.AESearchedWhenClause;
import com.databricks.client.sqlengine.aeprocessor.aetree.value.AESimpleCase;
import com.databricks.client.sqlengine.aeprocessor.aetree.value.AESimpleWhenClause;
import com.databricks.client.sqlengine.aeprocessor.aetree.value.AESubtract;
import com.databricks.client.sqlengine.aeprocessor.aetree.value.AEValueExpr;
import com.databricks.client.sqlengine.aeprocessor.aetree.value.AEValueExprList;
import com.databricks.client.sqlengine.aeprocessor.aetree.value.AEValueSubQuery;
import com.databricks.client.sqlengine.dsiext.dataengine.PassdownInformation;
import com.databricks.client.sqlengine.exceptions.SQLEngineExceptionFactory;
import com.databricks.client.support.exceptions.ErrorException;
import java.util.Iterator;

public class AETreeManipulator {
    public static void pushDownFilter(PassdownInformation passdownInformation, AEBooleanExpr aEBooleanExpr, AERelationalExpr aERelationalExpr) throws ErrorException {
        aEBooleanExpr.setIsOptimized(true);
        switch (PushDownType.getNodeType(aERelationalExpr)) {
            case JOIN: {
                AETreeManipulator.pushToJoin(aEBooleanExpr, (AEJoin)aERelationalExpr);
                break;
            }
            case CROSSJOIN: {
                AETreeManipulator.pushToCrossJoin(aEBooleanExpr, (AECrossJoin)aERelationalExpr);
                break;
            }
            case TABLE: {
                AETreeManipulator.pushToTable(aEBooleanExpr, (AETable)aERelationalExpr, passdownInformation);
                break;
            }
            case SELECT: {
                AETreeManipulator.pushToSelect(aEBooleanExpr, (AESelect)aERelationalExpr);
                break;
            }
            case TABLE_SUBQUERY: {
                AETreeManipulator.pushToTableSubquery(aEBooleanExpr, (AESubQuery)aERelationalExpr);
                break;
            }
            case PROJECT: {
                AETreeManipulator.insertSelectFilterInUnaryRelExpr(aEBooleanExpr, (AEProject)aERelationalExpr);
            }
            case COMMON_TABLE_EXPRESSION_SCOPE: {
                AETreeManipulator.pushToCteScope(aEBooleanExpr, (AECommonTableExprScope)aERelationalExpr);
            }
        }
    }

    public static void convertJoinToCrossJoin(AEJoin aEJoin) throws ErrorException {
        AETreeManipulator.replaceRelExpr(aEJoin, new AECrossJoin(aEJoin.getLeftOperand(), aEJoin.getRightOperand()));
    }

    public static void convertCrossJoinToInnerJoin(AECrossJoin aECrossJoin, AESelect aESelect) throws ErrorException {
        assert (aECrossJoin.getParent() == aESelect);
        AETreeManipulator.replaceRelExpr(aESelect, new AEJoin(AEJoin.AEJoinType.INNER_JOIN, aECrossJoin.getLeftOperand(), aECrossJoin.getRightOperand(), aESelect.getCondition()));
    }

    public static void removeSelect(AESelect aESelect) throws ErrorException {
        assert (aESelect.getCondition() instanceof AEBooleanTrue);
        AETreeManipulator.replaceRelExpr(aESelect, aESelect.getOperand());
    }

    public static void replaceValueExpr(AEValueExpr aEValueExpr, AEValueExpr aEValueExpr2) throws ErrorException {
        AETreeManipulator.replaceNode(aEValueExpr, aEValueExpr2);
    }

    public static void replaceRelExpr(AERelationalExpr aERelationalExpr, AERelationalExpr aERelationalExpr2) throws ErrorException {
        AETreeManipulator.replaceNode(aERelationalExpr, aERelationalExpr2);
    }

    public static <T extends IAENode> void replaceNode(T t, T t2) throws ErrorException {
        t.getParent().acceptVisitor(new NodeReplacer<T>(t2, t));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void pushToJoin(AEBooleanExpr aEBooleanExpr, AEJoin aEJoin) throws ErrorException {
        assert (null != aEBooleanExpr && null != aEJoin);
        AEBooleanExpr aEBooleanExpr2 = aEJoin.getJoinCondition();
        if (aEJoin.getJoinCondition() == aEBooleanExpr || AETreeManipulator.subtreeContainsReference(aEBooleanExpr2, aEBooleanExpr)) {
            return;
        }
        if (aEBooleanExpr2.isEquivalent(aEBooleanExpr)) {
            AETreeManipulator.detachFilter(aEBooleanExpr);
            return;
        }
        if (aEJoin.isOuterJoin()) {
            IAENode iAENode = aEJoin.getParent();
            if (iAENode instanceof AEUnaryRelationalExpr) {
                AETreeManipulator.insertSelectFilterInUnaryRelExpr(aEBooleanExpr, (AEUnaryRelationalExpr)iAENode);
                return;
            } else {
                if (!(iAENode instanceof AEBinaryRelationalExpr)) throw SQLEngineExceptionFactory.invalidAETreeException();
                AETreeManipulator.insertSelectFilterInBinaryRelExpr(aEBooleanExpr, (AEBinaryRelationalExpr)iAENode, aEJoin);
            }
            return;
        } else {
            AEAnd aEAnd = new AEAnd(AETreeManipulator.detachFilter(aEBooleanExpr), aEBooleanExpr2);
            aEJoin.setJoinCondition(aEAnd);
        }
    }

    private static void pushToCrossJoin(AEBooleanExpr aEBooleanExpr, AECrossJoin aECrossJoin) throws ErrorException {
        AEBooleanExpr aEBooleanExpr2;
        assert (null != aEBooleanExpr && null != aECrossJoin);
        IAENode iAENode = aECrossJoin.getParent();
        assert (null != iAENode);
        if (iAENode instanceof AESelect && ((aEBooleanExpr2 = ((AESelect)iAENode).getCondition()) == aEBooleanExpr || AETreeManipulator.subtreeContainsReference(aEBooleanExpr2, aEBooleanExpr))) {
            return;
        }
        switch (PushDownType.getNodeType(iAENode)) {
            case SELECT: {
                if (aEBooleanExpr.isEquivalent(((AESelect)iAENode).getCondition())) break;
                AETreeManipulator.pushToSelect(aEBooleanExpr, (AESelect)iAENode);
                break;
            }
            case PROJECT: {
                AETreeManipulator.insertSelectFilterInUnaryRelExpr(aEBooleanExpr, (AEUnaryRelationalExpr)iAENode);
                break;
            }
            case JOIN: 
            case CROSSJOIN: {
                AETreeManipulator.insertSelectFilterInBinaryRelExpr(aEBooleanExpr, (AEBinaryRelationalExpr)iAENode, aECrossJoin);
                break;
            }
            default: {
                throw SQLEngineExceptionFactory.invalidAETreeException();
            }
        }
    }

    private static void pushToTable(AEBooleanExpr aEBooleanExpr, AETable aETable, PassdownInformation passdownInformation) throws ErrorException {
        IAENode iAENode = aETable.getParent();
        switch (PushDownType.getNodeType(iAENode)) {
            case JOIN: 
            case CROSSJOIN: {
                boolean bl = false;
                if (passdownInformation.canHandlePassdown(aEBooleanExpr)) {
                    bl = true;
                } else if (passdownInformation.canHandlePassdown((AERelationalExpr)iAENode)) {
                    bl = true;
                }
                if (!bl) break;
                AETreeManipulator.insertSelectFilterInBinaryRelExpr(aEBooleanExpr, (AEBinaryRelationalExpr)iAENode, aETable);
                break;
            }
            case SELECT: {
                AETreeManipulator.pushToSelect(aEBooleanExpr, (AESelect)iAENode);
                break;
            }
            case PROJECT: {
                AETreeManipulator.insertSelectFilterInUnaryRelExpr(aEBooleanExpr, (AEUnaryRelationalExpr)iAENode);
                break;
            }
            default: {
                throw SQLEngineExceptionFactory.invalidAETreeException();
            }
        }
    }

    private static void pushToTableSubquery(AEBooleanExpr aEBooleanExpr, AESubQuery aESubQuery) throws ErrorException {
        IAENode iAENode = aESubQuery.getParent();
        if (iAENode instanceof AEUnaryRelationalExpr) {
            AETreeManipulator.insertSelectFilterInUnaryRelExpr(aEBooleanExpr, (AEUnaryRelationalExpr)iAENode);
        } else if (iAENode instanceof AEBinaryRelationalExpr) {
            AETreeManipulator.insertSelectFilterInBinaryRelExpr(aEBooleanExpr, (AEBinaryRelationalExpr)iAENode, aESubQuery);
        } else {
            throw SQLEngineExceptionFactory.invalidAETreeException();
        }
    }

    private static void pushToSelect(AEBooleanExpr aEBooleanExpr, AESelect aESelect) throws ErrorException {
        AEAnd aEAnd = new AEAnd(AETreeManipulator.detachFilter(aEBooleanExpr), aESelect.getCondition());
        aESelect.setSelectCond(aEAnd);
    }

    private static void insertSelectFilterInUnaryRelExpr(AEBooleanExpr aEBooleanExpr, AEUnaryRelationalExpr aEUnaryRelationalExpr) throws ErrorException {
        AERelationalExpr aERelationalExpr = aEUnaryRelationalExpr.getOperand();
        aEUnaryRelationalExpr.setOperand(new AESelect(aERelationalExpr, AETreeManipulator.detachFilter(aEBooleanExpr)));
    }

    private static void pushToCteScope(AEBooleanExpr aEBooleanExpr, AECommonTableExprScope aECommonTableExprScope) throws ErrorException {
        AERelationalExpr aERelationalExpr = aECommonTableExprScope.getRightOperand();
        aECommonTableExprScope.setRightOperand(new AESelect(aERelationalExpr, AETreeManipulator.detachFilter(aEBooleanExpr)));
    }

    private static void insertSelectFilterInBinaryRelExpr(AEBooleanExpr aEBooleanExpr, AEBinaryRelationalExpr aEBinaryRelationalExpr, AERelationalExpr aERelationalExpr) throws ErrorException {
        AESelect aESelect = new AESelect(aERelationalExpr, AETreeManipulator.detachFilter(aEBooleanExpr));
        if (aEBinaryRelationalExpr.getLeftOperand() == aERelationalExpr) {
            aEBinaryRelationalExpr.setLeftOperand(aESelect);
        } else {
            aEBinaryRelationalExpr.setRightOperand(aESelect);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static AEBooleanExpr detachFilter(AEBooleanExpr aEBooleanExpr) throws ErrorException {
        assert (null != aEBooleanExpr);
        AEBooleanExpr aEBooleanExpr2 = null;
        IAENode iAENode = aEBooleanExpr.getParent();
        if (null == iAENode) return aEBooleanExpr;
        if (iAENode instanceof AEAnd) {
            return AETreeManipulator.extractFromAnd(aEBooleanExpr, (AEAnd)iAENode);
        }
        if (!(iAENode instanceof AERelationalExpr)) throw SQLEngineExceptionFactory.invalidAETreeException();
        return AETreeManipulator.extractFromRelationalExpr(aEBooleanExpr, (AERelationalExpr)iAENode);
    }

    private static AEBooleanExpr extractFromAnd(AEBooleanExpr aEBooleanExpr, AEAnd aEAnd) {
        if (null == aEAnd || null == aEBooleanExpr) {
            throw new NullPointerException("Null parameters are not allowed.");
        }
        AEBooleanExpr aEBooleanExpr2 = null;
        if (aEAnd.getLeftOperand() == aEBooleanExpr) {
            aEBooleanExpr2 = aEAnd.setLeftOperand(null);
            AETreeManipulator.extractAnd(aEAnd);
        } else {
            aEBooleanExpr2 = aEAnd.setRightOperand(null);
            AETreeManipulator.extractAnd(aEAnd);
        }
        return aEBooleanExpr2;
    }

    private static void extractAnd(AEAnd aEAnd) {
        AEBooleanExpr aEBooleanExpr = null;
        aEBooleanExpr = null == aEAnd.getLeftOperand() ? aEAnd.setRightOperand(null) : aEAnd.setLeftOperand(null);
        IAENode iAENode = aEAnd.getParent();
        if (iAENode instanceof AESelect) {
            AESelect aESelect = (AESelect)iAENode;
            aESelect.setSelectCond(aEBooleanExpr);
        } else if (iAENode instanceof AEJoin) {
            AEJoin aEJoin = (AEJoin)iAENode;
            aEJoin.setJoinCondition(aEBooleanExpr);
        } else if (iAENode instanceof AEAnd) {
            AEAnd aEAnd2 = (AEAnd)iAENode;
            if (aEAnd2.getLeftOperand() == aEAnd) {
                aEAnd2.setLeftOperand(aEBooleanExpr);
            } else {
                aEAnd2.setRightOperand(aEBooleanExpr);
            }
        } else {
            throw new IllegalStateException("Logic error: Filter push down cannot be completed: " + aEAnd + " with parent " + iAENode);
        }
    }

    private static AEBooleanExpr extractFromRelationalExpr(AEBooleanExpr aEBooleanExpr, AERelationalExpr aERelationalExpr) throws ErrorException {
        AEBooleanExpr aEBooleanExpr2 = null;
        if (PushDownType.SELECT == PushDownType.getNodeType(aERelationalExpr)) {
            AESelect aESelect = (AESelect)aERelationalExpr;
            aEBooleanExpr2 = aESelect.setSelectCond(new AEBooleanTrue());
        } else if (PushDownType.JOIN == PushDownType.getNodeType(aERelationalExpr)) {
            AEJoin aEJoin = (AEJoin)aERelationalExpr;
            aEBooleanExpr2 = aEJoin.getJoinCondition();
            aEJoin.setJoinCondition(new AEBooleanTrue());
        } else {
            throw SQLEngineExceptionFactory.invalidAETreeException();
        }
        return aEBooleanExpr2;
    }

    private static boolean subtreeContainsReference(AEBooleanExpr aEBooleanExpr, final AEBooleanExpr aEBooleanExpr2) throws ErrorException {
        return aEBooleanExpr.acceptVisitor(new AEDefaultVisitor<Boolean>(){

            @Override
            protected Boolean defaultVisit(IAENode iAENode) throws ErrorException {
                if (iAENode == aEBooleanExpr2) {
                    return true;
                }
                Iterator<? extends IAENode> iterator = iAENode.getChildItr();
                while (iterator.hasNext()) {
                    if (!iterator.next().acceptVisitor(this).booleanValue()) continue;
                    return true;
                }
                return false;
            }
        });
    }

    private static class NodeReplacer<T extends IAENode>
    extends AEDefaultVisitor<Void> {
        private final T m_replacement;
        private final T m_toReplace;

        NodeReplacer(T t, T t2) {
            this.m_replacement = t;
            this.m_toReplace = t2;
        }

        @Override
        public Void visit(AEValueExprList aEValueExprList) throws ErrorException {
            int n = aEValueExprList.findNode((AEValueExpr)this.m_toReplace);
            if (0 > n) {
                throw SQLEngineExceptionFactory.invalidAETreeException();
            }
            aEValueExprList.replaceNode((AEValueExpr)this.m_replacement, n);
            return null;
        }

        @Override
        public Void visit(AERename aERename) throws ErrorException {
            assert (aERename.getOperand() == this.m_toReplace);
            aERename.setOperand((AEValueExpr)this.m_replacement);
            return null;
        }

        @Override
        public Void visit(AENegate aENegate) throws ErrorException {
            assert (aENegate.getOperand() == this.m_toReplace);
            aENegate.setOperand((AEValueExpr)this.m_replacement);
            return null;
        }

        @Override
        public Void visit(AELikePredicate aELikePredicate) throws ErrorException {
            if (aELikePredicate.getLeftOperand() == this.m_toReplace) {
                aELikePredicate.setLeftOperand((AEValueExpr)this.m_replacement);
            } else if (aELikePredicate.getRightOperand() == this.m_toReplace) {
                aELikePredicate.setRightOperand((AEValueExpr)this.m_replacement);
            } else {
                assert (aELikePredicate.getEscapeChar() == this.m_toReplace);
                aELikePredicate.setEscape((AEValueExpr)this.m_replacement);
            }
            return null;
        }

        @Override
        public Void visit(AEAdd aEAdd) throws ErrorException {
            this.replaceFromBinaryValueExpr(aEAdd);
            return null;
        }

        @Override
        public Void visit(AEConcat aEConcat) throws ErrorException {
            this.replaceFromBinaryValueExpr(aEConcat);
            return null;
        }

        @Override
        public Void visit(AESubtract aESubtract) throws ErrorException {
            this.replaceFromBinaryValueExpr(aESubtract);
            return null;
        }

        @Override
        public Void visit(AEDivide aEDivide) throws ErrorException {
            this.replaceFromBinaryValueExpr(aEDivide);
            return null;
        }

        @Override
        public Void visit(AEMultiply aEMultiply) throws ErrorException {
            this.replaceFromBinaryValueExpr(aEMultiply);
            return null;
        }

        @Override
        public Void visit(AEGeneralAggrFn aEGeneralAggrFn) throws ErrorException {
            assert (aEGeneralAggrFn.getOperand() == this.m_toReplace);
            aEGeneralAggrFn.setOperand((AEValueExpr)this.m_replacement);
            return null;
        }

        @Override
        public Void visit(AESearchedCase aESearchedCase) throws ErrorException {
            if (aESearchedCase.getWhenClauseList() == this.m_toReplace) {
                throw new RuntimeException("Not implemented!");
            }
            assert (aESearchedCase.getElseClause() == this.m_toReplace);
            aESearchedCase.setElseClause((AEValueExpr)this.m_replacement);
            return null;
        }

        @Override
        public Void visit(AESearchedWhenClause aESearchedWhenClause) throws ErrorException {
            if (aESearchedWhenClause.getWhenCondition() == this.m_toReplace) {
                throw new RuntimeException("Not implemented!");
            }
            assert (aESearchedWhenClause.getThenExpression() == this.m_toReplace);
            aESearchedWhenClause.setThenExpression((AEValueExpr)this.m_replacement);
            return null;
        }

        @Override
        public Void visit(AESimpleCase aESimpleCase) throws ErrorException {
            if (aESimpleCase.getCaseOperand() == this.m_toReplace) {
                aESimpleCase.setCaseOperand((AEValueExpr)this.m_replacement);
            } else {
                if (aESimpleCase.getWhenClauseList() == this.m_toReplace) {
                    throw new RuntimeException("Not implemented!");
                }
                assert (aESimpleCase.getElseOperand() == this.m_toReplace);
                aESimpleCase.setElseOperand((AEValueExpr)this.m_replacement);
            }
            return null;
        }

        @Override
        public Void visit(AESimpleWhenClause aESimpleWhenClause) throws ErrorException {
            if (aESimpleWhenClause.getWhenExpression() == this.m_toReplace) {
                aESimpleWhenClause.setWhenExpression((AEValueExpr)this.m_replacement);
            } else {
                assert (aESimpleWhenClause.getThenExpression() == this.m_toReplace);
                aESimpleWhenClause.setThenExpression((AEValueExpr)this.m_replacement);
            }
            return null;
        }

        @Override
        public Void visit(AESetClause aESetClause) throws ErrorException {
            if (aESetClause.getLeftOperand() == this.m_toReplace) {
                throw new RuntimeException("Not implemented!");
            }
            assert (aESetClause.getRightOperand() == this.m_toReplace);
            aESetClause.setRightOperand((AEValueExpr)this.m_replacement);
            return null;
        }

        @Override
        public Void visit(AEValueAsBooleanExpr aEValueAsBooleanExpr) throws ErrorException {
            throw new RuntimeException("Not implemented!");
        }

        @Override
        public Void visit(AEBooleanValueExpr aEBooleanValueExpr) throws ErrorException {
            throw new RuntimeException("Not implemented!");
        }

        @Override
        public Void visit(AEProject aEProject) throws ErrorException {
            if (aEProject.getProjectionList() == this.m_toReplace) {
                throw new RuntimeException("Not implemented!");
            }
            assert (aEProject.getOperand() == this.m_toReplace);
            aEProject.setOperand((AERelationalExpr)this.m_replacement);
            return null;
        }

        @Override
        public Void visit(AEColumnReference aEColumnReference) throws ErrorException {
            throw new RuntimeException("Not implemented!");
        }

        @Override
        public Void visit(AETable aETable) throws ErrorException {
            throw new RuntimeException("Not implemented!");
        }

        @Override
        public Void visit(AEDummyTable aEDummyTable) throws ErrorException {
            throw new RuntimeException("Not implemented!");
        }

        @Override
        public Void visit(AEQuery aEQuery) throws ErrorException {
            assert (aEQuery.getOperand() == this.m_toReplace);
            aEQuery.setOperand((AERelationalExpr)this.m_replacement);
            return null;
        }

        @Override
        public Void visit(AEScalarFn aEScalarFn) throws ErrorException {
            assert (aEScalarFn.getArguments() == this.m_toReplace);
            throw new RuntimeException("Not implemented!");
        }

        @Override
        public Void visit(AECastFn aECastFn) throws ErrorException {
            return this.visit((AEScalarFn)aECastFn);
        }

        @Override
        public Void visit(AESelect aESelect) throws ErrorException {
            if (aESelect.getCondition() == this.m_toReplace) {
                aESelect.setSelectCond((AEBooleanExpr)this.m_replacement);
            }
            assert (aESelect.getOperand() == this.m_toReplace);
            aESelect.setOperand((AERelationalExpr)this.m_replacement);
            return null;
        }

        @Override
        public Void visit(AEAnd aEAnd) throws ErrorException {
            if (aEAnd.getLeftOperand() == this.m_toReplace) {
                aEAnd.setLeftOperand((AEBooleanExpr)this.m_replacement);
            }
            assert (aEAnd.getRightOperand() == this.m_toReplace);
            aEAnd.setRightOperand((AEBooleanExpr)this.m_replacement);
            return null;
        }

        @Override
        public Void visit(AEOr aEOr) throws ErrorException {
            if (aEOr.getLeftOperand() == this.m_toReplace) {
                aEOr.setLeftOperand((AEBooleanExpr)this.m_replacement);
            }
            assert (aEOr.getRightOperand() == this.m_toReplace);
            aEOr.setRightOperand((AEBooleanExpr)this.m_replacement);
            return null;
        }

        @Override
        public Void visit(AENot aENot) throws ErrorException {
            assert (aENot.getOperand() == this.m_toReplace);
            aENot.setOperand((AEBooleanExpr)this.m_replacement);
            return null;
        }

        @Override
        public Void visit(AEComparison aEComparison) throws ErrorException {
            throw new RuntimeException("Not implemented!");
        }

        @Override
        public Void visit(AELiteral aELiteral) throws ErrorException {
            throw new RuntimeException("Not implemented!");
        }

        @Override
        public Void visit(AENull aENull) throws ErrorException {
            throw new RuntimeException("Not implemented!");
        }

        @Override
        public Void visit(AETop aETop) throws ErrorException {
            this.replaceFromUnaryRelExpr(aETop);
            return null;
        }

        @Override
        public Void visit(AESort aESort) throws ErrorException {
            this.replaceFromUnaryRelExpr(aESort);
            return null;
        }

        @Override
        public Void visit(AEInPredicate aEInPredicate) throws ErrorException {
            if (aEInPredicate.getLeftOperand() == this.m_toReplace) {
                throw new RuntimeException("Not implemented!");
            }
            assert (aEInPredicate.getRightOperand() == this.m_toReplace);
            aEInPredicate.setRightOperand((AERelationalExpr)this.m_replacement);
            return null;
        }

        @Override
        public Void visit(AENullPredicate aENullPredicate) throws ErrorException {
            assert (aENullPredicate.getOperand() == this.m_toReplace);
            throw new RuntimeException("Not implemented!");
        }

        @Override
        public Void visit(AECrossJoin aECrossJoin) throws ErrorException {
            this.replaceFromBinaryRelExpr(aECrossJoin);
            return null;
        }

        @Override
        public Void visit(AEJoin aEJoin) throws ErrorException {
            this.replaceFromBinaryRelExpr(aEJoin);
            return null;
        }

        @Override
        public Void visit(AEBooleanTrue aEBooleanTrue) throws ErrorException {
            throw new RuntimeException("Not implemented!");
        }

        @Override
        public Void visit(AEParameter aEParameter) throws ErrorException {
            throw new RuntimeException("Not implemented!");
        }

        @Override
        public Void visit(AEDefaultParameter aEDefaultParameter) throws ErrorException {
            throw new RuntimeException("Not implemented!");
        }

        @Override
        public Void visit(AEDistinct aEDistinct) throws ErrorException {
            this.replaceFromUnaryRelExpr(aEDistinct);
            return null;
        }

        @Override
        public Void visit(AEProxyColumn aEProxyColumn) throws ErrorException {
            throw new RuntimeException("Not implemented!");
        }

        @Override
        public Void visit(AEAggregate aEAggregate) throws ErrorException {
            if (aEAggregate.getOperand() != this.m_toReplace) {
                if (aEAggregate.getAggregationList() == this.m_toReplace) {
                    throw new RuntimeException("Not implemented!");
                }
                assert (aEAggregate.getGroupingList() == this.m_toReplace);
                throw new RuntimeException("Not implemented!");
            }
            aEAggregate.setOperand((AERelationalExpr)this.m_replacement);
            return null;
        }

        @Override
        public Void visit(AECountStarAggrFn aECountStarAggrFn) throws ErrorException {
            throw new RuntimeException("Not implemented!");
        }

        @Override
        public Void visit(AENodeList<? extends IAENode> aENodeList) throws ErrorException {
            throw new RuntimeException("Not implemented!");
        }

        @Override
        public Void visit(AESubQuery aESubQuery) throws ErrorException {
            assert (aESubQuery.getOperand() == this.m_toReplace);
            aESubQuery.setOperand((AERelationalExpr)this.m_replacement);
            return null;
        }

        @Override
        public Void visit(AEExistsPredicate aEExistsPredicate) throws ErrorException {
            assert (aEExistsPredicate.getOperand() == this.m_toReplace);
            aEExistsPredicate.setOperand((AERelationalExpr)this.m_replacement);
            return null;
        }

        @Override
        public Void visit(AEQuantifiedComparison aEQuantifiedComparison) throws ErrorException {
            if (aEQuantifiedComparison.getLeftOperand() == this.m_toReplace) {
                throw new RuntimeException("Not implemented!");
            }
            assert (aEQuantifiedComparison.getRightOperand() == this.m_toReplace);
            aEQuantifiedComparison.setRightOperand((AERelationalExpr)this.m_replacement);
            return null;
        }

        @Override
        public Void visit(AEValueSubQuery aEValueSubQuery) throws ErrorException {
            assert (aEValueSubQuery.getQueryExpression() == this.m_toReplace);
            aEValueSubQuery.setQueryExpression((AERelationalExpr)this.m_replacement);
            return null;
        }

        @Override
        public Void visit(AEUpdate aEUpdate) throws ErrorException {
            if (aEUpdate.getTable() == this.m_toReplace) {
                aEUpdate.setTable((AETable)this.m_replacement);
            } else {
                if (aEUpdate.getSetClauses() == this.m_toReplace) {
                    throw new RuntimeException("Not implemented!");
                }
                assert (aEUpdate.getUpdateCondition() == this.m_toReplace);
                aEUpdate.setUpdateCondition((AEBooleanExpr)this.m_replacement);
            }
            return null;
        }

        @Override
        public Void visit(AEInsert aEInsert) throws ErrorException {
            if (aEInsert.getTable() == this.m_toReplace) {
                throw new RuntimeException("Not implemented!");
            }
            if (aEInsert.getInsertColumns() == this.m_toReplace) {
                throw new RuntimeException("Not implemented!");
            }
            assert (aEInsert.getRelationalExpr() == this.m_toReplace);
            aEInsert.setRelationalExpr((AERelationalExpr)this.m_toReplace);
            return null;
        }

        @Override
        public Void visit(AEInsertDefaults aEInsertDefaults) throws ErrorException {
            assert (aEInsertDefaults.getTable() == this.m_toReplace);
            throw new RuntimeException("Not implemented!");
        }

        @Override
        public Void visit(AEDelete aEDelete) throws ErrorException {
            if (aEDelete.getTable() == this.m_toReplace) {
                aEDelete.setTable((AETable)this.m_replacement);
            } else {
                assert (aEDelete.getCondition() == this.m_toReplace);
                aEDelete.setCondition((AEBooleanExpr)this.m_replacement);
            }
            return null;
        }

        @Override
        public Void visit(AESetClauseList aESetClauseList) throws ErrorException {
            throw new RuntimeException("Not implemented!");
        }

        @Override
        public Void visit(AETableConstructor aETableConstructor) throws ErrorException {
            throw new RuntimeException("Not implemented!");
        }

        @Override
        public Void visit(AEDefault aEDefault) throws ErrorException {
            throw new RuntimeException("Not implemented!");
        }

        @Override
        public Void visit(AEUnion aEUnion) throws ErrorException {
            this.replaceFromBinaryRelExpr(aEUnion);
            return null;
        }

        @Override
        public Void visit(AECreateTable aECreateTable) throws ErrorException {
            throw new RuntimeException("Not implemented!");
        }

        @Override
        public Void visit(AEDropTable aEDropTable) throws ErrorException {
            throw new RuntimeException("Not implemented!");
        }

        @Override
        public Void visit(AECustomScalarFn aECustomScalarFn) throws ErrorException {
            assert (aECustomScalarFn.getArguments() == this.m_toReplace);
            throw new RuntimeException("Not implemented!");
        }

        @Override
        public Void visit(AEExcept aEExcept) throws ErrorException {
            this.replaceFromBinaryRelExpr(aEExcept);
            return null;
        }

        @Override
        public Void visit(AEProcedure aEProcedure) throws ErrorException {
            throw new RuntimeException("Not implemented!");
        }

        @Override
        public Void visit(AEProcedureCall aEProcedureCall) throws ErrorException {
            throw new RuntimeException("Not implemented!");
        }

        @Override
        public Void visit(AEStatements aEStatements) throws ErrorException {
            throw new RuntimeException("Not implemented!");
        }

        @Override
        public Void visit(AEWithClause aEWithClause) throws ErrorException {
            for (int i = 0; i < aEWithClause.getNumChildren(); ++i) {
                if (aEWithClause.getChild(i) != this.m_toReplace) continue;
                aEWithClause.replaceNode((AENamedRelationalExpr)this.m_replacement, i);
                return null;
            }
            throw new RuntimeException("Node to replace not found!");
        }

        @Override
        public Void visit(AECommonTableExprScope aECommonTableExprScope) throws ErrorException {
            if (aECommonTableExprScope.getLeftOperand() == this.m_toReplace) {
                throw new RuntimeException("Not implemented!");
            }
            assert (aECommonTableExprScope.getRightOperand() == this.m_toReplace);
            aECommonTableExprScope.setRightOperand((AERelationalExpr)this.m_replacement);
            return null;
        }

        @Override
        public Void visit(AECommonTableExpr aECommonTableExpr) throws ErrorException {
            throw new RuntimeException("Not implemented!");
        }

        @Override
        protected Void defaultVisit(IAENode iAENode) throws ErrorException {
            throw SQLEngineExceptionFactory.invalidAETreeException();
        }

        private void replaceFromBinaryValueExpr(AEBinaryValueExpr aEBinaryValueExpr) {
            if (aEBinaryValueExpr.getLeftOperand() == this.m_toReplace) {
                aEBinaryValueExpr.setLeftOperand((AEValueExpr)this.m_replacement);
            } else {
                assert (aEBinaryValueExpr.getRightOperand() == this.m_toReplace);
                aEBinaryValueExpr.setRightOperand((AEValueExpr)this.m_replacement);
            }
        }

        private void replaceFromUnaryRelExpr(AEUnaryRelationalExpr aEUnaryRelationalExpr) {
            assert (aEUnaryRelationalExpr.getOperand() == this.m_toReplace);
            aEUnaryRelationalExpr.setOperand((AERelationalExpr)this.m_replacement);
        }

        private void replaceFromBinaryRelExpr(AEBinaryRelationalExpr aEBinaryRelationalExpr) {
            if (aEBinaryRelationalExpr.getLeftOperand() == this.m_toReplace) {
                aEBinaryRelationalExpr.setLeftOperand((AERelationalExpr)this.m_replacement);
            } else {
                assert (aEBinaryRelationalExpr.getRightOperand() == this.m_toReplace);
                aEBinaryRelationalExpr.setRightOperand((AERelationalExpr)this.m_replacement);
            }
        }
    }

    private static enum PushDownType {
        JOIN,
        CROSSJOIN,
        SELECT,
        PROJECT,
        TABLE,
        TABLE_SUBQUERY,
        COMMON_TABLE_EXPRESSION_SCOPE;


        public static PushDownType getNodeType(IAENode iAENode) throws ErrorException {
            if (iAENode instanceof AEJoin) {
                return JOIN;
            }
            if (iAENode instanceof AECrossJoin) {
                return CROSSJOIN;
            }
            if (iAENode instanceof AESelect) {
                return SELECT;
            }
            if (iAENode instanceof AEProject) {
                return PROJECT;
            }
            if (iAENode instanceof AETable) {
                return TABLE;
            }
            if (iAENode instanceof AESubQuery) {
                return TABLE_SUBQUERY;
            }
            if (iAENode instanceof AECommonTableExprScope) {
                return COMMON_TABLE_EXPRESSION_SCOPE;
            }
            throw SQLEngineExceptionFactory.featureNotImplementedException("Attempt to push down filter on unknown node type: " + iAENode.getClass().getName());
        }
    }
}

