/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.dsi.core.utilities.impl.future;

import com.databricks.client.dsi.core.utilities.impl.future.ConversionConfig;
import com.databricks.client.dsi.core.utilities.impl.future.TimestampJDBCDataSink;
import com.databricks.client.dsi.dataengine.interfaces.future.ISqlDataSink;
import com.databricks.client.dsi.dataengine.utilities.TypeMetadata;
import com.databricks.client.dsi.exceptions.ConversionFailed;
import com.databricks.client.dsi.exceptions.IncorrectTypeException;
import com.databricks.client.dsi.utilities.CalendarSetter;
import com.databricks.client.support.IWarningListener;
import com.databricks.client.support.exceptions.ErrorException;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Objects;

public class TimestampJDBCDataSinkAdapter
extends TimestampJDBCDataSink {
    private final ISqlDataSink m_wrapped;

    public TimestampJDBCDataSinkAdapter(ISqlDataSink iSqlDataSink, TypeMetadata typeMetadata, IWarningListener iWarningListener, ConversionConfig conversionConfig) {
        super(iWarningListener, typeMetadata, conversionConfig);
        this.m_wrapped = Objects.requireNonNull(iSqlDataSink);
    }

    protected final ISqlDataSink getWrapped() {
        return this.m_wrapped;
    }

    @Override
    protected void doSet(Timestamp timestamp, Calendar calendar) throws ErrorException {
        try {
            this.m_wrapped.set(timestamp == null ? null : CalendarSetter.getTimestamp(timestamp, calendar));
        }
        catch (IncorrectTypeException incorrectTypeException) {
            throw new RuntimeException("Should never happen!", incorrectTypeException);
        }
        catch (ConversionFailed conversionFailed) {
            throw new RuntimeException("Should never happen!", conversionFailed);
        }
    }
}

