/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.dsi.core.utilities.impl.future;

import com.databricks.client.dsi.core.utilities.future.NonTrivialJDBCConversions;
import com.databricks.client.dsi.core.utilities.impl.future.ConversionConfig;
import com.databricks.client.dsi.core.utilities.impl.future.ConvertingJDBCDataSink;
import com.databricks.client.dsi.exceptions.ConversionFailed;
import com.databricks.client.dsi.exceptions.IncorrectTypeException;
import com.databricks.client.dsi.exceptions.future.UnsupportedException;
import com.databricks.client.support.IWarningListener;
import com.databricks.client.support.exceptions.ErrorException;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Calendar;

public abstract class LocalDateJDBCDataSink
extends ConvertingJDBCDataSink {
    public LocalDateJDBCDataSink(IWarningListener iWarningListener, ConversionConfig conversionConfig) {
        super(iWarningListener, conversionConfig);
    }

    protected final void handleConversionResult(Object object, String string) throws ConversionFailed {
        switch (this.getListener().getStatus()) {
            case SUCCESS: {
                break;
            }
            case FRACTIONAL_TRUNCATION: {
                this.onFractionalTruncation(object, 0, string);
                break;
            }
            case OVERFLOW: {
                this.onOverflow(object, string);
            }
        }
    }

    protected abstract void doSet(LocalDate var1) throws ErrorException;

    @Override
    public void set(Object object) throws IncorrectTypeException, ErrorException {
        if (object == null || object instanceof LocalDate) {
            this.doSet((LocalDate)object);
        } else if (object instanceof Date) {
            this.doSet(NonTrivialJDBCConversions.sqlDateToLocalDate((Date)object));
        } else {
            throw new IncorrectTypeException();
        }
    }

    @Override
    public void setNull(int n) throws IncorrectTypeException, ConversionFailed, SQLException, ErrorException {
        switch (n) {
            case -10: 
            case -9: 
            case -8: 
            case -1: 
            case 0: 
            case 1: 
            case 12: 
            case 91: 
            case 93: 
            case 2000: {
                this.doSet(null);
                break;
            }
            default: {
                throw new IncorrectTypeException();
            }
        }
    }

    @Override
    public void setString(String string) throws IncorrectTypeException, ConversionFailed, SQLException, ErrorException {
        if (string == null) {
            this.setNull(1);
        } else {
            LocalDate localDate = NonTrivialJDBCConversions.stringToLocalDate(string, this.getAndClearListener());
            this.handleConversionResult(string, "setString");
            this.doSet(localDate);
        }
    }

    @Override
    public void setDate(Date date, Calendar calendar) throws IncorrectTypeException, ConversionFailed, SQLException, ErrorException {
        this.doSet(date == null ? null : NonTrivialJDBCConversions.sqlDateToLocalDate(date));
    }

    @Override
    public void setTimestamp(Timestamp timestamp, Calendar calendar) throws IncorrectTypeException, ConversionFailed, SQLException, ErrorException {
        if (timestamp == null) {
            this.doSet(null);
            return;
        }
        LocalDateTime localDateTime = NonTrivialJDBCConversions.timestampToLocalDateTime(timestamp);
        if (calendar != null) {
            localDateTime = ZonedDateTime.of(localDateTime, calendar.getTimeZone().toZoneId()).withZoneSameInstant(ZoneId.systemDefault()).toLocalDateTime();
        }
        LocalDate localDate = NonTrivialJDBCConversions.localDateTimeToLocalDate(localDateTime, this.getAndClearListener());
        this.handleConversionResult(timestamp, "setTimestamp");
        this.doSet(localDate);
    }

    @Override
    protected void setLocalDate(LocalDate localDate) throws IncorrectTypeException, ConversionFailed, SQLException, ErrorException, UnsupportedException {
        this.doSet(localDate);
    }

    @Override
    protected void setLocalDateTime(LocalDateTime localDateTime) throws IncorrectTypeException, ConversionFailed, SQLException, ErrorException, UnsupportedException {
        LocalDate localDate = NonTrivialJDBCConversions.localDateTimeToLocalDate(localDateTime, this.getAndClearListener());
        this.handleConversionResult(localDateTime, "setObject");
        this.doSet(localDate);
    }
}

