/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.sqlengine.parser;

import com.databricks.client.sqlengine.exceptions.SQLEngineException;
import com.databricks.client.sqlengine.parser.DefaultLimitChecker;
import com.databricks.client.sqlengine.parser.IPTLimitChecker;
import com.databricks.client.sqlengine.parser.generated.YYParser;
import com.databricks.client.sqlengine.parser.parsetree.IPTNode;
import com.databricks.client.sqlengine.parser.type.PTStringConstraint;

public class PTParser {
    private PTParser() {
        throw new UnsupportedOperationException("Not instantiable");
    }

    public static IPTNode parse(String string) throws SQLEngineException {
        return PTParser.parse(string, new DefaultLimitChecker());
    }

    public static IPTNode parse(String string, IPTLimitChecker iPTLimitChecker) throws SQLEngineException {
        if (null == string) {
            throw new NullPointerException("sqlStatement must not be null");
        }
        if (null == iPTLimitChecker) {
            throw new NullPointerException("limitChecker must not be null");
        }
        iPTLimitChecker.checkString(PTStringConstraint.STATEMENT_LEN, string);
        return YYParser.doParse(string, iPTLimitChecker);
    }
}

