/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.sqlengine.dsiext.dataengine.metadata;

import com.databricks.client.dsi.core.impl.DSIDriver;
import com.databricks.client.dsi.dataengine.filters.IFilter;
import com.databricks.client.dsi.dataengine.utilities.DSITypeUtilities;
import com.databricks.client.dsi.dataengine.utilities.DataWrapper;
import com.databricks.client.dsi.dataengine.utilities.MetadataSourceColumnTag;
import com.databricks.client.dsi.utilities.DSIMessageKey;
import com.databricks.client.sqlengine.dsiext.dataengine.IMetadataHelper;
import com.databricks.client.sqlengine.dsiext.dataengine.Identifier;
import com.databricks.client.sqlengine.dsiext.dataengine.metadata.DSIExtPartiallyFilteredMetadataSource;
import com.databricks.client.support.ILogger;
import com.databricks.client.support.LogUtilities;
import com.databricks.client.support.exceptions.ErrorException;
import java.util.List;
import java.util.Map;

public class DSIExtTablesMetadataSource
extends DSIExtPartiallyFilteredMetadataSource {
    private final ILogger m_logger;
    private Identifier m_curRow = null;

    @Deprecated
    public DSIExtTablesMetadataSource(ILogger iLogger, Map<MetadataSourceColumnTag, String> map, IMetadataHelper iMetadataHelper, boolean bl) {
        super(map, iMetadataHelper, MetadataSourceColumnTag.TABLE_NAME, bl);
        this.m_logger = iLogger;
    }

    public DSIExtTablesMetadataSource(ILogger iLogger, IMetadataHelper iMetadataHelper, boolean bl, List<IFilter> list) {
        super(iMetadataHelper, MetadataSourceColumnTag.TABLE_NAME, bl, list);
        this.m_logger = iLogger;
    }

    @Override
    public void close() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
    }

    @Override
    public void closeCursor() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
    }

    @Override
    public boolean getMetadata(MetadataSourceColumnTag metadataSourceColumnTag, long l, long l2, DataWrapper dataWrapper) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[]{metadataSourceColumnTag, l, l2});
        switch (metadataSourceColumnTag) {
            case CATALOG_NAME: {
                return DSITypeUtilities.outputVarCharStringData(this.m_curRow.getCatalog(), dataWrapper, l, l2);
            }
            case SCHEMA_NAME: {
                return DSITypeUtilities.outputVarCharStringData(this.m_curRow.getSchema(), dataWrapper, l, l2);
            }
            case TABLE_NAME: {
                return DSITypeUtilities.outputVarCharStringData(this.m_curRow.getName(), dataWrapper, l, l2);
            }
            case TABLE_TYPE: {
                return DSITypeUtilities.outputVarCharStringData("TABLE", dataWrapper, l, l2);
            }
            case REMARKS: {
                return DSITypeUtilities.outputVarCharStringData("", dataWrapper, l, l2);
            }
        }
        throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.INVALID_METADATA_COLUMN_TAG.name(), metadataSourceColumnTag.name());
    }

    @Override
    public boolean hasMoreRows() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        return this.hasNextProcedureOrTable();
    }

    @Override
    public boolean moveToNextRow() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        this.m_curRow = this.getNextProcedureOrTable();
        return this.m_curRow != null;
    }

    protected Identifier getCurrentTable() {
        return this.m_curRow;
    }
}

