/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.jdbc42.internal.apache.logging.log4j.core.layout;

import com.databricks.client.jdbc42.internal.apache.logging.log4j.Logger;
import com.databricks.client.jdbc42.internal.apache.logging.log4j.core.Layout;
import com.databricks.client.jdbc42.internal.apache.logging.log4j.core.LogEvent;
import com.databricks.client.jdbc42.internal.apache.logging.log4j.core.config.Configuration;
import com.databricks.client.jdbc42.internal.apache.logging.log4j.core.config.plugins.PluginBuilderAttribute;
import com.databricks.client.jdbc42.internal.apache.logging.log4j.core.config.plugins.PluginConfiguration;
import com.databricks.client.jdbc42.internal.apache.logging.log4j.core.layout.ByteBufferDestination;
import com.databricks.client.jdbc42.internal.apache.logging.log4j.status.StatusLogger;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractLayout<T extends Serializable>
implements Layout<T> {
    protected static final Logger LOGGER = StatusLogger.getLogger();
    protected final Configuration configuration;
    protected long eventCount;
    protected final byte[] footer;
    protected final byte[] header;

    @Deprecated
    public AbstractLayout(byte[] header, byte[] footer) {
        this(null, header, footer);
    }

    public AbstractLayout(Configuration configuration, byte[] header, byte[] footer) {
        this.configuration = configuration;
        this.header = header;
        this.footer = footer;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    @Override
    public Map<String, String> getContentFormat() {
        return new HashMap<String, String>();
    }

    @Override
    public byte[] getFooter() {
        return this.footer;
    }

    @Override
    public byte[] getHeader() {
        return this.header;
    }

    protected void markEvent() {
        ++this.eventCount;
    }

    @Override
    public void encode(LogEvent event, ByteBufferDestination destination) {
        byte[] data = this.toByteArray(event);
        destination.writeBytes(data, 0, data.length);
    }

    public static abstract class Builder<B extends Builder<B>> {
        @PluginConfiguration
        private Configuration configuration;
        @PluginBuilderAttribute
        private byte[] footer;
        @PluginBuilderAttribute
        private byte[] header;

        public B asBuilder() {
            return (B)this;
        }

        public Configuration getConfiguration() {
            return this.configuration;
        }

        public byte[] getFooter() {
            return this.footer;
        }

        public byte[] getHeader() {
            return this.header;
        }

        public B setConfiguration(Configuration configuration) {
            this.configuration = configuration;
            return this.asBuilder();
        }

        public B setFooter(byte[] footer) {
            this.footer = footer;
            return this.asBuilder();
        }

        public B setHeader(byte[] header) {
            this.header = header;
            return this.asBuilder();
        }
    }
}

