/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.jdbc42.internal.apache.http.impl.execchain;

import com.databricks.client.jdbc42.internal.apache.commons.logging.Log;
import com.databricks.client.jdbc42.internal.apache.commons.logging.LogFactory;
import com.databricks.client.jdbc42.internal.apache.http.ConnectionReuseStrategy;
import com.databricks.client.jdbc42.internal.apache.http.HttpClientConnection;
import com.databricks.client.jdbc42.internal.apache.http.HttpEntity;
import com.databricks.client.jdbc42.internal.apache.http.HttpException;
import com.databricks.client.jdbc42.internal.apache.http.HttpHost;
import com.databricks.client.jdbc42.internal.apache.http.HttpRequest;
import com.databricks.client.jdbc42.internal.apache.http.HttpResponse;
import com.databricks.client.jdbc42.internal.apache.http.ProtocolException;
import com.databricks.client.jdbc42.internal.apache.http.annotation.Contract;
import com.databricks.client.jdbc42.internal.apache.http.annotation.ThreadingBehavior;
import com.databricks.client.jdbc42.internal.apache.http.client.config.RequestConfig;
import com.databricks.client.jdbc42.internal.apache.http.client.methods.CloseableHttpResponse;
import com.databricks.client.jdbc42.internal.apache.http.client.methods.HttpExecutionAware;
import com.databricks.client.jdbc42.internal.apache.http.client.methods.HttpRequestWrapper;
import com.databricks.client.jdbc42.internal.apache.http.client.methods.HttpUriRequest;
import com.databricks.client.jdbc42.internal.apache.http.client.protocol.HttpClientContext;
import com.databricks.client.jdbc42.internal.apache.http.client.protocol.RequestClientConnControl;
import com.databricks.client.jdbc42.internal.apache.http.client.utils.URIUtils;
import com.databricks.client.jdbc42.internal.apache.http.conn.ConnectionKeepAliveStrategy;
import com.databricks.client.jdbc42.internal.apache.http.conn.ConnectionRequest;
import com.databricks.client.jdbc42.internal.apache.http.conn.HttpClientConnectionManager;
import com.databricks.client.jdbc42.internal.apache.http.conn.routing.HttpRoute;
import com.databricks.client.jdbc42.internal.apache.http.impl.conn.ConnectionShutdownException;
import com.databricks.client.jdbc42.internal.apache.http.impl.execchain.ClientExecChain;
import com.databricks.client.jdbc42.internal.apache.http.impl.execchain.ConnectionHolder;
import com.databricks.client.jdbc42.internal.apache.http.impl.execchain.HttpResponseProxy;
import com.databricks.client.jdbc42.internal.apache.http.impl.execchain.RequestAbortedException;
import com.databricks.client.jdbc42.internal.apache.http.protocol.HttpContext;
import com.databricks.client.jdbc42.internal.apache.http.protocol.HttpProcessor;
import com.databricks.client.jdbc42.internal.apache.http.protocol.HttpRequestExecutor;
import com.databricks.client.jdbc42.internal.apache.http.protocol.ImmutableHttpProcessor;
import com.databricks.client.jdbc42.internal.apache.http.protocol.RequestContent;
import com.databricks.client.jdbc42.internal.apache.http.protocol.RequestTargetHost;
import com.databricks.client.jdbc42.internal.apache.http.protocol.RequestUserAgent;
import com.databricks.client.jdbc42.internal.apache.http.util.Args;
import com.databricks.client.jdbc42.internal.apache.http.util.VersionInfo;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class MinimalClientExec
implements ClientExecChain {
    private final Log log = LogFactory.getLog(this.getClass());
    private final HttpRequestExecutor requestExecutor;
    private final HttpClientConnectionManager connManager;
    private final ConnectionReuseStrategy reuseStrategy;
    private final ConnectionKeepAliveStrategy keepAliveStrategy;
    private final HttpProcessor httpProcessor;

    public MinimalClientExec(HttpRequestExecutor requestExecutor, HttpClientConnectionManager connManager, ConnectionReuseStrategy reuseStrategy, ConnectionKeepAliveStrategy keepAliveStrategy) {
        Args.notNull(requestExecutor, "HTTP request executor");
        Args.notNull(connManager, "Client connection manager");
        Args.notNull(reuseStrategy, "Connection reuse strategy");
        Args.notNull(keepAliveStrategy, "Connection keep alive strategy");
        this.httpProcessor = new ImmutableHttpProcessor(new RequestContent(), new RequestTargetHost(), new RequestClientConnControl(), new RequestUserAgent(VersionInfo.getUserAgent("Apache-HttpClient", "com.databricks.client.jdbc42.internal.apache.http.client", this.getClass())));
        this.requestExecutor = requestExecutor;
        this.connManager = connManager;
        this.reuseStrategy = reuseStrategy;
        this.keepAliveStrategy = keepAliveStrategy;
    }

    static void rewriteRequestURI(HttpRequestWrapper request, HttpRoute route, boolean normalizeUri) throws ProtocolException {
        try {
            URI uri = request.getURI();
            if (uri != null) {
                uri = uri.isAbsolute() ? URIUtils.rewriteURI(uri, null, normalizeUri ? URIUtils.DROP_FRAGMENT_AND_NORMALIZE : URIUtils.DROP_FRAGMENT) : URIUtils.rewriteURI(uri);
                request.setURI(uri);
            }
        }
        catch (URISyntaxException ex) {
            throw new ProtocolException("Invalid URI: " + request.getRequestLine().getUri(), ex);
        }
    }

    @Override
    public CloseableHttpResponse execute(HttpRoute route, HttpRequestWrapper request, HttpClientContext context, HttpExecutionAware execAware) throws IOException, HttpException {
        HttpClientConnection managedConn;
        Args.notNull(route, "HTTP route");
        Args.notNull(request, "HTTP request");
        Args.notNull(context, "HTTP context");
        MinimalClientExec.rewriteRequestURI(request, route, context.getRequestConfig().isNormalizeUri());
        ConnectionRequest connRequest = this.connManager.requestConnection(route, null);
        if (execAware != null) {
            if (execAware.isAborted()) {
                connRequest.cancel();
                throw new RequestAbortedException("Request aborted");
            }
            execAware.setCancellable(connRequest);
        }
        RequestConfig config = context.getRequestConfig();
        try {
            int timeout = config.getConnectionRequestTimeout();
            managedConn = connRequest.get(timeout > 0 ? (long)timeout : 0L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interrupted) {
            Thread.currentThread().interrupt();
            throw new RequestAbortedException("Request aborted", interrupted);
        }
        catch (ExecutionException ex) {
            Throwable cause = ex.getCause();
            if (cause == null) {
                cause = ex;
            }
            throw new RequestAbortedException("Request execution failed", cause);
        }
        ConnectionHolder releaseTrigger = new ConnectionHolder(this.log, this.connManager, managedConn);
        try {
            URI uri;
            int timeout;
            if (execAware != null) {
                if (execAware.isAborted()) {
                    releaseTrigger.close();
                    throw new RequestAbortedException("Request aborted");
                }
                execAware.setCancellable(releaseTrigger);
            }
            if (!managedConn.isOpen()) {
                timeout = config.getConnectTimeout();
                this.connManager.connect(managedConn, route, timeout > 0 ? timeout : 0, context);
                this.connManager.routeComplete(managedConn, route, context);
            }
            if ((timeout = config.getSocketTimeout()) >= 0) {
                managedConn.setSocketTimeout(timeout);
            }
            HttpHost target = null;
            HttpRequest original = request.getOriginal();
            if (original instanceof HttpUriRequest && (uri = ((HttpUriRequest)original).getURI()).isAbsolute()) {
                target = new HttpHost(uri.getHost(), uri.getPort(), uri.getScheme());
            }
            if (target == null) {
                target = route.getTargetHost();
            }
            context.setAttribute("http.target_host", target);
            context.setAttribute("http.request", request);
            context.setAttribute("http.connection", managedConn);
            context.setAttribute("http.route", route);
            this.httpProcessor.process(request, (HttpContext)context);
            HttpResponse response = this.requestExecutor.execute(request, managedConn, context);
            this.httpProcessor.process(response, (HttpContext)context);
            if (this.reuseStrategy.keepAlive(response, context)) {
                long duration = this.keepAliveStrategy.getKeepAliveDuration(response, context);
                releaseTrigger.setValidFor(duration, TimeUnit.MILLISECONDS);
                releaseTrigger.markReusable();
            } else {
                releaseTrigger.markNonReusable();
            }
            HttpEntity entity = response.getEntity();
            if (entity == null || !entity.isStreaming()) {
                releaseTrigger.releaseConnection();
                return new HttpResponseProxy(response, null);
            }
            return new HttpResponseProxy(response, releaseTrigger);
        }
        catch (ConnectionShutdownException ex) {
            InterruptedIOException ioex = new InterruptedIOException("Connection has been shut down");
            ioex.initCause(ex);
            throw ioex;
        }
        catch (HttpException ex) {
            releaseTrigger.abortConnection();
            throw ex;
        }
        catch (IOException ex) {
            releaseTrigger.abortConnection();
            throw ex;
        }
        catch (RuntimeException ex) {
            releaseTrigger.abortConnection();
            throw ex;
        }
        catch (Error error) {
            this.connManager.shutdown();
            throw error;
        }
    }
}

