/*
 * Decompiled with CFR 0.152.
 */
package com.darwin.viola.still;

import android.graphics.Bitmap;
import android.graphics.PointF;
import com.darwin.viola.age.AgeRecognition;
import com.darwin.viola.age.ViolaAgeClassifier;
import com.darwin.viola.still.FaceAnalyser$WhenMappings;
import com.darwin.viola.still.MathExtensionKt;
import com.darwin.viola.still.Util;
import com.darwin.viola.still.Viola;
import com.darwin.viola.still.model.CropAlgorithm;
import com.darwin.viola.still.model.FaceOptions;
import com.darwin.viola.still.model.FacePortrait;
import com.darwin.viola.still.model.FacePose;
import com.google.mlkit.vision.face.Face;
import com.google.mlkit.vision.face.FaceLandmark;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J,\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J*\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\u00072\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ(\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0010H\u0002J,\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00100\u00162\u0006\u0010\u0017\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J$\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00100\u00162\u0006\u0010\u0017\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001cH\u0002J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\t\u001a\u00020\nH\u0002J \u0010 \u001a\u00020\u001c2\u0006\u0010!\u001a\u00020\u001c2\u0006\u0010\"\u001a\u00020\u001c2\u0006\u0010\t\u001a\u00020\nH\u0002J \u0010#\u001a\u00020\u001c2\u0006\u0010\u0017\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u001a\u0010$\u001a\u0004\u0018\u00010%2\u0006\u0010\u0017\u001a\u00020\b2\u0006\u0010&\u001a\u00020'H\u0002J\u0010\u0010(\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\bH\u0002J\u0018\u0010)\u001a\u0004\u0018\u00010\b2\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0002J(\u0010*\u001a\u00020%2\u0006\u0010\u0011\u001a\u00020\u001c2\u0006\u0010\u0013\u001a\u00020\u001c2\u0006\u0010\u0012\u001a\u00020\u001c2\u0006\u0010\u0014\u001a\u00020\u001cH\u0002J2\u0010+\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0017\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010,\u001a\u00020'2\u0006\u0010-\u001a\u00020.H\u0002\u00a8\u0006/"}, d2={"Lcom/darwin/viola/still/FaceAnalyser;", "", "()V", "analyseMultipleFaces", "", "Lcom/darwin/viola/still/model/FacePortrait;", "faces", "", "Lcom/google/mlkit/vision/face/Face;", "bitmap", "Landroid/graphics/Bitmap;", "faceOptions", "Lcom/darwin/viola/still/model/FaceOptions;", "analyseProminentFace", "analyzeFaces", "calculateDistanceBetweenPoints", "", "x1", "y1", "x2", "y2", "cropFace", "Lkotlin/Pair;", "face", "cropAlgorithm", "Lcom/darwin/viola/still/model/CropAlgorithm;", "cropFaceByLeastAlgorithm", "eulerValueToAngle", "", "value", "getAgeRange", "", "getAreaOfFaceRelativeToBitmap", "width", "height", "getFaceSizePercentage", "getLandmarkPosition", "Landroid/graphics/PointF;", "landmarkId", "", "getPixelBetweenEyes", "getProminentFace", "midpoint", "processFace", "minFaceSize", "ageClassification", "", "still_release"})
public final class FaceAnalyser {
    @NotNull
    public final List<FacePortrait> analyzeFaces(@NotNull List<? extends Face> faces, @NotNull Bitmap bitmap, @NotNull FaceOptions faceOptions) {
        Intrinsics.checkParameterIsNotNull(faces, (String)"faces");
        Intrinsics.checkParameterIsNotNull((Object)bitmap, (String)"bitmap");
        Intrinsics.checkParameterIsNotNull((Object)faceOptions, (String)"faceOptions");
        List<FacePortrait> facePortraits = faceOptions.getProminentFaceDetection() ? this.analyseProminentFace(faces, bitmap, faceOptions) : this.analyseMultipleFaces(faces, bitmap, faceOptions);
        List<FacePortrait> list = Collections.unmodifiableList(facePortraits);
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"Collections.unmodifiableList(facePortraits)");
        return list;
    }

    private final List<FacePortrait> analyseProminentFace(List<? extends Face> faces, Bitmap bitmap, FaceOptions faceOptions) {
        FacePortrait portrait;
        Util.Companion.printLog("Prominent face analysis started.");
        boolean bl = false;
        List facePortraits = new ArrayList();
        Face face = this.getProminentFace(faces);
        if (face == null) {
            Intrinsics.throwNpe();
        }
        if ((portrait = this.processFace(face, bitmap, faceOptions.getCropAlgorithm(), faceOptions.getMinimumFaceSize(), faceOptions.getAgeClassification())) != null) {
            Util.Companion.printLog("Face crop succeeded with {CropAlgorithm." + (Object)((Object)faceOptions.getCropAlgorithm()) + ")} algorithm.");
            facePortraits.add(portrait);
        }
        return facePortraits;
    }

    private final List<FacePortrait> analyseMultipleFaces(List<? extends Face> faces, Bitmap bitmap, FaceOptions faceOptions) {
        Util.Companion.printLog("Non prominent face analysis started.");
        boolean bl = false;
        List facePortraits = new ArrayList();
        Iterable $this$forEach$iv = faces;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Face it = (Face)element$iv;
            boolean bl2 = false;
            FacePortrait portrait = this.processFace(it, bitmap, faceOptions.getCropAlgorithm(), faceOptions.getMinimumFaceSize(), faceOptions.getAgeClassification());
            if (portrait != null) {
                Util.Companion.printLog("Face crop succeeded with {CropAlgorithm." + (Object)((Object)faceOptions.getCropAlgorithm()) + "} algorithm.");
                facePortraits.add(portrait);
            }
            Util.Companion.printLog("---------- ---------- ---------- ----------");
        }
        return facePortraits;
    }

    private final FacePortrait processFace(Face face, Bitmap bitmap, CropAlgorithm cropAlgorithm, int minFaceSize, boolean ageClassification) {
        Util.Companion.printLog("Processing face with {CropAlgorithm." + (Object)((Object)cropAlgorithm) + "} algorithm.");
        float faceSize = this.getFaceSizePercentage(face, bitmap, cropAlgorithm);
        if (faceSize >= (float)minFaceSize) {
            Pair<Bitmap, Double> portraitData = this.cropFace(face, bitmap, cropAlgorithm);
            Bitmap croppedBitmap = (Bitmap)portraitData.getFirst();
            Float f = face.getSmilingProbability();
            if (f == null) {
                Intrinsics.throwNpe();
            }
            float smileProbability = MathExtensionKt.roundFloat(f.floatValue());
            Float f2 = face.getLeftEyeOpenProbability();
            if (f2 == null) {
                Intrinsics.throwNpe();
            }
            float leftEyeOpenProbability = MathExtensionKt.roundFloat(f2.floatValue());
            Float f3 = face.getRightEyeOpenProbability();
            if (f3 == null) {
                Intrinsics.throwNpe();
            }
            float rightEyeOpenProbability = MathExtensionKt.roundFloat(f3.floatValue());
            double pixelBetweenEyes = MathExtensionKt.roundDouble(((Number)portraitData.getSecond()).doubleValue());
            faceSize = this.getAreaOfFaceRelativeToBitmap(croppedBitmap.getWidth(), croppedBitmap.getHeight(), bitmap);
            FacePose facePose = new FacePose(this.eulerValueToAngle(face.getHeadEulerAngleX()), this.eulerValueToAngle(face.getHeadEulerAngleY()), this.eulerValueToAngle(face.getHeadEulerAngleZ()));
            String ageRange = ageClassification ? this.getAgeRange(croppedBitmap) : null;
            return new FacePortrait(croppedBitmap, smileProbability, leftEyeOpenProbability, rightEyeOpenProbability, pixelBetweenEyes, faceSize, facePose, ageRange);
        }
        Util.Companion.printLog("The face size{" + faceSize + "} is below minimum threshold value{" + minFaceSize + "}, skipping face.");
        return null;
    }

    private final Pair<Bitmap, Double> cropFace(Face face, Bitmap bitmap, CropAlgorithm cropAlgorithm) {
        Util.Companion.printLog("Face crop with {CropAlgorithm." + (Object)((Object)cropAlgorithm) + "} algorithm is started.");
        if (cropAlgorithm == CropAlgorithm.LEAST) {
            return this.cropFaceByLeastAlgorithm(face, bitmap);
        }
        double eyeDistance = this.getPixelBetweenEyes(face);
        float width = 0.0f;
        float height = 0.0f;
        if (cropAlgorithm == CropAlgorithm.SQUARE) {
            float tempWidth = (float)(eyeDistance / 0.3);
            width = height = (float)((double)tempWidth / 0.75);
        } else {
            width = (float)(eyeDistance / 0.25);
            height = (float)((double)width / 0.75);
        }
        PointF pointF = this.getLandmarkPosition(face, 4);
        if (pointF == null) {
            Intrinsics.throwNpe();
        }
        PointF leftEyePosition = pointF;
        PointF pointF2 = this.getLandmarkPosition(face, 10);
        if (pointF2 == null) {
            Intrinsics.throwNpe();
        }
        PointF rightEyePosition = pointF2;
        PointF eyeMidPoint = this.midpoint(leftEyePosition.x, rightEyePosition.x, leftEyePosition.y, rightEyePosition.y);
        int faceStartX = (int)(eyeMidPoint.x - width / (float)2);
        faceStartX = RangesKt.coerceAtLeast((int)faceStartX, (int)0);
        double upperHeightRatio = cropAlgorithm == CropAlgorithm.THREE_BY_FOUR ? 0.6 : 0.5;
        int faceUpperHeight = (int)(upperHeightRatio * (double)width) + 1;
        int faceStartY = (int)(eyeMidPoint.y - (float)faceUpperHeight);
        faceStartY = RangesKt.coerceAtLeast((int)faceStartY, (int)0);
        int finalStartX = faceStartX;
        int finalWidth = (int)width;
        int finalStartY = faceStartY;
        int finalHeight = (int)height;
        if (finalStartY + finalHeight > bitmap.getHeight()) {
            int excessHeight = finalStartY + finalHeight - bitmap.getHeight();
            finalHeight -= excessHeight;
            if (cropAlgorithm == CropAlgorithm.SQUARE) {
                finalStartX += excessHeight / 2;
                finalWidth -= excessHeight;
            } else {
                double newWidth = (double)finalHeight * 0.75;
                double weightDiff = (double)finalHeight - newWidth;
                finalStartX += (int)(weightDiff / (double)2);
                finalWidth = (int)newWidth;
            }
        }
        if (finalStartX + finalWidth > bitmap.getWidth()) {
            int excessWidth = finalStartX + finalWidth - bitmap.getWidth();
            finalWidth -= excessWidth;
            if (cropAlgorithm == CropAlgorithm.SQUARE) {
                finalStartY += excessWidth / 2;
                finalHeight -= excessWidth;
            } else {
                double newHeight = (double)finalWidth / 0.75;
                double heightDiff = (double)finalHeight - newHeight;
                finalStartY += (int)(heightDiff / (double)2);
                finalHeight = (int)newHeight;
            }
        }
        int widthRemainder = finalWidth % 8;
        int heightRemainder = finalHeight % 8;
        if (widthRemainder != 0) {
            finalWidth -= widthRemainder;
        }
        if (heightRemainder != 0) {
            finalHeight -= heightRemainder;
        }
        Bitmap croppedBitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)finalStartX, (int)finalStartY, (int)finalWidth, (int)finalHeight);
        return new Pair((Object)croppedBitmap, (Object)eyeDistance);
    }

    private final Pair<Bitmap, Double> cropFaceByLeastAlgorithm(Face face, Bitmap bitmap) {
        double eyeDistance = this.getPixelBetweenEyes(face);
        int heightTopOffset = (int)(eyeDistance / (double)2);
        int heightBottomOffset = heightTopOffset / 2;
        int startX = face.getBoundingBox().left;
        int startY = face.getBoundingBox().top - heightTopOffset;
        int width = face.getBoundingBox().width();
        int height = face.getBoundingBox().height() + heightTopOffset + heightBottomOffset;
        if (startX < 0) {
            startX = 0;
        }
        if (startY < 0) {
            startY = 0;
        }
        if (startY + height > bitmap.getHeight()) {
            height = bitmap.getHeight() - startY;
        }
        if (startX + width > bitmap.getWidth()) {
            width = bitmap.getWidth() - startX;
        }
        int widthRemainder = width % 8;
        int heightRemainder = height % 8;
        if (widthRemainder != 0) {
            width -= widthRemainder;
        }
        if (heightRemainder != 0) {
            height -= heightRemainder;
        }
        Bitmap croppedBitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)startX, (int)startY, (int)width, (int)height);
        return new Pair((Object)croppedBitmap, (Object)eyeDistance);
    }

    private final float getFaceSizePercentage(Face face, Bitmap bitmap, CropAlgorithm cropAlgorithm) {
        double eyeDistance = this.getPixelBetweenEyes(face);
        float width = 0.0f;
        float height = 0.0f;
        switch (FaceAnalyser$WhenMappings.$EnumSwitchMapping$0[cropAlgorithm.ordinal()]) {
            case 1: {
                float tempWidth = (float)(eyeDistance / 0.25);
                width = height = (float)((double)tempWidth / 0.75);
                break;
            }
            case 2: {
                width = (float)(eyeDistance / 0.25);
                height = (float)((double)width / 0.75);
                break;
            }
            case 3: {
                int heightTopOffset = face.getBoundingBox().height() * 40 / 100;
                int heightBottomOffset = heightTopOffset / 3;
                int startY = face.getBoundingBox().top - heightTopOffset;
                int tempHeight = face.getBoundingBox().height() + heightTopOffset + heightBottomOffset;
                if (startY < 0) {
                    startY = 0;
                }
                height = startY + tempHeight > bitmap.getHeight() ? (float)(bitmap.getHeight() - startY) : (float)tempHeight;
                width = face.getBoundingBox().width();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return this.getAreaOfFaceRelativeToBitmap(width, height, bitmap);
    }

    private final float getAreaOfFaceRelativeToBitmap(float width, float height, Bitmap bitmap) {
        float areaOfFace = width * height;
        int areaOfInputImage = bitmap.getWidth() * bitmap.getHeight();
        return areaOfFace * (float)100 / (float)areaOfInputImage;
    }

    private final double getPixelBetweenEyes(Face face) {
        PointF pointF = this.getLandmarkPosition(face, 4);
        if (pointF == null) {
            Intrinsics.throwNpe();
        }
        PointF leftEyePosition = pointF;
        PointF pointF2 = this.getLandmarkPosition(face, 10);
        if (pointF2 == null) {
            Intrinsics.throwNpe();
        }
        PointF rightEyePosition = pointF2;
        return this.calculateDistanceBetweenPoints(leftEyePosition.x, leftEyePosition.y, rightEyePosition.x, rightEyePosition.y);
    }

    /*
     * WARNING - void declaration
     */
    private final Face getProminentFace(List<? extends Face> faces) {
        Face face;
        if (faces.size() == 1) {
            face = faces.get(0);
        } else {
            void var2_2;
            Face prominentFace = null;
            double prominentEyeDistance = 0.0;
            Iterable $this$forEach$iv = faces;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Face it = (Face)element$iv;
                boolean bl = false;
                double eyeDistance = this.getPixelBetweenEyes(it);
                if (!(eyeDistance > prominentEyeDistance)) continue;
                prominentEyeDistance = eyeDistance;
                prominentFace = it;
            }
            face = var2_2;
        }
        return face;
    }

    private final PointF getLandmarkPosition(Face face, int landmarkId) {
        FaceLandmark faceLandmark = face.getLandmark(landmarkId);
        return faceLandmark != null ? faceLandmark.getPosition() : null;
    }

    private final double calculateDistanceBetweenPoints(double x1, double y1, double x2, double y2) {
        double d = (y2 - y1) * (y2 - y1) + (x2 - x1) * (x2 - x1);
        boolean bl = false;
        return Math.sqrt(d);
    }

    private final PointF midpoint(float x1, float x2, float y1, float y2) {
        return new PointF((x1 + x2) / (float)2, (y1 + y2) / (float)2);
    }

    private final float eulerValueToAngle(float value) {
        return value < 0.0f ? value + (float)360 : value;
    }

    private final String getAgeRange(Bitmap bitmap) {
        ViolaAgeClassifier violaAgeClassifier = Viola.Companion.getAgeClassifier$still_release();
        if (violaAgeClassifier == null) {
            Intrinsics.throwNpe();
        }
        List result = violaAgeClassifier.findAgeSynchronized(bitmap);
        return ((AgeRecognition)result.get(0)).getRange();
    }
}

