/*
 * Decompiled with CFR 0.152.
 */
package com.darwin.viola.still.detector;

import android.graphics.Bitmap;
import com.darwin.viola.still.detector.ScopedExecutor;
import com.darwin.viola.still.detector.TaskExtensionsKt;
import com.darwin.viola.still.detector.VisionImageProcessor;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskExecutors;
import com.google.mlkit.vision.common.InputImage;
import java.util.concurrent.Executor;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b \u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\t2\u0006\u0010\n\u001a\u00020\u000bH$J\u0014\u0010\f\u001a\u00020\r2\n\u0010\u000e\u001a\u00060\u000fj\u0002`\u0010H$J\u001d\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00028\u00002\u0006\u0010\u0013\u001a\u00020\u0014H$\u00a2\u0006\u0002\u0010\u0015J\u0010\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u0014H\u0016J\u001e\u0010\u0018\u001a\b\u0012\u0004\u0012\u00028\u00000\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\b\u0010\u0019\u001a\u00020\rH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/darwin/viola/still/detector/VisionProcessorBase;", "T", "Lcom/darwin/viola/still/detector/VisionImageProcessor;", "()V", "executor", "Lcom/darwin/viola/still/detector/ScopedExecutor;", "isShutdown", "", "detectInImage", "Lcom/google/android/gms/tasks/Task;", "image", "Lcom/google/mlkit/vision/common/InputImage;", "onFailure", "", "e", "Ljava/lang/Exception;", "Lkotlin/Exception;", "onSuccess", "results", "originalImage", "Landroid/graphics/Bitmap;", "(Ljava/lang/Object;Landroid/graphics/Bitmap;)V", "processBitmap", "bitmap", "requestDetectInImage", "stop", "still_release"})
public abstract class VisionProcessorBase<T>
implements VisionImageProcessor {
    private final ScopedExecutor executor;
    private boolean isShutdown;

    @Override
    public void processBitmap(@NotNull Bitmap bitmap) {
        Intrinsics.checkParameterIsNotNull((Object)bitmap, (String)"bitmap");
        InputImage inputImage = InputImage.fromBitmap((Bitmap)bitmap, (int)0);
        Intrinsics.checkExpressionValueIsNotNull((Object)inputImage, (String)"InputImage.fromBitmap(bitmap, 0)");
        this.requestDetectInImage(inputImage, bitmap);
    }

    private final Task<T> requestDetectInImage(InputImage image, Bitmap originalImage) {
        return TaskExtensionsKt.addOnFailureListener(TaskExtensionsKt.addOnSuccessListener(this.detectInImage(image), this.executor, (Function1)new Function1<T, Unit>(this, originalImage){
            final /* synthetic */ VisionProcessorBase this$0;
            final /* synthetic */ Bitmap $originalImage;

            public final void invoke(T results) {
                this.this$0.onSuccess(results, this.$originalImage);
            }
            {
                this.this$0 = visionProcessorBase;
                this.$originalImage = bitmap;
                super(1);
            }
        }), this.executor, (Function1<? super Exception, Unit>)((Function1)new Function1<Exception, Unit>(this){
            final /* synthetic */ VisionProcessorBase this$0;

            public final void invoke(@NotNull Exception e) {
                Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                e.printStackTrace();
                this.this$0.onFailure(e);
            }
            {
                this.this$0 = visionProcessorBase;
                super(1);
            }
        }));
    }

    @Override
    public void stop() {
        this.executor.shutdown();
        this.isShutdown = true;
    }

    @NotNull
    protected abstract Task<T> detectInImage(@NotNull InputImage var1);

    protected abstract void onSuccess(T var1, @NotNull Bitmap var2);

    protected abstract void onFailure(@NotNull Exception var1);

    public VisionProcessorBase() {
        Executor executor = TaskExecutors.MAIN_THREAD;
        Intrinsics.checkExpressionValueIsNotNull((Object)executor, (String)"TaskExecutors.MAIN_THREAD");
        this.executor = new ScopedExecutor(executor);
    }
}

