/*
 * Decompiled with CFR 0.152.
 */
package com.darwin.viola.still.detector;

import android.graphics.Bitmap;
import com.darwin.viola.still.FaceAnalyser;
import com.darwin.viola.still.FaceDetectionListener;
import com.darwin.viola.still.Util;
import com.darwin.viola.still.detector.VisionProcessorBase;
import com.darwin.viola.still.model.FaceDetectionError;
import com.darwin.viola.still.model.FaceOptions;
import com.darwin.viola.still.model.FacePortrait;
import com.darwin.viola.still.model.Result;
import com.google.android.gms.tasks.Task;
import com.google.mlkit.vision.common.InputImage;
import com.google.mlkit.vision.face.Face;
import com.google.mlkit.vision.face.FaceDetection;
import com.google.mlkit.vision.face.FaceDetector;
import com.google.mlkit.vision.face.FaceDetectorOptions;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0001B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001c\u0010\u0013\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0014J\u0014\u0010\u0017\u001a\u00020\u00182\n\u0010\u0019\u001a\u00060\u001aj\u0002`\u001bH\u0014J\u001e\u0010\u001c\u001a\u00020\u00182\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00030\u00022\u0006\u0010\u001e\u001a\u00020\u001fH\u0014J\b\u0010 \u001a\u00020\u0018H\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u00020\u000eX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012\u00a8\u0006!"}, d2={"Lcom/darwin/viola/still/detector/FaceDetectorProcessor;", "Lcom/darwin/viola/still/detector/VisionProcessorBase;", "", "Lcom/google/mlkit/vision/face/Face;", "detectorOptions", "Lcom/google/mlkit/vision/face/FaceDetectorOptions;", "faceDetectionListener", "Lcom/darwin/viola/still/FaceDetectionListener;", "(Lcom/google/mlkit/vision/face/FaceDetectorOptions;Lcom/darwin/viola/still/FaceDetectionListener;)V", "detector", "Lcom/google/mlkit/vision/face/FaceDetector;", "faceAnalyser", "Lcom/darwin/viola/still/FaceAnalyser;", "faceOptions", "Lcom/darwin/viola/still/model/FaceOptions;", "getFaceOptions", "()Lcom/darwin/viola/still/model/FaceOptions;", "setFaceOptions", "(Lcom/darwin/viola/still/model/FaceOptions;)V", "detectInImage", "Lcom/google/android/gms/tasks/Task;", "image", "Lcom/google/mlkit/vision/common/InputImage;", "onFailure", "", "e", "Ljava/lang/Exception;", "Lkotlin/Exception;", "onSuccess", "results", "originalImage", "Landroid/graphics/Bitmap;", "stop", "still_release"})
public final class FaceDetectorProcessor
extends VisionProcessorBase<List<? extends Face>> {
    @NotNull
    public FaceOptions faceOptions;
    private final FaceDetector detector;
    private final FaceAnalyser faceAnalyser;
    private final FaceDetectionListener faceDetectionListener;

    @NotNull
    public final FaceOptions getFaceOptions() {
        FaceOptions faceOptions = this.faceOptions;
        if (faceOptions == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"faceOptions");
        }
        return faceOptions;
    }

    public final void setFaceOptions(@NotNull FaceOptions faceOptions) {
        Intrinsics.checkParameterIsNotNull((Object)faceOptions, (String)"<set-?>");
        this.faceOptions = faceOptions;
    }

    @Override
    public void stop() {
        super.stop();
        this.detector.close();
    }

    @Override
    @NotNull
    protected Task<List<Face>> detectInImage(@NotNull InputImage image) {
        Intrinsics.checkParameterIsNotNull((Object)image, (String)"image");
        Util.Companion.printLog("Face detection process started.");
        Task task = this.detector.process(image);
        Intrinsics.checkExpressionValueIsNotNull((Object)task, (String)"detector.process(image)");
        return task;
    }

    @Override
    protected void onSuccess(@NotNull List<? extends Face> results, @NotNull Bitmap originalImage) {
        Intrinsics.checkParameterIsNotNull(results, (String)"results");
        Intrinsics.checkParameterIsNotNull((Object)originalImage, (String)"originalImage");
        Util.Companion.printLog("Face detection process completed without exceptions.");
        if (results.isEmpty()) {
            Util.Companion.printLog("Face detector can't find any face on the given image.");
            this.faceDetectionListener.onFaceDetectionFailed(FaceDetectionError.NO_FACE_DETECTED, FaceDetectionError.NO_FACE_DETECTED.getMessage());
        } else {
            List<FacePortrait> portraitList;
            Util.Companion.printLog("Detected " + results.size() + " face(s), starting face analysis.");
            FaceOptions faceOptions = this.faceOptions;
            if (faceOptions == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"faceOptions");
            }
            if ((portraitList = this.faceAnalyser.analyzeFaces(results, originalImage, faceOptions)).isEmpty()) {
                Util.Companion.printLog("Face analyser can't find any valid face with given configuration.");
                this.faceDetectionListener.onFaceDetectionFailed(FaceDetectionError.NO_VALID_FACE_DETECTED, FaceDetectionError.NO_VALID_FACE_DETECTED.getMessage());
            } else {
                Util.Companion.printLog("Found " + portraitList.size() + " valid face(s) out of " + results.size() + " by the analyser.");
                Result result = new Result(portraitList.size(), portraitList);
                this.faceDetectionListener.onFaceDetected(result);
            }
        }
    }

    @Override
    protected void onFailure(@NotNull Exception e) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        Util.Companion.printLog("Face detection process failed with following exception {" + e.getMessage() + "}.");
        String string = e.getMessage();
        if (string == null) {
            Intrinsics.throwNpe();
        }
        this.faceDetectionListener.onFaceDetectionFailed(FaceDetectionError.ERROR, string);
    }

    public FaceDetectorProcessor(@NotNull FaceDetectorOptions detectorOptions, @NotNull FaceDetectionListener faceDetectionListener) {
        Intrinsics.checkParameterIsNotNull((Object)detectorOptions, (String)"detectorOptions");
        Intrinsics.checkParameterIsNotNull((Object)faceDetectionListener, (String)"faceDetectionListener");
        this.faceDetectionListener = faceDetectionListener;
        FaceDetector faceDetector = FaceDetection.getClient((FaceDetectorOptions)detectorOptions);
        Intrinsics.checkExpressionValueIsNotNull((Object)faceDetector, (String)"FaceDetection.getClient(detectorOptions)");
        this.detector = faceDetector;
        this.faceAnalyser = new FaceAnalyser();
    }
}

