/*
 * Decompiled with CFR 0.152.
 */
package com.darwin.viola.still;

import android.content.Context;
import android.graphics.Bitmap;
import com.darwin.viola.age.AgeClassificationListener;
import com.darwin.viola.age.AgeRecognition;
import com.darwin.viola.age.ViolaAgeClassifier;
import com.darwin.viola.still.FaceDetectionListener;
import com.darwin.viola.still.Util;
import com.darwin.viola.still.detector.FaceDetectorProcessor;
import com.darwin.viola.still.detector.VisionImageProcessor;
import com.darwin.viola.still.model.FaceDetectionError;
import com.darwin.viola.still.model.FaceOptions;
import com.google.mlkit.vision.face.FaceDetectorOptions;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u001a\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\u000fH\u0007J\b\u0010\u0010\u001a\u00020\u000fH\u0002J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u0013\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u0014\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/darwin/viola/still/Viola;", "", "faceDetectionListener", "Lcom/darwin/viola/still/FaceDetectionListener;", "(Lcom/darwin/viola/still/FaceDetectionListener;)V", "imageProcessor", "Lcom/darwin/viola/still/detector/VisionImageProcessor;", "addAgeClassificationPlugin", "", "context", "Landroid/content/Context;", "detectFace", "image", "Landroid/graphics/Bitmap;", "option", "Lcom/darwin/viola/still/model/FaceOptions;", "getDefaultFaceOptions", "isValidInputImage", "", "resize", "verifyPlugins", "Companion", "still_release"})
public final class Viola {
    private final VisionImageProcessor imageProcessor;
    private final FaceDetectionListener faceDetectionListener;
    @Nullable
    private static ViolaAgeClassifier ageClassifier;
    public static final Companion Companion;

    public final void addAgeClassificationPlugin(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        ViolaAgeClassifier violaAgeClassifier = ageClassifier = new ViolaAgeClassifier(new AgeClassificationListener(){

            public void onAgeClassificationResult(@NotNull List<AgeRecognition> result) {
                Intrinsics.checkParameterIsNotNull(result, (String)"result");
            }

            public void onAgeClassificationError(@NotNull String error) {
                Intrinsics.checkParameterIsNotNull((Object)error, (String)"error");
            }
        });
        if (violaAgeClassifier == null) {
            Intrinsics.throwNpe();
        }
        Context context2 = context.getApplicationContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context2, (String)"context.applicationContext");
        violaAgeClassifier.initialize(context2);
        Util.Companion.printLog("Age classification plugin added to Viola SDK successfully.");
    }

    @JvmOverloads
    public final void detectFace(@NotNull Bitmap image, @NotNull FaceOptions option) {
        Intrinsics.checkParameterIsNotNull((Object)image, (String)"image");
        Intrinsics.checkParameterIsNotNull((Object)option, (String)"option");
        Util.Companion.setDebug(option.getDebug());
        this.verifyPlugins(option);
        if (this.isValidInputImage(image)) {
            Util.Companion.printLog("The given input bitmap is valid, ready for image processing.");
            VisionImageProcessor visionImageProcessor = this.imageProcessor;
            if (visionImageProcessor == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.darwin.viola.still.detector.FaceDetectorProcessor");
            }
            ((FaceDetectorProcessor)visionImageProcessor).setFaceOptions(option);
            this.imageProcessor.processBitmap(this.resize(image));
        } else {
            Util.Companion.printLog("The given input bitmap is not valid, terminating image processing.");
            this.faceDetectionListener.onFaceDetectionFailed(FaceDetectionError.LOW_RESOLUTION, FaceDetectionError.LOW_RESOLUTION.getMessage());
        }
    }

    public static /* synthetic */ void detectFace$default(Viola viola, Bitmap bitmap, FaceOptions faceOptions, int n, Object object) {
        if ((n & 2) != 0) {
            faceOptions = viola.getDefaultFaceOptions();
        }
        viola.detectFace(bitmap, faceOptions);
    }

    @JvmOverloads
    public final void detectFace(@NotNull Bitmap image) {
        Viola.detectFace$default(this, image, null, 2, null);
    }

    private final void verifyPlugins(FaceOptions option) {
        block4: {
            block6: {
                block5: {
                    Util.Companion.printLog("Verifying external plugin configurations.");
                    if (!option.getAgeClassification()) break block4;
                    if (ageClassifier == null) break block5;
                    ViolaAgeClassifier violaAgeClassifier = ageClassifier;
                    if (violaAgeClassifier == null) {
                        Intrinsics.throwNpe();
                    }
                    if (violaAgeClassifier.isInitialized()) break block6;
                }
                throw (Throwable)new IllegalStateException("Age classification plugin is not attached to Viola SDK. Check documentation for more details.");
            }
            Util.Companion.printLog("Age classification plugin status is GOOD.");
        }
    }

    private final FaceOptions getDefaultFaceOptions() {
        return new FaceOptions.Builder().setMinimumFaceSize(15).build();
    }

    private final boolean isValidInputImage(Bitmap image) {
        boolean isLandscape;
        boolean bl = isLandscape = image.getWidth() > image.getHeight();
        if (isLandscape && (image.getWidth() < 480 || image.getHeight() < 360)) {
            return false;
        }
        return isLandscape || image.getWidth() >= 360 && image.getHeight() >= 480;
    }

    private final Bitmap resize(Bitmap image) {
        Util.Companion.printLog("Re-scaling input bitmap for fast image processing.");
        int maxWidth = 720;
        int maxHeight = 1280;
        int width = image.getWidth();
        int height = image.getHeight();
        float ratioBitmap = (float)width / (float)height;
        float ratioMax = (float)maxWidth / (float)maxHeight;
        int finalWidth = maxWidth;
        int finalHeight = maxHeight;
        if (ratioMax > ratioBitmap) {
            finalWidth = (int)((float)maxHeight * ratioBitmap);
        } else {
            finalHeight = (int)((float)maxWidth / ratioBitmap);
        }
        Bitmap bitmap = Bitmap.createScaledBitmap((Bitmap)image, (int)finalWidth, (int)finalHeight, (boolean)true);
        Intrinsics.checkExpressionValueIsNotNull((Object)bitmap, (String)"Bitmap.createScaledBitma\u2026Width, finalHeight, true)");
        return bitmap;
    }

    public Viola(@NotNull FaceDetectionListener faceDetectionListener) {
        Intrinsics.checkParameterIsNotNull((Object)faceDetectionListener, (String)"faceDetectionListener");
        this.faceDetectionListener = faceDetectionListener;
        FaceDetectorOptions faceDetectorOptions = new FaceDetectorOptions.Builder().setContourMode(1).setLandmarkMode(2).setPerformanceMode(2).setClassificationMode(2).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)faceDetectorOptions, (String)"FaceDetectorOptions.Buil\u2026ALL)\n            .build()");
        FaceDetectorOptions options = faceDetectorOptions;
        this.imageProcessor = new FaceDetectorProcessor(options, this.faceDetectionListener);
    }

    static {
        Companion = new Companion(null);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/darwin/viola/still/Viola$Companion;", "", "()V", "ageClassifier", "Lcom/darwin/viola/age/ViolaAgeClassifier;", "getAgeClassifier$still_release", "()Lcom/darwin/viola/age/ViolaAgeClassifier;", "setAgeClassifier$still_release", "(Lcom/darwin/viola/age/ViolaAgeClassifier;)V", "still_release"})
    public static final class Companion {
        @Nullable
        public final ViolaAgeClassifier getAgeClassifier$still_release() {
            return ageClassifier;
        }

        public final void setAgeClassifier$still_release(@Nullable ViolaAgeClassifier violaAgeClassifier) {
            ageClassifier = violaAgeClassifier;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

