/*
 * Decompiled with CFR 0.152.
 */
package com.darwin.viola.still;

import android.graphics.Bitmap;
import com.darwin.viola.still.FaceDetectionListener;
import com.darwin.viola.still.Util;
import com.darwin.viola.still.detector.FaceDetectorProcessor;
import com.darwin.viola.still.detector.VisionImageProcessor;
import com.darwin.viola.still.model.FaceDetectionError;
import com.darwin.viola.still.model.FaceOptions;
import com.google.mlkit.vision.face.FaceDetectorOptions;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\fH\u0007J\b\u0010\r\u001a\u00020\fH\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u0010\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\nH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/darwin/viola/still/Viola;", "", "faceDetectionListener", "Lcom/darwin/viola/still/FaceDetectionListener;", "(Lcom/darwin/viola/still/FaceDetectionListener;)V", "imageProcessor", "Lcom/darwin/viola/still/detector/VisionImageProcessor;", "detectFace", "", "image", "Landroid/graphics/Bitmap;", "option", "Lcom/darwin/viola/still/model/FaceOptions;", "getDefaultFaceOptions", "isValidInputImage", "", "resize", "still_release"})
public final class Viola {
    private final VisionImageProcessor imageProcessor;
    private final FaceDetectionListener faceDetectionListener;

    @JvmOverloads
    public final void detectFace(@NotNull Bitmap image, @NotNull FaceOptions option) {
        Intrinsics.checkParameterIsNotNull((Object)image, (String)"image");
        Intrinsics.checkParameterIsNotNull((Object)option, (String)"option");
        Util.Companion.setDebug(option.getDebug());
        if (this.isValidInputImage(image)) {
            Util.Companion.printLog("The given input bitmap is valid, ready for image processing.");
            VisionImageProcessor visionImageProcessor = this.imageProcessor;
            if (visionImageProcessor == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.darwin.viola.still.detector.FaceDetectorProcessor");
            }
            ((FaceDetectorProcessor)visionImageProcessor).setFaceOptions(option);
            this.imageProcessor.processBitmap(this.resize(image));
        } else {
            Util.Companion.printLog("The given input bitmap is not valid, terminating image processing.");
            this.faceDetectionListener.onFaceDetectionFailed(FaceDetectionError.LOW_RESOLUTION, FaceDetectionError.LOW_RESOLUTION.getMessage());
        }
    }

    public static /* synthetic */ void detectFace$default(Viola viola, Bitmap bitmap, FaceOptions faceOptions, int n, Object object) {
        if ((n & 2) != 0) {
            faceOptions = viola.getDefaultFaceOptions();
        }
        viola.detectFace(bitmap, faceOptions);
    }

    @JvmOverloads
    public final void detectFace(@NotNull Bitmap image) {
        Viola.detectFace$default(this, image, null, 2, null);
    }

    private final FaceOptions getDefaultFaceOptions() {
        return new FaceOptions.Builder().setMinimumFaceSize(15).build();
    }

    private final boolean isValidInputImage(Bitmap image) {
        boolean isLandscape;
        boolean bl = isLandscape = image.getWidth() > image.getHeight();
        if (isLandscape && (image.getWidth() < 480 || image.getHeight() < 360)) {
            return false;
        }
        return isLandscape || image.getWidth() >= 360 && image.getHeight() >= 480;
    }

    private final Bitmap resize(Bitmap image) {
        Util.Companion.printLog("Re-scaling input bitmap for fast image processing.");
        int maxWidth = 720;
        int maxHeight = 1280;
        int width = image.getWidth();
        int height = image.getHeight();
        float ratioBitmap = (float)width / (float)height;
        float ratioMax = (float)maxWidth / (float)maxHeight;
        int finalWidth = maxWidth;
        int finalHeight = maxHeight;
        if (ratioMax > ratioBitmap) {
            finalWidth = (int)((float)maxHeight * ratioBitmap);
        } else {
            finalHeight = (int)((float)maxWidth / ratioBitmap);
        }
        Bitmap bitmap = Bitmap.createScaledBitmap((Bitmap)image, (int)finalWidth, (int)finalHeight, (boolean)true);
        Intrinsics.checkExpressionValueIsNotNull((Object)bitmap, (String)"Bitmap.createScaledBitma\u2026Width, finalHeight, true)");
        return bitmap;
    }

    public Viola(@NotNull FaceDetectionListener faceDetectionListener) {
        Intrinsics.checkParameterIsNotNull((Object)faceDetectionListener, (String)"faceDetectionListener");
        this.faceDetectionListener = faceDetectionListener;
        FaceDetectorOptions faceDetectorOptions = new FaceDetectorOptions.Builder().setContourMode(1).setLandmarkMode(2).setPerformanceMode(2).setClassificationMode(2).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)faceDetectorOptions, (String)"FaceDetectorOptions.Buil\u2026ALL)\n            .build()");
        FaceDetectorOptions options = faceDetectorOptions;
        this.imageProcessor = new FaceDetectorProcessor(options, this.faceDetectionListener);
    }
}

