/*
 * Decompiled with CFR 0.152.
 */
package com.darwin.viola.age;

import android.content.Context;
import android.graphics.Bitmap;
import android.os.Trace;
import com.darwin.viola.age.AgeClassifierQuantizedMobileNet;
import com.darwin.viola.age.AgeRecognition;
import com.darwin.viola.age.Classifier;
import com.darwin.viola.age.Classifier$WhenMappings;
import com.darwin.viola.age.Util;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.tensorflow.lite.DataType;
import org.tensorflow.lite.Interpreter;
import org.tensorflow.lite.nnapi.NnApiDelegate;
import org.tensorflow.lite.support.common.FileUtil;
import org.tensorflow.lite.support.common.TensorOperator;
import org.tensorflow.lite.support.common.TensorProcessor;
import org.tensorflow.lite.support.image.ImageOperator;
import org.tensorflow.lite.support.image.ImageProcessor;
import org.tensorflow.lite.support.image.TensorImage;
import org.tensorflow.lite.support.image.ops.ResizeOp;
import org.tensorflow.lite.support.image.ops.ResizeWithCropOrPadOp;
import org.tensorflow.lite.support.image.ops.Rot90Op;
import org.tensorflow.lite.support.label.TensorLabel;
import org.tensorflow.lite.support.tensorbuffer.TensorBuffer;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b \u0018\u0000 '2\u00020\u0001:\u0003'()B\u001f\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\u001a\u001a\u00020\u001bJ\n\u0010\u001c\u001a\u0004\u0018\u00010\u000fH$J\n\u0010\u001d\u001a\u0004\u0018\u00010\u000fH$J\n\u0010\u001e\u001a\u0004\u0018\u00010\u001fH$J\n\u0010 \u001a\u0004\u0018\u00010\u001fH$J\u0018\u0010!\u001a\u00020\f2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u0007H\u0002J\u001c\u0010%\u001a\b\u0012\u0004\u0012\u00020&0\u000e2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u0007R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/darwin/viola/age/Classifier;", "", "context", "Landroid/content/Context;", "device", "Lcom/darwin/viola/age/Classifier$Device;", "numThreads", "", "(Landroid/content/Context;Lcom/darwin/viola/age/Classifier$Device;I)V", "imageSizeX", "imageSizeY", "inputImageBuffer", "Lorg/tensorflow/lite/support/image/TensorImage;", "labels", "", "", "nnApiDelegate", "Lorg/tensorflow/lite/nnapi/NnApiDelegate;", "outputProbabilityBuffer", "Lorg/tensorflow/lite/support/tensorbuffer/TensorBuffer;", "probabilityProcessor", "Lorg/tensorflow/lite/support/common/TensorProcessor;", "tflite", "Lorg/tensorflow/lite/Interpreter;", "tfliteOptions", "Lorg/tensorflow/lite/Interpreter$Options;", "close", "", "getLabelPath", "getModelPath", "getPostProcessNormalizeOp", "Lorg/tensorflow/lite/support/common/TensorOperator;", "getPreProcessNormalizeOp", "loadImage", "bitmap", "Landroid/graphics/Bitmap;", "sensorOrientation", "recognizeImage", "Lcom/darwin/viola/age/AgeRecognition;", "Companion", "Device", "Model", "age_release"})
public abstract class Classifier {
    private final int imageSizeX;
    private final int imageSizeY;
    private NnApiDelegate nnApiDelegate;
    private Interpreter tflite;
    private final Interpreter.Options tfliteOptions;
    private final List<String> labels;
    private TensorImage inputImageBuffer;
    private final TensorBuffer outputProbabilityBuffer;
    private final TensorProcessor probabilityProcessor;
    private static final int MAX_RESULTS = 3;
    @NotNull
    public static final Companion Companion = new Companion(null);

    private final TensorImage loadImage(Bitmap bitmap, int sensorOrientation) {
        this.inputImageBuffer.load(bitmap);
        int cropSize = RangesKt.coerceAtMost((int)bitmap.getWidth(), (int)bitmap.getHeight());
        int numRotation = sensorOrientation / 90;
        ImageProcessor imageProcessor = new ImageProcessor.Builder().add((ImageOperator)new ResizeWithCropOrPadOp(cropSize, cropSize)).add((ImageOperator)new ResizeOp(this.imageSizeX, this.imageSizeY, ResizeOp.ResizeMethod.NEAREST_NEIGHBOR)).add((ImageOperator)new Rot90Op(numRotation)).add(this.getPreProcessNormalizeOp()).build();
        Object object = imageProcessor.process((Object)this.inputImageBuffer);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"imageProcessor.process(inputImageBuffer)");
        return (TensorImage)object;
    }

    @NotNull
    public final List<AgeRecognition> recognizeImage(@NotNull Bitmap bitmap, int sensorOrientation) {
        Intrinsics.checkNotNullParameter((Object)bitmap, (String)"bitmap");
        Trace.beginSection((String)"recognizeImage");
        Trace.beginSection((String)"loadImage");
        this.inputImageBuffer = this.loadImage(bitmap, sensorOrientation);
        Trace.endSection();
        Trace.beginSection((String)"runInference");
        Interpreter interpreter = this.tflite;
        Intrinsics.checkNotNull((Object)interpreter);
        interpreter.run((Object)this.inputImageBuffer.getBuffer(), (Object)this.outputProbabilityBuffer.getBuffer().rewind());
        Trace.endSection();
        Map map = new TensorLabel(this.labels, (TensorBuffer)this.probabilityProcessor.process((Object)this.outputProbabilityBuffer)).getMapWithFloatValue();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"TensorLabel(labels, prob\u2026       .mapWithFloatValue");
        Map labeledProbability = map;
        Trace.endSection();
        return Classifier.Companion.getTopKProbability(labeledProbability);
    }

    public final void close() {
        if (this.tflite != null) {
            Interpreter interpreter = this.tflite;
            Intrinsics.checkNotNull((Object)interpreter);
            interpreter.close();
            this.tflite = null;
        }
        if (this.nnApiDelegate != null) {
            NnApiDelegate nnApiDelegate = this.nnApiDelegate;
            Intrinsics.checkNotNull((Object)nnApiDelegate);
            nnApiDelegate.close();
            this.nnApiDelegate = null;
        }
    }

    @Nullable
    protected abstract String getModelPath();

    @Nullable
    protected abstract String getLabelPath();

    @Nullable
    protected abstract TensorOperator getPreProcessNormalizeOp();

    @Nullable
    protected abstract TensorOperator getPostProcessNormalizeOp();

    protected Classifier(@NotNull Context context, @NotNull Device device, int numThreads) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)((Object)device), (String)"device");
        this.tfliteOptions = new Interpreter.Options();
        String string = this.getModelPath();
        Intrinsics.checkNotNull((Object)string);
        String modelPath = string;
        MappedByteBuffer mappedByteBuffer = FileUtil.loadMappedFile((Context)context, (String)modelPath);
        Intrinsics.checkNotNullExpressionValue((Object)mappedByteBuffer, (String)"FileUtil.loadMappedFile(\u2026      modelPath\n        )");
        MappedByteBuffer tfliteModel = mappedByteBuffer;
        switch (Classifier$WhenMappings.$EnumSwitchMapping$0[device.ordinal()]) {
            case 1: {
                this.tfliteOptions.setUseXNNPACK(true);
                break;
            }
        }
        this.tfliteOptions.setNumThreads(numThreads);
        this.tflite = new Interpreter((ByteBuffer)tfliteModel, this.tfliteOptions);
        String string2 = this.getLabelPath();
        Intrinsics.checkNotNull((Object)string2);
        String labelPath = string2;
        List list = FileUtil.loadLabels((Context)context, (String)labelPath);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"FileUtil.loadLabels(context, labelPath)");
        this.labels = list;
        int imageTensorIndex = 0;
        Interpreter interpreter = this.tflite;
        Intrinsics.checkNotNull((Object)interpreter);
        int[] imageShape = interpreter.getInputTensor(imageTensorIndex).shape();
        this.imageSizeY = imageShape[1];
        this.imageSizeX = imageShape[2];
        Interpreter interpreter2 = this.tflite;
        Intrinsics.checkNotNull((Object)interpreter2);
        DataType imageDataType = interpreter2.getInputTensor(imageTensorIndex).dataType();
        int probabilityTensorIndex = 0;
        Interpreter interpreter3 = this.tflite;
        Intrinsics.checkNotNull((Object)interpreter3);
        int[] probabilityShape = interpreter3.getOutputTensor(probabilityTensorIndex).shape();
        Interpreter interpreter4 = this.tflite;
        Intrinsics.checkNotNull((Object)interpreter4);
        DataType probabilityDataType = interpreter4.getOutputTensor(probabilityTensorIndex).dataType();
        this.inputImageBuffer = new TensorImage(imageDataType);
        TensorBuffer tensorBuffer = TensorBuffer.createFixedSize((int[])probabilityShape, (DataType)probabilityDataType);
        Intrinsics.checkNotNullExpressionValue((Object)tensorBuffer, (String)"TensorBuffer.createFixed\u2026ape, probabilityDataType)");
        this.outputProbabilityBuffer = tensorBuffer;
        TensorOperator postProcessNormalizeOp = this.getPostProcessNormalizeOp();
        TensorProcessor tensorProcessor = new TensorProcessor.Builder().add(postProcessNormalizeOp).build();
        Intrinsics.checkNotNullExpressionValue((Object)tensorProcessor, (String)"TensorProcessor.Builder(\u2026ocessNormalizeOp).build()");
        this.probabilityProcessor = tensorProcessor;
        Util.Companion.printLog("Created a Tensor flow Lite Age Classifier.");
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0003\b\u0080\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003\u00a8\u0006\u0004"}, d2={"Lcom/darwin/viola/age/Classifier$Model;", "", "(Ljava/lang/String;I)V", "QUANTIZED_MOBILE_NET", "age_release"})
    public static final class Model
    extends Enum<Model> {
        public static final /* enum */ Model QUANTIZED_MOBILE_NET;
        private static final /* synthetic */ Model[] $VALUES;

        static {
            Model[] modelArray = new Model[1];
            Model[] modelArray2 = modelArray;
            modelArray[0] = QUANTIZED_MOBILE_NET = new Model();
            $VALUES = modelArray;
        }

        public static Model[] values() {
            return (Model[])$VALUES.clone();
        }

        public static Model valueOf(String string) {
            return Enum.valueOf(Model.class, string);
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0003\b\u0080\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003\u00a8\u0006\u0004"}, d2={"Lcom/darwin/viola/age/Classifier$Device;", "", "(Ljava/lang/String;I)V", "CPU", "age_release"})
    public static final class Device
    extends Enum<Device> {
        public static final /* enum */ Device CPU;
        private static final /* synthetic */ Device[] $VALUES;

        static {
            Device[] deviceArray = new Device[1];
            Device[] deviceArray2 = deviceArray;
            deviceArray[0] = CPU = new Device();
            $VALUES = deviceArray;
        }

        public static Device[] values() {
            return (Device[])$VALUES.clone();
        }

        public static Device valueOf(String string) {
            return Enum.valueOf(Device.class, string);
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0007\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0004J\"\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u0012H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/darwin/viola/age/Classifier$Companion;", "", "()V", "MAX_RESULTS", "", "create", "Lcom/darwin/viola/age/Classifier;", "context", "Landroid/content/Context;", "model", "Lcom/darwin/viola/age/Classifier$Model;", "device", "Lcom/darwin/viola/age/Classifier$Device;", "numThreads", "getTopKProbability", "", "Lcom/darwin/viola/age/AgeRecognition;", "labelProb", "", "", "", "age_release"})
    public static final class Companion {
        @NotNull
        public final Classifier create(@NotNull Context context, @NotNull Model model, @NotNull Device device, int numThreads) throws IOException {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)((Object)model), (String)"model");
            Intrinsics.checkNotNullParameter((Object)((Object)device), (String)"device");
            if (model != Model.QUANTIZED_MOBILE_NET) {
                throw (Throwable)new UnsupportedOperationException();
            }
            return new AgeClassifierQuantizedMobileNet(context, device, numThreads);
        }

        /*
         * WARNING - void declaration
         */
        private final List<AgeRecognition> getTopKProbability(Map<String, Float> labelProb) {
            PriorityQueue<AgeRecognition> pq2 = new PriorityQueue<AgeRecognition>(3, getTopKProbability.pq.1.INSTANCE);
            Object object = labelProb;
            int n = 0;
            Iterator<Map.Entry<String, Float>> iterator = object.entrySet().iterator();
            while (iterator.hasNext()) {
                void key;
                Map.Entry<String, Float> entry;
                Map.Entry<String, Float> entry2 = entry = iterator.next();
                boolean bl = false;
                object = entry2.getKey();
                entry2 = entry;
                bl = false;
                float value = ((Number)entry2.getValue()).floatValue();
                pq2.add(new AgeRecognition((String)key, value));
            }
            ArrayList<AgeRecognition> recognitions = new ArrayList<AgeRecognition>();
            int recognitionsSize = RangesKt.coerceAtMost((int)pq2.size(), (int)3);
            int key = 0;
            n = recognitionsSize;
            while (key < n) {
                void i;
                AgeRecognition poll = (AgeRecognition)pq2.poll();
                if (poll != null) {
                    AgeRecognition ageRecognition;
                    boolean bl = false;
                    boolean bl2 = false;
                    AgeRecognition it = ageRecognition;
                    boolean bl3 = false;
                    float confidence = poll.getConfidence() * (float)100;
                    recognitions.add(AgeRecognition.copy$default(poll, null, confidence, 1, null));
                }
                ++i;
            }
            return recognitions;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

