/*
 * Decompiled with CFR 0.152.
 */
package com.darwin.viola.age;

import android.content.Context;
import android.graphics.Bitmap;
import com.darwin.viola.age.AgeClassificationListener;
import com.darwin.viola.age.AgeRecognition;
import com.darwin.viola.age.Classifier;
import com.darwin.viola.age.Util;
import com.darwin.viola.age.ViolaAgeClassifier;
import java.io.IOException;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011J\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u0017R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/darwin/viola/age/ViolaAgeClassifier;", "", "listener", "Lcom/darwin/viola/age/AgeClassificationListener;", "(Lcom/darwin/viola/age/AgeClassificationListener;)V", "classifier", "Lcom/darwin/viola/age/Classifier;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<set-?>", "", "isInitialized", "()Z", "dispose", "", "findAgeAsync", "faceBitmap", "Landroid/graphics/Bitmap;", "findAgeSynchronized", "", "Lcom/darwin/viola/age/AgeRecognition;", "initialize", "context", "Landroid/content/Context;", "age_release"})
public final class ViolaAgeClassifier {
    private Classifier classifier;
    private boolean isInitialized;
    private final CoroutineScope coroutineScope;
    private final AgeClassificationListener listener;

    public final boolean isInitialized() {
        return this.isInitialized;
    }

    public final void initialize(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        if (!this.isInitialized) {
            Util.Companion.printLog("Initializing Viola age classifier.");
            Classifier.Model model = Classifier.Model.QUANTIZED_MOBILE_NET;
            Classifier.Device device = Classifier.Device.CPU;
            try {
                this.classifier = Classifier.Companion.create(context, model, device, 1);
                this.isInitialized = true;
            }
            catch (IOException e) {
                String error = "Failed to create age classifier: " + e.getClass().getCanonicalName() + '(' + e.getMessage() + ')';
                Util.Companion.printLog(error);
                this.listener.onAgeClassificationError(error);
            }
        }
    }

    public final void dispose() {
        Util.Companion.printLog("Disposing age classifier and its resources.");
        this.isInitialized = false;
        Classifier classifier = this.classifier;
        if (classifier == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"classifier");
        }
        classifier.close();
    }

    public final void findAgeAsync(@NotNull Bitmap faceBitmap) {
        Intrinsics.checkParameterIsNotNull((Object)faceBitmap, (String)"faceBitmap");
        if (this.isInitialized) {
            Util.Companion.printLog("Processing face bitmap for age classification.");
            BuildersKt.launch$default((CoroutineScope)this.coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, faceBitmap, null){
                private CoroutineScope p$;
                Object L$0;
                Object L$1;
                int label;
                final /* synthetic */ ViolaAgeClassifier this$0;
                final /* synthetic */ Bitmap $faceBitmap;

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            void results;
                            ResultKt.throwOnFailure((Object)$result);
                            CoroutineScope $this$launch = this.p$;
                            Ref.ObjectRef objectRef = new Ref.ObjectRef();
                            objectRef.element = ViolaAgeClassifier.access$getClassifier$p(this.this$0).recognizeImage(this.$faceBitmap, 0);
                            Util.Companion.printLog("Age classification completed, sending back the result.");
                            this.L$0 = $this$launch;
                            this.L$1 = results;
                            this.label = 1;
                            Object object2 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getMain()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, (Ref.ObjectRef)results, null){
                                private CoroutineScope p$;
                                int label;
                                final /* synthetic */ findAgeAsync.1 this$0;
                                final /* synthetic */ Ref.ObjectRef $results;

                                @Nullable
                                public final Object invokeSuspend(@NotNull Object $result) {
                                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)$result);
                                            CoroutineScope $this$withContext = this.p$;
                                            ViolaAgeClassifier.access$getListener$p(this.this$0.this$0).onAgeClassificationResult((List)this.$results.element);
                                            return Unit.INSTANCE;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }
                                {
                                    this.this$0 = var1_1;
                                    this.$results = objectRef;
                                    super(2, continuation);
                                }

                                @NotNull
                                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                                    Intrinsics.checkParameterIsNotNull(completion, (String)"completion");
                                    Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                                    CoroutineScope coroutineScope = function2.p$ = (CoroutineScope)value;
                                    return function2;
                                }

                                public final Object invoke(Object object, Object object2) {
                                    return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }), (Continuation)this);
                            if (object2 != object) return Unit.INSTANCE;
                            return object;
                        }
                        case 1: {
                            Ref.ObjectRef results = (Ref.ObjectRef)this.L$1;
                            CoroutineScope $this$launch = (CoroutineScope)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object2 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }
                {
                    this.this$0 = violaAgeClassifier;
                    this.$faceBitmap = bitmap;
                    super(2, continuation);
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                    Intrinsics.checkParameterIsNotNull(completion, (String)"completion");
                    Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                    CoroutineScope coroutineScope = function2.p$ = (CoroutineScope)value;
                    return function2;
                }

                public final Object invoke(Object object, Object object2) {
                    return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        } else {
            Util.Companion.printLog("Viola age classifier is not initialized.");
            this.listener.onAgeClassificationError("Viola age classifier is not initialized.");
        }
    }

    @NotNull
    public final List<AgeRecognition> findAgeSynchronized(@NotNull Bitmap faceBitmap) throws IllegalStateException {
        Intrinsics.checkParameterIsNotNull((Object)faceBitmap, (String)"faceBitmap");
        if (this.isInitialized) {
            Util.Companion.printLog("Processing face bitmap in synchronized manner for age classification.");
            Classifier classifier = this.classifier;
            if (classifier == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"classifier");
            }
            return classifier.recognizeImage(faceBitmap, 0);
        }
        Util.Companion.printLog("Viola age classifier is not initialized. Throwing exception.");
        throw (Throwable)new IllegalStateException("Viola age classifier is not initialized.");
    }

    public ViolaAgeClassifier(@NotNull AgeClassificationListener listener) {
        Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
        this.listener = listener;
        this.coroutineScope = CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getIO()));
        Util.Companion.setDebug(true);
    }

    public static final /* synthetic */ Classifier access$getClassifier$p(ViolaAgeClassifier $this) {
        Classifier classifier = $this.classifier;
        if (classifier == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"classifier");
        }
        return classifier;
    }

    public static final /* synthetic */ void access$setClassifier$p(ViolaAgeClassifier $this, Classifier classifier) {
        $this.classifier = classifier;
    }

    public static final /* synthetic */ AgeClassificationListener access$getListener$p(ViolaAgeClassifier $this) {
        return $this.listener;
    }
}

