/*
 * Decompiled with CFR 0.152.
 */
package com.daprlabs.aaron.swipedeck.Utility;

import android.animation.Animator;
import android.animation.TimeInterpolator;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewPropertyAnimator;
import android.view.animation.OvershootInterpolator;
import com.daprlabs.aaron.swipedeck.SwipeDeck;
import com.daprlabs.aaron.swipedeck.Utility.SwipeCallback;
import java.util.ArrayList;

public class SwipeListener
implements View.OnTouchListener {
    private float ROTATION_DEGREES = 15.0f;
    float OPACITY_END = 0.33f;
    private int initialX;
    private int initialY;
    private int mActivePointerId;
    private float initialXPress;
    private float initialYPress;
    private ViewGroup parent;
    private float parentWidth;
    private int paddingLeft;
    private View card;
    SwipeCallback callback;
    private boolean deactivated;
    private View rightView;
    private View leftView;
    private ArrayList<View> underCards;
    private int cardSpacing;
    private int xScale;
    private String TAG = "SwipeListener";
    private boolean click = true;

    public SwipeListener(View card, SwipeCallback callback, int initialX, int initialY, float rotation, float opacityEnd) {
        this.card = card;
        this.initialX = initialX;
        this.initialY = initialY;
        this.callback = callback;
        this.parent = (ViewGroup)card.getParent();
        this.parentWidth = this.parent.getWidth();
        this.ROTATION_DEGREES = rotation;
        this.OPACITY_END = opacityEnd;
        this.paddingLeft = ((ViewGroup)card.getParent()).getPaddingLeft();
    }

    public SwipeListener(View card, SwipeCallback callback, int initialX, int initialY, float rotation, float opacityEnd, SwipeDeck parent) {
        this.card = card;
        this.initialX = initialX;
        this.initialY = initialY;
        this.callback = callback;
        this.parent = parent;
        this.parentWidth = parent.getWidth();
        this.ROTATION_DEGREES = rotation;
        this.OPACITY_END = opacityEnd;
        this.paddingLeft = parent.getPaddingLeft();
    }

    public boolean onTouch(View v, MotionEvent event) {
        if (this.deactivated) {
            return false;
        }
        switch (event.getAction() & 0xFF) {
            case 0: {
                this.click = true;
                v.clearAnimation();
                this.mActivePointerId = event.getPointerId(0);
                float x = event.getX();
                float y = event.getY();
                if (event.findPointerIndex(this.mActivePointerId) == 0) {
                    this.callback.cardActionDown();
                }
                this.initialXPress = x;
                this.initialYPress = y;
                break;
            }
            case 2: {
                int pointerIndex = event.findPointerIndex(this.mActivePointerId);
                if (pointerIndex < 0 || pointerIndex > 0) break;
                float xMove = event.getX(pointerIndex);
                float yMove = event.getY(pointerIndex);
                float dx = xMove - this.initialXPress;
                float dy = yMove - this.initialYPress;
                Log.d((String)"X:", (String)("" + v.getX()));
                if ((int)this.initialXPress == 0 && (int)this.initialYPress == 0) break;
                float posX = this.card.getX() + dx;
                float posY = this.card.getY() + dy;
                if (Math.abs(dx + dy) > 5.0f) {
                    this.click = false;
                }
                this.card.setX(posX);
                this.card.setY(posY);
                this.animateUnderCards(posX, this.card.getWidth());
                float distobjectX = posX - (float)this.initialX;
                float rotation = this.ROTATION_DEGREES * 2.0f * distobjectX / this.parentWidth;
                this.card.setRotation(rotation);
                if (this.rightView == null || this.leftView == null) break;
                float alpha = (posX - (float)this.paddingLeft) / (this.parentWidth * this.OPACITY_END);
                this.rightView.setAlpha(alpha);
                this.leftView.setAlpha(-alpha);
                break;
            }
            case 1: {
                this.checkCardForEvent();
                if (event.findPointerIndex(this.mActivePointerId) == 0) {
                    this.callback.cardActionUp();
                }
                if (!this.click) break;
                v.performClick();
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    public void checkCardForEvent() {
        if (this.cardBeyondLeftBorder()) {
            this.animateOffScreenLeft(SwipeDeck.ANIMATION_DURATION).setListener(new Animator.AnimatorListener(){

                public void onAnimationStart(Animator animation) {
                }

                public void onAnimationEnd(Animator animation) {
                    SwipeListener.this.callback.cardOffScreen(SwipeListener.this.card);
                }

                public void onAnimationCancel(Animator animation) {
                    Log.d((String)"SwipeListener", (String)"Animation Cancelled");
                }

                public void onAnimationRepeat(Animator animation) {
                }
            });
            this.callback.cardSwipedLeft(this.card);
            this.deactivated = true;
        } else if (this.cardBeyondRightBorder()) {
            this.animateOffScreenRight(SwipeDeck.ANIMATION_DURATION).setListener(new Animator.AnimatorListener(){

                public void onAnimationStart(Animator animation) {
                }

                public void onAnimationEnd(Animator animation) {
                    SwipeListener.this.callback.cardOffScreen(SwipeListener.this.card);
                }

                public void onAnimationCancel(Animator animation) {
                }

                public void onAnimationRepeat(Animator animation) {
                }
            });
            this.callback.cardSwipedRight(this.card);
            this.deactivated = true;
        } else {
            this.resetCardPosition();
        }
    }

    private boolean cardBeyondLeftBorder() {
        return this.card.getX() + (float)(this.card.getWidth() / 2) < this.parentWidth / 4.0f;
    }

    private boolean cardBeyondRightBorder() {
        return this.card.getX() + (float)(this.card.getWidth() / 2) > this.parentWidth / 4.0f * 3.0f;
    }

    private ViewPropertyAnimator resetCardPosition() {
        if (this.rightView != null) {
            this.rightView.setAlpha(0.0f);
        }
        if (this.leftView != null) {
            this.leftView.setAlpha(0.0f);
        }
        return this.card.animate().setDuration((long)SwipeDeck.ANIMATION_DURATION).setInterpolator((TimeInterpolator)new OvershootInterpolator(1.5f)).x((float)this.initialX).y((float)this.initialY).rotation(0.0f).translationX(0.0f);
    }

    private ViewPropertyAnimator animateOffScreenLeft(int duration) {
        return this.card.animate().setDuration((long)SwipeDeck.ANIMATION_DURATION).x(-this.parentWidth).y(0.0f).rotation(-30.0f);
    }

    private ViewPropertyAnimator animateOffScreenRight(int duration) {
        return this.card.animate().setDuration((long)SwipeDeck.ANIMATION_DURATION).x(this.parentWidth * 2.0f).y(0.0f).rotation(30.0f);
    }

    public void swipeCardLeft(int duration) {
        this.animateOffScreenLeft(duration);
    }

    public void swipeCardRight(int duration) {
        this.animateOffScreenRight(duration);
    }

    public void setRightView(View image) {
        this.rightView = image;
    }

    public void setLeftView(View image) {
        this.leftView = image;
    }

    private void animateUnderCards(float xVal, int cardWidth) {
        float xValMid = xVal + (float)(cardWidth / 2);
    }
}

