/*
 * Decompiled with CFR 0.152.
 */
package com.daprlabs.aaron.swipedeck.Utility;

import com.daprlabs.aaron.swipedeck.CardContainer;
import java.util.LinkedList;

public class Deck<T extends CardContainer> {
    private LinkedList<T> internal = new LinkedList();
    private DeckEventListener listener;

    public Deck(DeckEventListener listener) {
        this.listener = listener;
    }

    public void addBack(T t) {
        this.addLast(t);
    }

    public void addFront(T t) {
        this.addFirst(t);
    }

    public T getBack() {
        return this.getLast();
    }

    public T getFront() {
        return this.getFirst();
    }

    public void removeFront() {
        this.removeFirst();
    }

    public void removeBack() {
        this.removeLast();
    }

    public T get(int pos) {
        return (T)((CardContainer)this.internal.get(pos));
    }

    public int size() {
        return this.internal.size();
    }

    public void clear() {
        while (this.size() > 0) {
            this.removeFirst();
        }
    }

    private void updateItemPositions() {
        for (int i = 0; i < this.internal.size(); ++i) {
            ((CardContainer)this.internal.get(i)).setPositionWithinViewGroup(i);
        }
    }

    private void addFirst(T t) {
        this.internal.addFirst(t);
        this.updateItemPositions();
        this.listener.itemAddedFront(t);
    }

    private void addLast(T t) {
        this.internal.addLast(t);
        this.updateItemPositions();
        this.listener.itemAddedBack(t);
    }

    private T removeFirst() {
        CardContainer toRemove = (CardContainer)this.internal.removeFirst();
        this.updateItemPositions();
        this.listener.itemRemovedFront(toRemove);
        return (T)toRemove;
    }

    private T removeLast() {
        CardContainer toRemove = (CardContainer)this.internal.removeLast();
        this.updateItemPositions();
        this.listener.itemRemovedBack(toRemove);
        return (T)toRemove;
    }

    private T getFirst() {
        CardContainer getFirst = null;
        if (this.internal.size() > 0) {
            getFirst = (CardContainer)this.internal.getFirst();
        }
        return (T)getFirst;
    }

    private T getLast() {
        CardContainer getLast = (CardContainer)this.internal.getLast();
        return (T)getLast;
    }

    public static interface DeckEventListener {
        public void itemAddedFront(Object var1);

        public void itemAddedBack(Object var1);

        public void itemRemovedFront(Object var1);

        public void itemRemovedBack(Object var1);
    }
}

