/*
 * Decompiled with CFR 0.152.
 */
package com.daprlabs.aaron.swipedeck;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.database.DataSetObserver;
import android.os.Build;
import android.support.v4.view.ViewCompat;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Adapter;
import android.widget.FrameLayout;
import com.daprlabs.aaron.swipedeck.CardContainer;
import com.daprlabs.aaron.swipedeck.R;
import com.daprlabs.aaron.swipedeck.Utility.Deck;
import com.daprlabs.aaron.swipedeck.Utility.RxBus;
import com.daprlabs.aaron.swipedeck.Utility.SwipeCallback;

public class SwipeDeck
extends FrameLayout {
    private static final String TAG = "SwipeDeck MainActivity";
    private int NUMBER_OF_SIMULTANEOUS_CARDS;
    public float OPACITY_END;
    public float ROTATION_DEGREES;
    private float CARD_SPACING;
    public static int ANIMATION_DURATION = 200;
    public boolean RENDER_ABOVE;
    public boolean SWIPE_ENABLED;
    private boolean mHasStableIds;
    private RxBus bus = new RxBus();
    private Adapter mAdapter;
    private DataSetObserver observer;
    private Deck<CardContainer> deck;
    private SwipeDeckCallback callback;
    private CardContainer buffer;
    private int leftImageResource;
    private int rightImageResource;
    private int adapterIndex = 0;

    public SwipeDeck(Context context, AttributeSet attrs) {
        super(context, attrs);
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.SwipeDeck2, 0, 0);
        this.NUMBER_OF_SIMULTANEOUS_CARDS = a.getInt(R.styleable.SwipeDeck2_max_visible, 3);
        this.OPACITY_END = a.getFloat(R.styleable.SwipeDeck2_opacity_end, 0.33f);
        this.ROTATION_DEGREES = a.getFloat(R.styleable.SwipeDeck2_rotation_degrees, 15.0f);
        this.CARD_SPACING = a.getDimension(R.styleable.SwipeDeck2_card_spacing, 15.0f);
        this.RENDER_ABOVE = a.getBoolean(R.styleable.SwipeDeck2_render_above, true);
        this.SWIPE_ENABLED = a.getBoolean(R.styleable.SwipeDeck2_swipe_enabled, true);
        this.deck = new Deck(new Deck.ListEventListener(){

            @Override
            public void itemAdded(Object object, int position) {
                ((CardContainer)SwipeDeck.this.deck.get(position)).setPositionWithinViewGroup(position);
                if (position == 0) {
                    ((CardContainer)SwipeDeck.this.deck.get(0)).setSwipeEnabled(true);
                }
                SwipeDeck.this.renderDeck();
            }

            @Override
            public void itemRemoved(Object object) {
                SwipeDeck.this.buffer = (CardContainer)object;
                int index = 0;
                if (index < SwipeDeck.this.deck.size()) {
                    ((CardContainer)SwipeDeck.this.deck.get(index)).setSwipeEnabled(true);
                }
                SwipeDeck.this.buffer.cleanupAndRemoveView();
                SwipeDeck.this.addNextView();
                SwipeDeck.this.renderDeck();
            }

            @Override
            public void itemPositionChanged(Object object, int position) {
                SwipeDeck.this.removeAllViews();
                ((CardContainer)SwipeDeck.this.deck.get(position)).setPositionWithinViewGroup(position);
                SwipeDeck.this.renderDeck();
            }
        });
        this.setClipToPadding(false);
        this.setClipChildren(false);
        this.setWillNotDraw(false);
        if (this.RENDER_ABOVE) {
            ViewCompat.setTranslationZ((View)this, (float)Float.MAX_VALUE);
        }
    }

    public void setAdapter(final Adapter adapter) {
        if (this.mAdapter != null) {
            this.mAdapter.unregisterDataSetObserver(this.observer);
        }
        this.mHasStableIds = adapter.hasStableIds();
        this.mAdapter = adapter;
        this.observer = new DataSetObserver(){

            public void onChanged() {
                super.onChanged();
                int deckSize = SwipeDeck.this.deck.size();
                if (deckSize < SwipeDeck.this.NUMBER_OF_SIMULTANEOUS_CARDS) {
                    for (int i = deckSize; i < SwipeDeck.this.NUMBER_OF_SIMULTANEOUS_CARDS; ++i) {
                        SwipeDeck.this.addNextView();
                    }
                }
                if (adapter.getCount() == 0) {
                    SwipeDeck.this.deck.clear();
                    SwipeDeck.this.adapterIndex = 0;
                }
            }

            public void onInvalidated() {
                SwipeDeck.this.deck.clear();
                SwipeDeck.this.removeAllViews();
                SwipeDeck.this.requestLayout();
            }
        };
        adapter.registerDataSetObserver(this.observer);
        this.removeAllViewsInLayout();
        this.requestLayout();
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        int deckSize;
        super.onLayout(changed, left, top, right, bottom);
        if (this.mAdapter == null || this.mAdapter.getCount() == 0) {
            this.removeAllViewsInLayout();
            return;
        }
        for (int i = deckSize = this.deck.size(); i < this.NUMBER_OF_SIMULTANEOUS_CARDS; ++i) {
            this.addNextView();
        }
    }

    private void addNextView() {
        if (this.adapterIndex < this.mAdapter.getCount()) {
            View newBottomChild = this.mAdapter.getView(this.adapterIndex, null, (ViewGroup)this);
            newBottomChild.setLayerType(2, null);
            newBottomChild.setAlpha(0.0f);
            newBottomChild.setY((float)this.getPaddingTop());
            CardContainer card = new CardContainer(newBottomChild, this, new SwipeCallback(){

                @Override
                public void cardSwipedLeft(View card) {
                    Log.d((String)SwipeDeck.TAG, (String)"card swiped left");
                    for (int i = 0; i < SwipeDeck.this.deck.size(); ++i) {
                        if (((CardContainer)SwipeDeck.this.deck.get(i)).getCard() != card) continue;
                        SwipeDeck.this.deck.remove(SwipeDeck.this.deck.get(i));
                        break;
                    }
                }

                @Override
                public void cardSwipedRight(View card) {
                    Log.d((String)SwipeDeck.TAG, (String)"card swiped right");
                    for (int i = 0; i < SwipeDeck.this.deck.size(); ++i) {
                        if (((CardContainer)SwipeDeck.this.deck.get(i)).getCard() != card) continue;
                        SwipeDeck.this.deck.remove(SwipeDeck.this.deck.get(i));
                        break;
                    }
                }

                @Override
                public void cardOffScreen(View card) {
                }

                @Override
                public void cardActionDown() {
                }

                @Override
                public void cardActionUp() {
                }
            });
            if (this.leftImageResource != 0) {
                card.setLeftImageResource(this.leftImageResource);
            }
            if (this.rightImageResource != 0) {
                card.setRightImageResource(this.rightImageResource);
            }
            if (this.mHasStableIds) {
                card.setId(this.mAdapter.getItemId(this.adapterIndex));
            }
            this.deck.add(card);
            ++this.adapterIndex;
        }
    }

    private void renderDeck() {
        this.removeAllViews();
        for (int i = this.deck.size() - 1; i >= 0; --i) {
            CardContainer container = this.deck.get(i);
            View card = container.getCard();
            ViewGroup.LayoutParams params = card.getLayoutParams();
            if (params == null) {
                params = new ViewGroup.LayoutParams(-2, -2);
            }
            this.addViewInLayout(card, -1, params, true);
            int itemWidth = this.getWidth() - (this.getPaddingLeft() + this.getPaddingRight());
            int itemHeight = this.getHeight() - (this.getPaddingTop() + this.getPaddingBottom());
            card.measure(0x40000000 | itemWidth, 0x40000000 | itemHeight);
        }
        if (this.buffer != null) {
            View card = this.buffer.getCard();
            ViewGroup.LayoutParams params = card.getLayoutParams();
            if (params == null) {
                params = new ViewGroup.LayoutParams(-2, -2);
            }
            this.addViewInLayout(card, -1, params, true);
            int itemWidth = this.getWidth() - (this.getPaddingLeft() + this.getPaddingRight());
            int itemHeight = this.getHeight() - (this.getPaddingTop() + this.getPaddingBottom());
            card.measure(0x40000000 | itemWidth, 0x40000000 | itemHeight);
        }
        this.positionCards();
    }

    private void positionCards() {
        this.setZTranslations();
        for (int i = 0; i < this.deck.size(); ++i) {
            View card = this.deck.get(i).getCard();
            float offset = (int)((float)this.deck.get(i).getPositionWithinViewGroup() * this.CARD_SPACING);
            card.animate().setDuration((long)ANIMATION_DURATION).y((float)this.getPaddingTop() + offset).alpha(1.0f);
        }
    }

    public void setCallback(SwipeDeckCallback callback) {
        this.callback = callback;
    }

    public void swipeTopCardLeft(int duration) {
        if (this.deck.size() > 0) {
            this.deck.get(0).getSwipeListener().animateOffScreenLeft(duration);
            this.deck.remove(0);
        }
    }

    public void swipeTopCardRight(int duration) {
        if (this.deck.size() > 0) {
            this.deck.get(0).getSwipeListener().animateOffScreenRight(duration);
            this.deck.remove(0);
        }
    }

    public void setAdapterIndex(int index) {
        this.adapterIndex = index;
    }

    public int getAdapterIndex() {
        return this.adapterIndex;
    }

    public void clearBuffer() {
        this.buffer = null;
    }

    public void setLeftImage(int imageResource) {
        this.leftImageResource = imageResource;
    }

    public void setRightImage(int imageResource) {
        this.rightImageResource = imageResource;
    }

    @TargetApi(value=21)
    private void setZTranslations() {
        if (Build.VERSION.SDK_INT >= 21) {
            int count = this.getChildCount();
            for (int i = 0; i < count; ++i) {
                this.getChildAt(i).setTranslationZ((float)(i * 10));
            }
        }
    }

    public static interface SwipeDeckCallback {
        public void cardSwipedLeft(int var1);

        public void cardSwipedRight(int var1);
    }
}

