/*
 * Decompiled with CFR 0.152.
 */
package com.daprlabs.aaron.swipedeck.layouts;

import android.annotation.TargetApi;
import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import com.daprlabs.aaron.swipedeck.SwipeDeck;
import java.util.ArrayList;

public class SwipeRelativeLayout
extends RelativeLayout {
    public SwipeRelativeLayout(Context context) {
        super(context);
        this.setClipChildren(false);
    }

    public SwipeRelativeLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.setClipChildren(false);
    }

    public SwipeRelativeLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.setClipChildren(false);
    }

    @TargetApi(value=21)
    public SwipeRelativeLayout(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.setClipChildren(false);
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        int childCount = this.getChildCount();
        ViewGroup.LayoutParams params = this.getLayoutParams();
        ArrayList<View> children = new ArrayList<View>();
        View swipeDeck = null;
        for (int i = 0; i < childCount; ++i) {
            View child = this.getChildAt(i);
            if (child instanceof SwipeDeck) {
                swipeDeck = this.getChildAt(i);
                continue;
            }
            children.add(child);
        }
        this.removeAllViews();
        this.removeAllViewsInLayout();
        for (View v : children) {
            this.addViewInLayout(v, -1, v.getLayoutParams(), true);
        }
        if (swipeDeck != null) {
            this.addViewInLayout(swipeDeck, -1, swipeDeck.getLayoutParams(), true);
        }
        this.invalidate();
        this.requestLayout();
    }
}

